*CURSOR
* CURSOR File -- Interactive routine for measuring positions on plot which
*                can be stored to a file.
*
*        Parameters:
*        
*          FILE  -- Filename for storage of results. Unlike the majority
*                   of routines this will not be prompted for. If not
*                   set, no output will be possible.
*
*CURSOR 
      SUBROUTINE CURSOR(SPLIT, NSPLIT, MXSPLIT, CLOBBER, IFAIL)
*
* Interactive routine for calling up cursor. Assumes plot is open.
* 
* Arguments:
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
*
* Local variables
*
      INTEGER IFAIL, PGCURSE, NSPLIT, MXSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
      REAL X, Y
      LOGICAL STORE, OPEN, CLOBBER
      CHARACTER*1 CH
*
      STORE = .FALSE.
      OPEN = .FALSE.
      IF(NSPLIT.EQ.1) THEN
        STORE = .TRUE.
      ELSE IF(NSPLIT.GT.1) THEN
        WRITE(*,*) 'Too many parameters specified'
        IFAIL = 1
        RETURN
      END IF
      IF(STORE) THEN
        WRITE(*,*) 'Position of cursor can be displayed and stored'
      ELSE
        WRITE(*,*) 'Position of cursor can be displayed and stored'
      END IF
100   IF(STORE) THEN
        WRITE(*,*) 'D(isplay), S(tore), Q(uit)'
      ELSE
        WRITE(*,*) 'D(isplay), Q(uit)'
      END IF
      IFAIL = PGCURSE(X, Y, CH)
      IF(IFAIL.EQ.1) THEN
        CALL UPPER_CASE(CH)
        IF(CH.EQ.'D') THEN
          WRITE(*,*) 'X = ',X,', Y = ',Y
        ELSE IF(STORE .AND. CH.EQ.'S') THEN
          WRITE(*,*) 'X = ',X,', Y = ',Y
          IF(.NOT.OPEN) THEN
            IF(CLOBBER) THEN
              OPEN(UNIT=31,FILE=SPLIT(1),STATUS='UNKNOWN',IOSTAT=IFAIL)
            ELSE
              OPEN(UNIT=31,FILE=SPLIT(1),STATUS='NEW',IOSTAT=IFAIL)
            END IF
            IF(IFAIL.NE.0) THEN
              WRITE(*,*) 'Could not open ',SPLIT(1)
              RETURN
            ELSE
              OPEN = .TRUE.
            END IF
          END IF
          WRITE(31,*,IOSTAT=IFAIL) X, Y
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to write to ',SPLIT(1)
            CLOSE(UNIT=31)
            RETURN
          END IF
        ELSE IF(CH.EQ.'Q') THEN
          IF(OPEN) CLOSE(UNIT=31)
          IFAIL = 0
          RETURN
        END IF
      END IF
      GOTO 100
      END
