*CSET
* CSET N1 N2 CONST SET -- Sets regions of spectra to constant value
* 
* Parameters
*           N1    -- First spectrum to set
*           N2    -- Last spectrum to set
*           CONST -- Value to set
*           SET   -- Set mask or not
*
* Related routines: LIMIT, INTERP
*CSET
*LIMIT
* LIMIT N1 N2 LLIM ULIM SET -- Limits range of regions of spectra 
* 
* Parameters
*           N1    -- First spectrum to set
*           N2    -- Last spectrum to set
*           LLIM  -- Lower limit of modified spectra
*           ULIM  -- Upper limit of modified spectra
*           SET   -- Set mask or not
* Related routines: CSET, INTERP
*LIMIT
*INTERP
* INTERP N1 N2 SET -- Interpolate over regions of spectra 
* 
* Parameters
*           N1    -- First spectrum to set
*           N2    -- Last spectrum to set
*           SET   -- Set mask or not
* 
* Regions defined by the mask are linearly interplated between the two 
* neighbouring unmasked data points. If there is only one unmasked point, 
* then a constant is used instead.
*
* Related routines: CSET, LIMIT
*INTERP
      SUBROUTINE CSET(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &MXSINTR, MXSREAL, MASK, MXWORK, SLOTS, MXSLOTS,
     &METHOD, WORK1, WORK2, WORK3, IFAIL)
*
* Sets regions of spectra to a constant, limits their value, or interpolates
* over them.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
* >  L     MASK(MXWORK)       -- Mask array
* >  I     MXWORK             -- Size of work array
* >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
* >  I     MXSLOTS             -- Maximum number of entries
*    C     METHOD             -- 'C' for set to a constant
*                                'L' to limit range
*                                'I' to interpolate
*    R     WORK1(MXWORK)        Work arrays
*    R     WORK2(MXWORK)
*    R     WORK3(MXWORK)
*    I     MXWORK
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Search parameters
*
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT), METHOD
*
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
      INTEGER MXWORK
      LOGICAL MASK(MXWORK)
      REAL WORK1(MXWORK), WORK2(MXWORK), WORK3(MXWORK)
*
* Local variables
*
      INTEGER I, J,   NF, NL
      INTEGER   NCOM
      REAL GET_FLX, GET_ERF, CFRAT, FLX
      INTEGER SLOT1, SLOT2
      INTEGER  IFAIL
      INTEGER  MAXSPEC
      REAL RATIO, ULIM, LLIM
      LOGICAL SELECT, SAMECI
      LOGICAL DEFAULT
      REAL CONST
      DOUBLE PRECISION VEARTH
      CHARACTER*3 SET, PROMPT*40

      DATA CONST/0./
      DATA SLOT1, SLOT2/1,1/
      DATA LLIM, ULIM/0., 1./
*
************************************************************************
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
*
* First slot
*
      IF(METHOD.EQ.'C') THEN
        PROMPT = 'First spectrum to set'
      ELSE IF(METHOD.EQ.'L') THEN
        PROMPT = 'First spectrum to limit'
      ELSE IF(METHOD.EQ.'I') THEN
        PROMPT = 'First spectrum to interpolate'
      END IF      
      CALL INTR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM,
     &DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
*
* Second slot
*
      SLOT2 = MAX(SLOT2, SLOT1)
      IF(METHOD.EQ.'C') THEN
        PROMPT = 'Last spectrum to set'
      ELSE IF(METHOD.EQ.'L') THEN
        PROMPT = 'Last spectrum to limit'
      ELSE IF(METHOD.EQ.'I') THEN
        PROMPT = 'Last spectrum to interpolate'
      END IF      
      CALL INTR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM,
     &DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) '0,0 only for list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          IF(METHOD.EQ.'C') THEN
            WRITE(*,*) 'Enter list of spectra to set region constant'
          ELSE IF(METHOD.EQ.'L') THEN
            WRITE(*,*) 'Enter list of spectra to limit'
          ELSE IF(METHOD.EQ.'I') THEN
            WRITE(*,*) 'Enter list of spectra to interpolate'
          END IF
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      IF(METHOD.EQ.'C') THEN 
        CALL REAL_IN('Value of constant', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, CONST, -1.E30, 1.E30, IFAIL)
      ELSE IF(METHOD.EQ.'L') THEN
        CALL REAL_IN('Lower limit', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, LLIM, -1.E30, 1.E30, IFAIL)
        ULIM = MAX(LLIM, ULIM)
        CALL REAL_IN('Upper limit', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, ULIM, LLIM, 1.E30, IFAIL)
      END IF
      IF(IFAIL.NE.0) GOTO 999
      CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SET, IFAIL)
*
* Does a mask have to be set
*
      IF(SAMECI(SET,'YES')) THEN
        WRITE(*,*) ' '
        IF(METHOD.EQ.'C') THEN
          WRITE(*,*) 'Mask all regions to be set equal to the constant'
        ELSE IF(METHOD.EQ.'L') THEN
          WRITE(*,*) 'Mask all regions to be limited.'
        ELSE IF(METHOD.EQ.'I') THEN
          WRITE(*,*) 'Mask all regions to be interpolated over'
        END IF
        WRITE(*,*) ' '
        CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &       NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &       NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &       NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &       NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &       WORK2, WORK3, MXWORK, MASK)
        CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
        IF(SAMECI(SET,'YES')) THEN
           WRITE(*,*) 'No mask set'
           GOTO 999
        END IF
      ELSE
         CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
         IF(SAMECI(SET,'YES')) THEN
            WRITE(*,*) 'No mask set'
            GOTO 999
         END IF
      END IF
*     
*     Now process
*     Loop through spectra
*     
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NARC(SLOT).EQ.0 .AND. (NVMASK.GT.0 .OR.
     &           NWMASK.GT.0)) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no wavelength scale'
            WRITE(*,*) 'to interpret mask and will be skipped'
         ELSE IF(.NOT.SELECT( SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &           NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &           MXREAL, MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &           NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &           NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &           MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
            IF(NARC(SLOT).NE.0) THEN
*     
*     Search for double precision header item Vearth. 
*     
               CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &              HDDOUB, NDOUB, MXDOUB, IFAIL)
               IF(IFAIL.NE.0) 
     &              WRITE(*,*) 'No Vearth for slot ',SLOT,'; assume = 0'
               IFAIL = 0
            END IF
*     
*     Get mask
*     
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &           MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &           .TRUE.,VEARTH,IFAIL)
*     
            IF(METHOD.EQ.'C') THEN
               DO J = 1, NPIX(SLOT)
                  IF(MASK(J)) THEN
                     RATIO = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                     IF(CONST.EQ.0.) THEN
                        FLUX(J,SLOT)   = RATIO
                        COUNTS(J,SLOT) = 0.
                     ELSE
                        FLUX(J,SLOT)   = CONST
                        COUNTS(J,SLOT) = RATIO*CONST
                     END IF
                  END IF
               END DO
            ELSE IF(METHOD.EQ.'L') THEN
               DO J = 1, NPIX(SLOT)
                  IF(MASK(J)) THEN
                     FLX   = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
                     FLX   = MAX(LLIM, MIN(ULIM, FLX))
                     RATIO = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                     IF(FLX.EQ.0.) THEN
                        FLUX(J,SLOT)   = RATIO
                        COUNTS(J,SLOT) = 0.
                     ELSE
                        FLUX(J,SLOT)   = FLX
                        COUNTS(J,SLOT) = RATIO*FLX
                     END IF
                  END IF
               END DO
            ELSE IF(METHOD.EQ.'I') THEN
*     
*     Load data
*     
               DO J = 1, NPIX(SLOT)
                  WORK1(J) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
                  WORK2(J) = GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT),
     &                 FLUX(J,SLOT))
               END DO
*     
*     Interpolate across masked regions.
*     
               CALL REPLACE(WORK1, ERRORS(1,SLOT), MASK, .TRUE., 
     &              NPIX(SLOT), NF, NL, IFAIL)
               CALL REPLACE(WORK2, ERRORS(1,SLOT), MASK, .TRUE., 
     &              NPIX(SLOT), NF, NL, IFAIL)
*     
*     Store data
*     
               DO J = 1, NPIX(SLOT)
                  RATIO = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                  COUNTS(J,SLOT) = RATIO*WORK1(J)
                  ERRORS(J,SLOT) = RATIO*WORK2(J)
                  IF(COUNTS(J,SLOT).EQ.0) THEN
                     FLUX(J,SLOT) = RATIO
                  ELSE
                     FLUX(J,SLOT) = WORK1(J)
                  END IF
               END DO
            END IF
         END IF
      END DO
 999  RETURN
      END
