      SUBROUTINE CONTROL(NFIND, SPLIT, NSPLIT, MXSPLIT, COMMS, 
     &     NCOM, UCOMMS, UDEFS, NUSER, MXUSER, CONFRM, GSTART, 
     &     LSTART, PROMPT, IFAIL)
*
* Controller program. This has a complex logical structure which is
* briefly shown below. ---> means "can call". File1 and 2 refer to 
* top level and second level command files. Similarly with concatenated(1) etc.
* Note that although designed for 'molly' this routine is of general use
* and so molly specific references have been removed.
*
* Terminal input          ---> File1, user definition, concatenated(1), shell,
*                              calling program and user defined commands.
* File1                   ---> File2, user definition, concatenated(1), shell,
*                              calling program and user defined commands.
* File2                   ---> user definition, concatenated(1), shell,
*                              calling program and user defined commands
* Concatenated(1) command ---> shell, user defined and calling program commands
* User defined command    ---> concatenated(2) commands, shell and calling
*                              program commands
* Concatenated(2) command ---> shell and calling program commands
*
* Note restrictions which this implies such as :
*
*  (a) user defined commands cannot call other user defined commands or 
*      command files
*  (b) concatenated commands cannot call command files.
*  (c) Only 2 levels of command file are allowed.
*
*
* I NFIND          -- Number of command returned (then used if IF block to call
*                     appropriate routine)
* C SPLIT(MXSPLIT) -- Character array which returns with NSPLIT command
*                     arguments to be fed to command.
* I NSPLIT         -- Number of command arguments found
* I MXSPLIT        -- Maximum number of command arguments
* C COMMS(NCOM)    -- Names of commands
* I NCOM           -- Number of commands
* C UCOMMS(MXUSER) -- Names of user defined commands
* C UDEFS(MXUSER)  -- Definitions of user commands
* I NUSER          -- Number of user commands
* I MXUSER         -- Maximum number of user commands
* L CONFRM         -- TRUE to confirm commands
* C GSTART         -- Environment variablke for global startup file
* C LSTART         -- Standard name of local startup file
* C PROMPT         -- control prompt
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, MXUSER, NUSER
      INTEGER NFIND, IFAIL, NCOM
      LOGICAL CONFRM
      CHARACTER*(*) GSTART, LSTART, PROMPT
      CHARACTER*(*) COMMS(NCOM)
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*(*) UDEFS(MXUSER), UCOMMS(MXUSER)
      CHARACTER*512 COMMAND, FGETLIN
C
C     MXCOM  = Maximum number of concatenated commands
C     MXFPAR = Maximum number of command file parameters
C     MXUSPL = Maximum number of user command parameters
C
      INTEGER MXCOM
      PARAMETER (MXCOM=20)
      CHARACTER*256 CONCAT(MXCOM), UCAT(MXCOM)
      INTEGER MXFPAR, NFPAR1, NFPAR2
      PARAMETER (MXFPAR=30)
      CHARACTER*200 FPAR1(MXFPAR), FPAR2(MXFPAR)
      INTEGER MXUSPL, NUSPLIT
      PARAMETER (MXUSPL=100)
      CHARACTER*200 USPLIT(MXUSPL)
*
      INTEGER I, J, L, L1, L2, NCAT, NWIND, NUWIND
      INTEGER NUFIND, NUCAT, NPAR, LP, LB, LC
      LOGICAL FOPEN1, FOPEN2
      CHARACTER*10 USER
      CHARACTER*100 FILE1, FILE2
      LOGICAL SAME, SAMECI, START1, START2, LOUD, INTER
*
      INTEGER LENSTR, ISTSTR
c      INTEGER SYSTEM
c      EXTERNAL SYSTEM
      INTEGER LCOM1, LCOM2, FISATTY
      DATA LCOM1, LCOM2/79,80/
      DATA NCAT, NUCAT/0, 0/
      DATA START1/.TRUE./
      DATA START2/.TRUE./
      DATA LOUD/.TRUE./
      DATA INTER/.TRUE./
      DATA FOPEN1, FOPEN2/.FALSE., .FALSE./
      SAVE START1, INTER, LOUD
C
C     Get startup file first time through
C
      LP = LENSTR(PROMPT)
      IF(START1) THEN
C
C     Check whether interactive or not
C
        INTER = FISATTY().EQ.1
*
        START1 = .FALSE.
        WRITE(*,*) ' '
        CALL GETENV(GSTART, FILE1)
        OPEN(UNIT=51, FILE=FILE1, STATUS='OLD', IOSTAT=IFAIL)
        IF(IFAIL.EQ.0) THEN
          WRITE(*,*) 'Startup file found.'
          WRITE(*,*) ' '
          CLOSE(UNIT=51)
          COMMAND = '@'//FILE1
          LOUD = .FALSE.
          GOTO 20
        ELSE
          LOUD = .TRUE.
          WRITE(*,*) 'No startup file found'
          WRITE(*,*) ' '
          IF(START2) THEN
             START2 = .FALSE.
             WRITE(*,*) ' '
             OPEN(UNIT=51, FILE=LSTART, STATUS='OLD', IOSTAT=IFAIL)
             IF(IFAIL.EQ.0) THEN
                WRITE(*,*) 'Local startup file found.'
                WRITE(*,*) ' '
                CLOSE(UNIT=51)
                COMMAND = '@'//LSTART
                GOTO 20
             ELSE
                WRITE(*,*) 'No local startup file found'
                WRITE(*,*) ' '
             END IF      
          END IF
          LOUD   = .TRUE.
        END IF      
      END IF
C
C     First set control if we are already in the middle of handling
C     a command. If we are in the middle of a user command (NUCAT.GT.0)
C     we go to 400, else if we are in the middle of a concatenated command
C     we go to 300
C
      IF(IFAIL.NE.0) THEN
        GOTO 999
      ELSE IF(NUCAT.GT.0) THEN
        GOTO 400
      ELSE IF(NCAT.GT.0) THEN
        GOTO 300
      END IF

C
C     Main command level. If the session is identified as interactive
C     then the C based FGETLIN is used, otherwise standard FORTRAN
C     read is used.
C

10    IF(INTER) THEN
         COMMAND = FGETLIN(PROMPT)
      ELSE
         WRITE(*,'(A,$)') PROMPT(:LP)
         READ(*,'(A)') COMMAND
      END IF
*
      IF(COMMAND.EQ.' ' .OR. COMMAND(1:1).EQ.'#') GOTO 10
20    IF(CONFRM) WRITE(*,*) COMMAND(:LENSTR(COMMAND))
C
C     Check for first level command file (starts with @), but must not
C     have a ; indicating concatenation
C
      IF(SAME('@',COMMAND)) THEN
*
        IF(INDEX(COMMAND,';').GT.0) THEN
          IFAIL = 1
          WRITE(*,*) 'Calls to command files must be isolated'
          GOTO 999
        END IF
C
C     Locate file name
C      
        L1 = INDEX(COMMAND,'@')
        L1 = ISTSTR(COMMAND(L1+1:))+L1
        LB = INDEX(COMMAND(L1:),' ')
        LC = INDEX(COMMAND(L1:),',')
        IF(LB.GT.0 .AND. LC.GT.0) THEN
          L2 = L1 - 1 + MIN(LB,LC)
        ELSE IF(LB.GT.0) THEN
          L2 = L1 - 1 + LB
        ELSE IF(LC.GT.0) THEN
          L2 = L1 - 1 + LC
        ELSE
          L2 = LENSTR(COMMAND(L1:))+L1-1
        END IF
        FILE1 = COMMAND(L1:L2)
C
C     Unit LCOM1 must not be used anywhere else
C
        OPEN(UNIT=LCOM1,FILE=FILE1,STATUS='OLD',IOSTAT=IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Could not open ',FILE1(:LENSTR(FILE1))
          WRITE(*,*) 'First level command file aborted'
          GOTO 999
        END IF
        FOPEN1 = .TRUE.
        WRITE(*,*) 'Opened1: ',FILE1(:LENSTR(FILE1))
C
C     Store any parameters for the top level file. After this point
C     do not need to preserve 'COMMAND'
C
        CALL CSPLIT(COMMAND(L2+1:), FPAR1, NFPAR1, MXFPAR, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to store parameters for first level file'
          GOTO 999
        END IF
C
C     Read command from file. Will return here if FOPEN1
C
100     READ(LCOM1,'(A)',IOSTAT=IFAIL) COMMAND
        IF(IFAIL.LT.0) THEN
           WRITE(*,*) 'Closed1: ',FILE1(:LENSTR(FILE1))
           CLOSE(UNIT=LCOM1)
           FOPEN1 = .FALSE.
           IF(START2) THEN
              START2 = .FALSE.
              WRITE(*,*) ' '
              OPEN(UNIT=51, FILE=LSTART, STATUS='OLD', IOSTAT=IFAIL)
              IF(IFAIL.EQ.0) THEN
                 WRITE(*,*) 'Local startup file found.'
                 WRITE(*,*) ' '
                 CLOSE(UNIT=51)
                 COMMAND = '@'//LSTART
                 GOTO 20
              ELSE
                 WRITE(*,*) 'No local startup file found'
                 WRITE(*,*) ' '
              END IF      
           END IF
           LOUD   = .TRUE.
           GOTO 10
        ELSE IF(IFAIL.GT.0) THEN
           WRITE(*,*) 'Error reading first level command file'
           GOTO 999
        END IF
*
* Look for comment flag
*
        IF(COMMAND(1:1).EQ.'#') GOTO 100
*
* Substitute parameters (if not a definition)
*
        IF(INDEX(COMMAND,'==').EQ.0) THEN 
          CALL SUBPAR(COMMAND, FPAR1, NFPAR1, MXFPAR, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to substitute level 1 params'
            GOTO 999
          END IF
        END IF
*
* Check for second level command file
*
        IF(SAME('@',COMMAND)) THEN
*
           IF(INDEX(COMMAND,';').GT.0) THEN
              IFAIL = 1
              WRITE(*,*) 'Calls to command files must be isolated'
              GOTO 999
           END IF
*     
* Locate file name
*      
           L1 = INDEX(COMMAND,'@')
           L1 = ISTSTR(COMMAND(L1+1:))+L1
           LB = INDEX(COMMAND(L1:),' ')
           LC = INDEX(COMMAND(L1:),',')
           IF(LB.GT.0 .AND. LC.GT.0) THEN
              L2 = L1 - 1 + MIN(LB,LC)
           ELSE IF(LB.GT.0) THEN
              L2 = L1 - 1 + LB
           ELSE IF(LC.GT.0) THEN
              L2 = L1 - 1 + LC
           ELSE
              L2 = LENSTR(COMMAND(L1:))+L1-1
           END IF
           FILE2 = COMMAND(L1:L2)
*     
*     Unit LCOM2 must not be used anywhere else
*
           OPEN(UNIT=LCOM2,FILE=FILE2,STATUS='OLD',IOSTAT=IFAIL)
           IF(IFAIL.NE.0) THEN
              WRITE(*,*) 'Could not open ',FILE2(:LENSTR(FILE2))
              WRITE(*,*) 'Second level command file aborted'
              GOTO 999
           END IF
           WRITE(*,*) 'Opened2: ',FILE2(:LENSTR(FILE2))
           FOPEN2 = .TRUE.
*
* Store any parameters for the 2nd level file. 
*
          CALL CSPLIT(COMMAND(L2+1:), FPAR2, NFPAR2, MXFPAR, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to store parameters for 2nd level file'
            GOTO 999
          END IF
*
* Read command from file. Will return here if FOPEN2. Jump back
* to top level file if this one is finished.
*
200       READ(LCOM2,'(A)',IOSTAT=IFAIL) COMMAND
          IF(IFAIL.LT.0) THEN
            WRITE(*,*) 'Closed2: ',FILE2(:LENSTR(FILE2))
            CLOSE(UNIT=LCOM2)
            FOPEN2 = .FALSE.
            GOTO 100
          ELSE IF(IFAIL.GT.0) THEN
            WRITE(*,*) 'Error reading second level command file'
            GOTO 999
          END IF
*
* Look for comment flag
*
          IF(COMMAND(1:1).EQ.'#') GOTO 200
*
* Substitute parameters (if not a definition)
*
          IF(INDEX(COMMAND,'==').EQ.0) THEN 
            CALL SUBPAR(COMMAND, FPAR2, NFPAR2, MXFPAR, IFAIL)
            IF(IFAIL.NE.0) THEN
              WRITE(*,*) 'Failed to substitute level 2 params'
              GOTO 999
            END IF
          END IF
        END IF
      END IF
*
* Check for user definition commands.
*
      IF(INDEX(COMMAND,'==').GT.0) THEN 
*
* User definition
*
        IF(NUSER.EQ.MXUSER) THEN
          WRITE(*,*) 'User command buffer full. Please delete some.'
          WRITE(*,*) COMMAND(:LENSTR(COMMAND))
          GOTO 999
        END IF
        L = INDEX(COMMAND,'==') - 1
        CALL CSPLIT(COMMAND(:L), USER, NSPLIT, 1, IFAIL)
        IF(IFAIL.NE.0 .OR. NSPLIT.NE.1) THEN
          WRITE(*,*) '== indicates a command definition but the'
          WRITE(*,*) 'defined command: ',COMMAND(:L),
     &    ' is not valid.'
          IFAIL = 1
          GOTO 999
        ELSE IF(LENSTR(USER).GT.8) THEN
          WRITE(*,*) 'Commands up to 8 letters only allowed.'
          WRITE(*,*) COMMAND(:LENSTR(COMMAND))
          IFAIL = 1
          GOTO 999
        END IF
*
* Check against commands that would be interpreted incorrectly
*
        IF(SAME('@',COMMAND) .OR. SAME('!',COMMAND) .OR.
     &     SAME('#',COMMAND)) THEN
          WRITE(*,*) 'Cannot start user defined '//
     &    'command with @, ! or #'
          WRITE(*,*) 'since these will be interpreted incorrectly.'
          GOTO 999
        END IF
*
* Case-insensitive search through existing commands
*
        DO I = 1, NCOM
          IF(SAMECI(USER,COMMS(I))) THEN
            WRITE(*,*) 'A command of the same name already exists' 
     &      //' amongst the standard commands.'
            WRITE(*,*) USER
            IFAIL = 1
            GOTO 999
          END IF
        END DO
        DO I = 1, NUSER
          IF(SAMECI(USER,UCOMMS(I))) THEN
            WRITE(*,*) 'A command of the same name already exists' 
     &      //' amongst the user commands.'
            WRITE(*,*) USER
            IFAIL = 1
            GOTO 999
          END IF
        END DO
*
* Check that substitution strings have been correctly specified
*
        L = ISTSTR(COMMAND(L+3:)) + L + 2
        I = INDEX(COMMAND,'$')
        J = I
        DO WHILE(I.GT.0)
          READ(COMMAND(J+1:J+2),'(I2)',IOSTAT=IFAIL) NPAR
          IF(IFAIL.NE.0 .OR. NPAR.LT.1) THEN
            WRITE(*,*) 'Substitution string must be'//
     &      ' of the form $## where'
            WRITE(*,*) '## is a 2-digit number from 01 to 99.'
            WRITE(*,*) COMMAND(:LENSTR(COMMAND))
            WRITE(*,*) 'String: ',COMMAND(J+1:J+2)
            GOTO 999
          END IF
          I = INDEX(COMMAND(J+3:),'$')
          J = J+2+I
        END DO
*
* Command has passed all tests, store. Note that the correct operation of
* the command is not guaranteed by this process; we have only looked for
* obvious mistakes.
*
        NUSER = NUSER + 1
        UCOMMS(NUSER) = USER
        UDEFS(NUSER)  = COMMAND(L:)
        WRITE(*,*) 'Stored user command number ',NUSER
        WRITE(*,*) 'Command name: ',UCOMMS(NUSER)
        WRITE(*,*) ' Command def: ',
     &  UDEFS(NUSER)(:LENSTR(UDEFS(NUSER)))
        IF(FOPEN2) GOTO 200
        IF(FOPEN1) GOTO 100
        GOTO 10
      END IF
*
* Split up concatenated commands into CONCAT(NCAT) strings, each of 
* which is a full command and can be a shell command, a user defined 
* command or a standard calling program command. The first can be treated 
* independently of the last two.
*
      CALL CONSEP(COMMAND, CONCAT, NCAT, MXCOM, IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Failed to split concatenated command'
        WRITE(*,*) COMMAND(:LENSTR(COMMAND))
        GOTO 999
      END IF
      IF(NCAT.GT.1) WRITE(*,*) 'Starting concatenated command'
C
C     Now go through the separated strings one by one. This is 
C     another major return point. 
C
      NWIND = 0
300   NWIND = NWIND + 1
      IF(NWIND.GT.NCAT) THEN
         IF(NCAT.GT.1) WRITE(*,*) 'Finished concatenated command'
         NCAT = 0
         IF(FOPEN2) GOTO 200
         IF(FOPEN1) GOTO 100
         GOTO 10
      ELSE IF(NCAT.GT.1 .OR. CONFRM .OR. (FOPEN1 .AND. LOUD) ) THEN
         I = LENSTR(CONCAT(NWIND))
         WRITE(*,*) CONCAT(NWIND)(:I)
      END IF
      COMMAND = CONCAT(NWIND)
*
      IF(SAME('!',COMMAND)) THEN
*
* A shell command 
*
        L = INDEX(COMMAND,'!')
c        IFAIL = SYSTEM(COMMAND(L+1:))
c        IF(IFAIL.NE.0) THEN
c          WRITE(*,*) 'Shell command failed'
c          WRITE(*,*) COMMAND(L+1:LENSTR(COMMAND))
c          GOTO 999
c        END IF 
        CALL SYSTEM(COMMAND(L+1:))
        GOTO 300
      ELSE
*
* Now have a command string called COMMAND. This is either
* a standard calling program command or a user defined command.
*
        CALL COMINT(COMMAND, COMMS, NCOM, NFIND, SPLIT, NSPLIT, 
     &  MXSPLIT, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to interpret command parameters'
          WRITE(*,*) COMMAND(:LENSTR(COMMAND))
          GOTO 999
        END IF
        IF(NUSER.GT.0) THEN
          CALL COMINT(COMMAND, UCOMMS, NUSER, NUFIND, USPLIT, 
     &    NUSPLIT, MXUSPL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to interpret user command parameters'
            WRITE(*,*) COMMAND(:LENSTR(COMMAND))
            GOTO 999
          END IF
        ELSE 
          NUFIND = 0
        END IF
        IF(NFIND.LT.0 .OR. NUFIND.LT.0 .OR. (NFIND.GT.0 .AND.
     &  NUFIND.GT.0)) THEN
*
* Ambiguous command
*
          WRITE(*,*) 'More than one match to command'
          WRITE(*,*) COMMAND(:LENSTR(COMMAND))
          GOTO 999
        ELSE IF(NFIND.GT.0) THEN
*
* Return to execute standard calling program command 
*
          GOTO 998
        ELSE IF(NFIND.EQ.0 .AND. NUFIND.EQ.0) THEN
          WRITE(*,*) 'Command not recognised'
          WRITE(*,*) COMMAND(:LENSTR(COMMAND))
          GOTO 999
        ELSE 
*
* User command has been found. The array USPLIT(NUSPLIT) now contains
* the command parameters needed for later substitution. User command
* may be a concatenated command.
*
          CALL CONSEP(UDEFS(NUFIND), UCAT, NUCAT, MXCOM, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to split user command'
            WRITE(*,*) UDEFS(NUFIND)
            GOTO 999
          END IF
*
* Final major return point for winding through a user command.
* Return to main concatenation return point once we have finished
* the user command.
*
          IF(NUCAT.GT.1) WRITE(*,*) 'Starting concatenated user command'
          NUWIND = 0
400       NUWIND = NUWIND + 1
          IF(NUWIND.GT.NUCAT) THEN
            IF(NUCAT.GT.1) 
     &      WRITE(*,*) 'Finished concatenated user command'
            NUCAT = 0
            GOTO 300
          END IF
          COMMAND = UCAT(NUWIND)
*
* Substitute for parameters
*
          CALL SUBPAR(COMMAND, USPLIT, NUSPLIT, MXUSPL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to substitute in user command'
            GOTO 999
          END IF
          IF(NUCAT.GT.1 .OR. CONFRM) THEN
            L = LENSTR(COMMAND)
            WRITE(*,*) COMMAND(:L)
          END IF
*
* Check for shell commands
*
          IF(SAME('!',COMMAND)) THEN
*
* A shell command 
*
            L = INDEX(COMMAND,'!')
c            IFAIL = SYSTEM(COMMAND(L+1:))
c            IF(IFAIL.NE.0) THEN
c              WRITE(*,*) 'Shell command in user def failed'
c              WRITE(*,*) COMMAND(L+1:LENSTR(COMMAND))
c              GOTO 999
c            END IF 
            CALL SYSTEM(COMMAND(L+1:))
            GOTO 400
          END IF
*
* Search through standard commands only
*
          CALL COMINT(COMMAND, COMMS, NCOM, NFIND, SPLIT, NSPLIT, 
     &    MXSPLIT, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to interpret command parameters'
            WRITE(*,*) COMMAND(:LENSTR(COMMAND))
            GOTO 999
          END IF
          IF(NFIND.LT.0) THEN
            WRITE(*,*) 'More than one match to command'
            WRITE(*,*) COMMAND(:LENSTR(COMMAND))
            GOTO 999
          ELSE IF(NFIND.GT.0) THEN
*
* Return to execute standard calling program command
*
            GOTO 998
          ELSE IF(NFIND.EQ.0) THEN
            WRITE(*,*) 'Command not recognised'
            WRITE(*,*) COMMAND(:LENSTR(COMMAND))
            GOTO 999
          END IF
        END IF
      END IF
*
* Normal return
*
998   IFAIL = 0
      RETURN
*
* Error. Tidy everything up, go back to get command.
*
999   CLOSE(UNIT=LCOM1)
      CLOSE(UNIT=LCOM2)
      FOPEN1 = .FALSE.
      FOPEN2 = .FALSE.
      LOUD   = .TRUE.
      NUCAT  = 0
      NCAT   = 0
      GOTO 10
      END

      SUBROUTINE SUBPAR(COMMAND, PAR, NPAR, MXPAR, IFAIL)
*
* Subroutine to expand out substitution strings which are of form $nn 
* where nn is a 2-digit number. $01 thus refers to first command parameter, 
* etc. If a parameter is not specified, '?' which forces prompting of
* parameters is substituted, unless one of the earlier parameters is a 
* in which case '\\' (two for UNIX) is substituted to imply default.
*
      IMPLICIT NONE
      INTEGER I, NPAR, MXPAR, IFAIL, NP, LENSTR, NDEF
      CHARACTER*(*) COMMAND, PAR(MXPAR)
*
* Set NDEF to a number larger than any parameter
*
      NDEF = 100
      DO I = 1, NPAR
        IF(PAR(NPAR).EQ.'\\' .AND. NDEF.EQ.100) NDEF = NPAR
      END DO
      I = INDEX(COMMAND,'$')
      DO WHILE(I.GT.0)
        READ(COMMAND(I+1:I+2),'(I2)',IOSTAT=IFAIL) NP
        IF(IFAIL.NE.0) GOTO 999
        IF(NP.LT.1) THEN
          IFAIL = 1000
          GOTO 999
        END IF
*
* If NPAR .GT. NDEF but otherwise not specified then substitute
* the default flag '//', otherwise if not specified '?' is substituted
*
        IF(NP .GT. NPAR) THEN
          IF(NP .GT. NDEF) THEN
            COMMAND = COMMAND(:I-1)//'\\'//COMMAND(I+3:)
          ELSE
            COMMAND = COMMAND(:I-1)//'?'//COMMAND(I+3:)
          END IF
        ELSE
          COMMAND = COMMAND(:I-1)//
     &          PAR(NP)(:LENSTR(PAR(NP)))//COMMAND(I+3:)
        END IF
        I = INDEX(COMMAND,'$')
      END DO
      IFAIL = 0
999   RETURN
      END
