CSFIT
C SFIT N1 N2 N3 NKNOT THRLO THRHI NREJ WFAC SET -- Fits spline to spectra
C
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to fit 
C  N2    -- Slot number of last spectrum to fit
C  N3    -- First slot to put results
C  NKNOT -- Number of spline knots
C  THRLO -- Lower rejection threshold (sigma)
C  THRHI -- Upper rejection threshold (sigma)
C  NREJ  -- Number of reject cycles.
C  WFAC  -- Softens weights. 1 gives unit weights, 0 no change, anything 
C           in between changes variances softening according to
C           V' = (1-WFAC)*V+WFAC*VBAR where VBAR is the mean variance
C  SET   -- Set mask or not.
C
CSFIT
CPFIT
C PFIT N1 N2 N3 NPOLY THRLO THRHI NREJ WFAC SET -- Fits polynomial to spectra
C
C Selection criteria apply. 
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to fit 
C  N2    -- Slot number of last spectrum to fit
C  N3    -- First slot to put results
C  NPOLY -- Number of polynomial coefficients
C  THRLO -- Lower rejection threshold (sigma)
C  THRHI -- Upper rejection threshold (sigma)
C  NREJ  -- Number of reject cycles.
C  WFAC  -- Softens weights. 1 gives unit weights, 0 no change, anything 
C           in between changes variances softening according to
C           V' = (1-WFAC)*V+WFAC*VBAR where VBAR is the mean variance
C  SET   -- Set mask or not.
C
CPFIT
      SUBROUTINE CONTFIT(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &     HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &     MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &     NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &     NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL, 
     &     METHOD, WORK1, WORK2, WORK3, WORK4, WORK5, MASK, KEY, 
     &     DWORK1, DWORK2, DWORK3, DWORK4, MXWORK, SLOTS, MXSLOTS, 
     &     CLOSE, MUTE, IFAIL)
C     
C     Fits spectrum continuum with a spline or a polynomial.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  C*1   METHOD             -- 'S' for spline, 'P' for polynomial
C     >  R     WORK1(MXWORK)      -- Work array
C     >  R     WORK2(MXWORK)      -- Work array
C     >  R     WORK3(MXWORK)      -- Work array
C     >  R     WORK4(MXWORK)      -- Work array
C     >  R     WORK5(MXWORK)      -- Work array
C     >  L     MASK(MXWORK)       -- Mask array
C     >  I     KEY(MXWORK)        -- Integer work array
C     >  D     DWORK1(MXWORK)     -- R*8 work array
C     >  D     DWORK2(MXWORK)     -- R*8 work array
C     >  D     DWORK3(MXWORK)     -- R*8 work array
C     >  D     DWORK4(MXWORK)     -- R*8 work array
C     >  I     MXWORK             -- Size of work array
C     >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
C     >  I     MXSLOTS             -- Maximum number of entries
C     >  L     CLOSE              -- Plot will be closed on exit
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C
C     Search parameters
C
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C
C     Search parameters, names then values.
C
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C
C     Arc coefficients
C
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C
C     Command parameters
C
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C
C     Mask arrays
      INTEGER MXMASK
      PARAMETER (MXMASK=200)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
      LOGICAL CLOSE, MUTE
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
      REAL WORK5(MXWORK)
      LOGICAL MASK(MXWORK)
      INTEGER KEY(MXWORK)
      DOUBLE PRECISION DWORK1(MXWORK), DWORK2(MXWORK)
      DOUBLE PRECISION DWORK3(MXWORK), DWORK4(MXWORK)
C     
C     Local variables
C     
      INTEGER I, J, K, NV
      REAL GET_FLX, GET_ERF, CFRAT, WFAC
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, UPP, IFAIL, NCOM
      INTEGER MAXSPEC, NSPLINE, NPOLY, NREJ, LENSTR
      LOGICAL SELECT, SAMECI, DEFAULT
      REAL THRLO, THRHI, VBAR
      DOUBLE PRECISION VEARTH, SUM1, SUM2
      CHARACTER*1 METHOD
      CHARACTER*3 SET
C     Spline parameters
C     
      INTEGER NCAP7,MAXKNOT
      PARAMETER (MAXKNOT=100)
      DOUBLE PRECISION  XKNOT(MAXKNOT), CSPLINE(MAXKNOT+3)
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA NSPLINE, NPOLY, NREJ, THRLO, THRHI/3,3,10,-3.,3./
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
      DATA WFAC/0./
C     
C     Check inputs
C     
      IF(METHOD.NE.'S' .AND. METHOD.NE.'P') THEN
         WRITE(*,*) 'Fit method not recognised.'
         GOTO 999
      END IF
C     
C***********************************************************************
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
C     
C     First slot
C     
      CALL INTR_IN('First spectrum to fit', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
C     Second slot
C     
      SLOT2 = MAX(SLOT2, SLOT1)
      CALL INTR_IN('Last spectrum to fit', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) '0,0 only for list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Pick slots for continuum fitting'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
C     First slot for output
C     
      UPP = MAXSPEC-SLOT2+SLOT1
      SLOT3 = MIN(SLOT3, UPP)
      CALL INTR_IN('First slot for fits', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, UPP, IFAIL)
C     
C     Number of terms
C     
      IF(METHOD.EQ.'S') THEN
         CALL INTR_IN('Number of splines', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, NSPLINE, 1, 100, IFAIL)
      ELSE IF(METHOD.EQ.'P') THEN
         CALL INTR_IN('Number of poly coeffs', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, NPOLY, 1, 100, IFAIL)
      END IF
C     
C     Lower reject threshold
C     
      CALL REAL_IN('Lower reject threshold', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, THRLO, -1.E20, 1.E20, IFAIL)
C     
C     Upper reject threshold
C     
      THRHI = MAX(THRLO, THRHI)
      CALL REAL_IN('Upper reject threshold', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, THRHI, THRLO, 1.E20, IFAIL)
C     
C     Number of reject cycles
C     
      CALL INTR_IN('Number of reject cycles', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NREJ, 0, 100000, IFAIL)
C     
C     Softening factor
C     
      CALL REAL_IN('Weight factor (0=no change, 1=unit)', 
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, WFAC, 0., 1., IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
C     Does a mask have to be set
C     
      CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SET, IFAIL)
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'Mask regions not wanted in fit.'
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &        NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &        WORK2, WORK3, MXWORK, MASK)
         CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
         IF(SAMECI(SET,'YES')) WRITE(*,*) 'No regions masked'
      ELSE
         CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
         IF(SAMECI(SET,'YES')) WRITE(*,*) 'No regions masked'
      END IF
C     
C     Now perform fit
C     Loop through spectra
C     
      NV = 0      
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            IF(.NOT.MUTE) WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NPIX(SLOT).GT.MXWORK) THEN
            WRITE(*,*) 'Too large for work arrays'
         ELSE IF(NARC(SLOT).EQ.0 .AND. (NVMASK.GT.0 .OR.
     &           NWMASK.GT.0)) THEN
            IF(.NOT.MUTE) THEN
               WRITE(*,*) 'Slot ',SLOT,' has no wavelength scale'
               WRITE(*,*) 'to interpret mask and will be skipped'
            END IF
         ELSE IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &           NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &           MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &           VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &           NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            IF(.NOT.MUTE) WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
            IF(NARC(SLOT).NE.0) THEN
C     
C     Search for double precision header item Vearth. If not
C     found, assume = 0
C     
               CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
            END IF
C     
            NV = NV + 1
            K = SLOT3 + NV - 1
C     
C     Load up work arrays with fluxes, variances and
C     count/flux ratios
C     
            SUM1 = 0.D0
            SUM2 = 0.D0
            DO J = 1, NPIX(SLOT)
               IF(ERRORS(J,SLOT).GT.0.) THEN
                  WORK1(J) = REAL(J)
                  WORK2(J) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
                  WORK3(J) = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                  WORK4(J) = GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT), 
     &                 FLUX(J,SLOT))
                  SUM1 = SUM1 + 1.
                  SUM2 = SUM2 + WORK4(J)**2
               ELSE
                  WORK1(J) = REAL(J)
                  WORK4(J) = -1.
               END IF
            END DO
C     
C     Soften weights
C     
            VBAR = REAL(SUM2/SUM1)
            DO J = 1, NPIX(SLOT)
               IF(ERRORS(J,SLOT).GT.0.) THEN
                  WORK4(J) = SQRT((1.-WFAC)*WORK4(J)**2+WFAC*VBAR)
               END IF
            END DO
C     
C     Get mask
C     
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &           MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &           .TRUE.,VEARTH,IFAIL)
            IF (IFAIL.NE.0) THEN 
               WRITE(*,*) 'ERROR CALLING APPMASK: IFAIL =',IFAIL
               GOTO 999
            ENDIF
C     
C     Apply mask
C     
            DO J = 1, NPIX(SLOT)
               IF(MASK(J)) WORK4(J) = - ABS(WORK4(J))
            END DO

C     
C     Now fit continuum with rejection.
C     
            IF(MUTE) THEN
               IFAIL = -1
            ELSE
               IFAIL = 0
            END IF
            IF(METHOD.EQ.'S') THEN
               CALL SPLMOLA( NPIX(SLOT), WORK1, WORK2, WORK4, WORK5,
     &              NSPLINE, NREJ, THRHI, THRLO, DWORK1, DWORK2, DWORK3,
     &              DWORK4, XKNOT, CSPLINE, NCAP7,MAXKNOT,
     &              MXWORK, .FALSE., IFAIL )
            ELSE IF(METHOD.EQ.'P') THEN
               CALL POLMOL( NPIX(SLOT), WORK1, WORK2, WORK4, WORK5,
     &              NPOLY, NREJ, THRHI, THRLO, DWORK1, DWORK2, DWORK3, 
     &              MXWORK, IFAIL )
            ELSE
               IFAIL = 1
            END IF
            IF(IFAIL.EQ.0) THEN
               DO J = 1, NPIX(SLOT)
                  FLUX(J,K)   = WORK5(J)
                  COUNTS(J,K) = WORK3(J)*WORK5(J)
                  IF(COUNTS(J,K).EQ.0.) FLUX(J,K) = WORK3(J)
                  ERRORS(J,K) = MAX(ABS(COUNTS(J,K))/1.E4,1.E-10)
               END DO
C     
C     Set headers equal to those of input spectrum 
C     
               CALL SET_HEAD(K, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &              NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &              HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &              MXDOUB, MXINTR, MXREAL, IFAIL)
               IF(.NOT.MUTE) THEN
                  CALL SL_INF(K, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &                 NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &                 NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &                 MXINTR, MXREAL, STRING, IFAIL)
                  WRITE(*,*) STRING(:LENSTR(STRING))
               END IF
            ELSE
               WRITE(*,*) 'Fit failed on slot ',SLOT
            END IF
         END IF
      END DO
 999  RETURN
      END
