CCCAL
C CCAL N1 N2 N3 N4 -- Transfers the wavelength and flux calibration of
C                     one spectrum onto another.
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to change
C  N2    -- Slot number of last spectrum to change
C  N3    -- Template spectrum
C  N4    -- First output slot
C
C Precisely the same wavelength scale and flux cal is transferred onto the
C spectra N1 to N2.
C 
CCCAL
      SUBROUTINE CCAL(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     SLOTS, MXSLOTS, IFAIL)
C     
C     Transfers wavelength and flux cal of one spectrum onto others.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     incremented and returned by routine.
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J, LENSTR
      REAL TDWELL, DWELL
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4,  IFAIL
      INTEGER MAXSPEC, NGOOD, OUT, NCOM
      LOGICAL DEFAULT
      REAL  RATIO
C     
C     Functions
C     
      REAL CFRAT
C     
      DATA SLOT1, SLOT2, SLOT3, SLOT4/1, 1, 2, 3/
C     
C***********************************************************************
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
C     
      CALL INTR_IN('First slot to recalibrate', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to recalibrate', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0 0 to pick slots individually'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Pick slots to recalibrate'       
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
      CALL INTR_IN('Calibration template slot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NPIX(SLOT3).EQ.0) THEN
         WRITE(*,*) SLOT3,' is empty.'
         GOTO 999
      END IF                                             
      IF(NARC(SLOT3).EQ.0) THEN
         WRITE(*,*) SLOT3,' has no wavelength scale.'
         GOTO 999
      END IF                                             
      CALL HGETR('Dwell', TDWELL, SLOT3, MXSPEC, NMREAL, 
     &     HDREAL, NREAL, MXREAL, IFAIL)
      IF(IFAIL.NE.0) THEN
         WRITE(*,*) 'Could not find exposure time in slot ',SLOT3
         GOTO 999
      END IF
C     
      NGOOD = 0
      DO I = 1, NSLOTS
         IF(NPIX(SLOTS(I)).GT.0) THEN
            IF(NPIX(SLOTS(I)).NE.NPIX(SLOT3)) THEN
               WRITE(*,*) 'Target and template slots must have '//
     &              'same number of pixels.'
               GOTO 999
            END IF
            CALL HGETR('Dwell', DWELL, SLOTS(I), MXSPEC, NMREAL, 
     &           HDREAL, NREAL, MXREAL, IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Could not find exposure time in slot ',
     &              SLOTS(I)
               GOTO 999
            END IF
            NGOOD = NGOOD + 1
         END IF
      END DO
      IF(NGOOD.LE.0) THEN
         WRITE(*,*) 'No valid slots chosen'
         GOTO 999
      END IF
C     
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT4, 1, MAXSPEC-NGOOD+1, IFAIL)
C     
      IF(IFAIL.NE.0) GOTO 999
C     
C     Recalibrate spectra
C     
      OUT = SLOT4 - 1
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF(NPIX(SLOT).GT.0) THEN
            CALL HGETR('Dwell', DWELL, SLOTS(I), MXSPEC, NMREAL, 
     &           HDREAL, NREAL, MXREAL, IFAIL)
            OUT = OUT + 1
C     
C     Transfer data to output slot, correcting flux calibration according
C     to template slot
C     
            DO J = 1, NPIX(SLOT)
               COUNTS(J,OUT) = COUNTS(J,SLOT)
               ERRORS(J,OUT) = ERRORS(J,SLOT)
               RATIO  = CFRAT(COUNTS(J,SLOT3),FLUX(J,SLOT3))
               IF(COUNTS(J,OUT).EQ.0.) THEN
                  FLUX(J,OUT) = DWELL*RATIO/TDWELL
               ELSE
                  FLUX(J,OUT) = TDWELL/DWELL/RATIO*COUNTS(J,OUT)
               END IF
            END DO
C     
C     Copy headers
C     
            CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &           MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &           HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &           MXCHAR, MXDOUB, MXINTR, MXREAL, IFAIL)
C     
C     Modify arc scale according to that of template
C     
            NARC(OUT) = NARC(SLOT3)
            DO J = 1, ABS(NARC(OUT))
               ARC(J,OUT) = ARC(J,SLOT3)
            END DO
C     
C     Report back
C     
            CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &           NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &           NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &           MXINTR, MXREAL, STRING, IFAIL)
            WRITE(*,*) 'Slot ',SLOT,' transferred to slot ',OUT
            WRITE(*,*) STRING(:LENSTR(STRING))
         ELSE
            WRITE(*,*) 'Slot ',SLOT,' empty.'
         END IF
      END DO
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END
