*TEPLOT
* TEPLOT N1 N2 MMAG - Plots magnitude/airmass for a set of spectra assumed
*                     to have been divided through by the same spectrum
*                     at zero airmass.
* Parameters
*           N1   -- First spectrum
*           N2   -- Last spectrum
*           MMAG -- Minimum mag to bother plotting to reduce confusion
*
* TEPLOT may be of use for analysis of telluric lines.
* 
* Related commands: DRIFT
*
*TEPLOT
*DRIFT
* DRIFT N1 N2 - Plots drift of arc scale versus time 
*
* Parameters
*           N1   -- First spectrum
*           N2   -- Last spectrum
*
* DRIFT will extract the arc scale from the spectra and plot their drift
* with time. Useful for examining linearity of flexure of spectrograph
*
* Related commands: TEPLOT
*
*DRIFT
      SUBROUTINE CALPLOT(SPLIT, NSPLIT, MXSPLIT, PLOT1, PLOT2, 
     &     PLOT3, MASK, MXPLOT, COUNTS, ERRORS, FLUX, MXBUFF, 
     &     MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, NMDOUB, 
     &     NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &     NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     CLOSE, SLOTS, MXSLOTS, METHOD, IFAIL)
*
* Plots various diagrams useful during calibration.
*
* METHOD = 'E' -- magnitude/airmass for set of spectra assumed to be 
*                 divided out by the zero airmass equivalent or at least 
*                 an approximation to it.
*
* METHOD = 'A' -- Arc drift plot
*
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  R     PLOT1(MXPLOT)    -- Work arrays for plotting
* >  R     PLOT2(MXPLOT)
* >  R     PLOT3(MXPLOT)
*    L     MASK(MXPLOT)
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  L     CLOSE              -- TRUE means plot will be closed before exiting
*                                routine
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
      LOGICAL CLOSE, NEW
*
* Plot parameters
*
      INTEGER MXPLOT 
      REAL PLOT1(MXPLOT), PLOT2(MXPLOT), PLOT3(MXPLOT)
      LOGICAL MASK(MXPLOT)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Mask arrays
*
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Local variables
*
      INTEGER I, J,  N
      DOUBLE PRECISION  ANGST, VEARTH,  AIRMASS
      DOUBLE PRECISION DISPA, RJD, FRJD
      REAL XR1, XR2, YR1, YR2, GET_FLX,  Z
      REAL MMAG, DIFF, X
      CHARACTER*5 SET, METHOD*1
      INTEGER SLOT1, SLOT2, NSAME, IFAIL
      INTEGER  MAXSPEC,  FIRST, NCOM
      LOGICAL  SAME, DEFAULT
      CHARACTER*20 XLABEL
      INTEGER NWAV
      PARAMETER (NWAV=5)
      REAL RJ(2), S(NWAV,2), OFF
*
* Functions
*
*
      DATA SLOT1, SLOT2/1,1/
      DATA MMAG/0.1/
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
*
************************************************************************
*
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot to plot', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to plot', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to plot'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      IF(METHOD.EQ.'E') THEN
        CALL REAL_IN('Minimum mag to plot', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, MMAG, -1000., 1000., IFAIL)
        IF(IFAIL.NE.0) GOTO 999
*
* Does a mask have to be set
*
        CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
        CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, SET, IFAIL)
        IF(SAME(SET,'YES')) THEN
          WRITE(*,*) ' '
          WRITE(*,*) 'Mask regions that you want to include'
          WRITE(*,*) ' '
          CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &         NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, 
     &         MAXPX, NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, 
     &         NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &         HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &         MXDOUB, MXINTR, MXREAL, PLOT1, PLOT2, PLOT3, 
     &         MXPLOT, MASK)
          CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
          IF(SAME(SET,'YES')) THEN
             WRITE(*,*) 'No mask set'
             GOTO 999
          END IF
       ELSE
          CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
          IF(SAME(SET,'YES')) THEN
             WRITE(*,*) 'No mask set'
             GOTO 999
          END IF
       END IF
      END IF
C
C     Evaluate limits
C
      XR1 =  1.E30
      XR2 = -1.E30
      YR1 =  1.E30
      YR2 = -1.E30
      NSAME = 0
      N = 0
      FIRST = 0
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF(NPIX(SLOT).GT.0 .AND. METHOD.EQ.'E') THEN
          IF(NSAME.EQ.0) THEN
            NSAME = NPIX(SLOT)
            IF((NWMASK.GT.0 .OR. NVMASK.GT.0) .AND. 
     &          NARC(SLOT).EQ.0) THEN
              WRITE(*,*) 'Need a wavelength scale for the mask'
              GOTO 999
            ELSE
              CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &        NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
              IFAIL = 0
*
              CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &        MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &        .TRUE.,VEARTH,IFAIL)
            END IF
          ELSE IF(NPIX(SLOT).NE.NSAME) THEN
            WRITE(*,*) 'Must have same number of pixels and arc scales'
            WRITE(*,*) 'although arc scales will not be checked.'
            GOTO 999
          END IF
          CALL HGETD('Airmass', AIRMASS, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &    NDOUB, MXDOUB, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no airmass.'
            GOTO 999
          END IF
          PLOT1(I) = REAL(AIRMASS)
          XR1 = MIN(XR1, PLOT1(I))
          XR2 = MAX(XR2, PLOT1(I))
*
          DO J = 1, NPIX(SLOT)
            IF(MASK(J) .AND. ERRORS(J,SLOT).GT.0.) THEN
              Z = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
              IF(Z.GT.0.) THEN
                Z = MAX(MMAG, -2.5*LOG10(Z))
                YR1 = MIN(YR1, Z)
                YR2 = MAX(YR2, Z)
              END IF
            END IF
          END DO
        ELSE IF(NPIX(SLOT).GT.0 .AND. METHOD.EQ.'A') THEN
          IF(NARC(SLOT).EQ.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no wavelength calibration'
            GOTO 999
          END IF
          CALL HGETD('RJD', RJD, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &    NDOUB, MXDOUB, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no RJD'
            GOTO 999          
          END IF
          IF(FIRST.EQ.0) THEN
            FIRST = SLOT
            FRJD  = DBLE(INT(RJD))
            Z     = REAL(1+NPIX(SLOT))/2.
            OFF   = REAL(ABS(DISPA(Z,NPIX(SLOT),NARC(SLOT),
     &              ARC(1,SLOT),MXARC)))
            OFF   = REAL(INT(OFF)+1)
          END IF
          X = REAL(RJD - FRJD)
          N = N + 1
          XR1 = MIN(X, XR1)
          XR2 = MAX(X, XR2)
          DO J = 1, NWAV
            Z = 1. + REAL(NPIX(SLOT)-1)*REAL(J-1)/REAL(NWAV-1)
            DIFF = REAL(ANGST(Z,NPIX(SLOT),NARC(SLOT),ARC(1,SLOT),
     &           MXARC)-ANGST(Z,NPIX(FIRST),NARC(FIRST),
     &           ARC(1,FIRST),MXARC))
            DIFF = DIFF + OFF*REAL(J-1)
            YR1 = MIN(YR1, DIFF)              
            YR2 = MAX(YR2, DIFF)              
          END DO
        END IF
      END DO       
      IF(METHOD.EQ.'A' .AND. N.LE.1) THEN
        WRITE(*,*) 'Too few spectra for arc drift'
        GOTO 999
      END IF            
      XR1 = XR1 - (XR2-XR1)/20.
      XR2 = XR2 + (XR2-XR1)/20.
      YR1 = YR1 - (YR2-YR1)/20.
      YR2 = YR2 + (YR2-YR1)/20.
      IF(.NOT.DEFAULT) THEN
        CALL SET_LIM(XR1, XR2, YR1, YR2, IFAIL)
        IF(IFAIL.NE.0) RETURN
      END IF
C
C     Plotting section. Close device (if one is open), then
C     open device, draw box, label, draw spectra. Device left
C     open for other routines to draw to if need be, unless
C     option CLOSE is .TRUE.
C     
      CALL DEV_OPEN(.TRUE.,NEW,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(NEW) THEN
         CALL PGSCI(5)
         CALL PGENV(XR1, XR2, YR1, YR2, 0, 0)
*     
         CALL PGSCI(7)
         IF(METHOD.EQ.'E') THEN
            CALL PGLAB('Airmass', 'Extinction (mags)', 
     &           'Extinction plot')
         ELSE IF(METHOD.EQ.'A') THEN
            XLABEL = 'RJD - '
            WRITE(XLABEL(7:),'(I7)',IOSTAT=IFAIL) NINT(FRJD)
            CALL PGLAB(XLABEL, 'Wavelength drift (\\A)',
     &           'Arc drift with time')
         END IF
         CALL PGSCI(1)
         CALL PGIDEN
      ELSE
         CALL PGSCI(5)
         CALL PGSWIN(XR1, XR2, YR1, YR2)
         CALL PGVSTD
         CALL PGBOX('ABCNST',0.,0,'ABCNST',0.,0)
         CALL PGSCI(1)
      END IF
      IF(METHOD.EQ.'E') THEN
         DO I = 1, NSAME
            IF(MASK(I)) THEN
               N = 0
               DO J = 1, NSLOTS
                  SLOT = SLOTS(J)
                  IF(NPIX(SLOT).GT.0) THEN
*     
*     Load plot data in arrays.
*     
                     IF(ERRORS(I,SLOT).GT.0) THEN
                        Z = GET_FLX(COUNTS(I,SLOT), FLUX(I,SLOT)) 
                        IF(Z.GT.0.) THEN
                           Z = -2.5*LOG10(Z)
                           IF(Z.GT.MMAG) THEN
                              N = N + 1
                              PLOT2(N) = PLOT1(J)
                              PLOT3(N) = Z
                           END IF
                        END IF
                     END IF
                  END IF
               END DO
               IF(N.GT.0) CALL PGPT(N, PLOT2, PLOT3, 1)   
               IF(N.GT.1) CALL PGLINE(N, PLOT2, PLOT3)
            END IF
         END DO
      ELSE IF(METHOD.EQ.'A') THEN
         N = 0
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            IF(NPIX(SLOT).GT.0) THEN 
               CALL HGETD('RJD', RJD, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &              NDOUB, MXDOUB, IFAIL)
               N = N + 1
               RJ(N) = REAL(RJD - FRJD)
               DO J = 1, NWAV
                  Z = 1. + REAL(NPIX(SLOT)-1)*REAL(J-1)/REAL(NWAV-1)
                  DIFF = REAL(ANGST(Z,NPIX(SLOT),NARC(SLOT),ARC(1,SLOT),
     &                 MXARC)-ANGST(Z,NPIX(FIRST),NARC(FIRST),
     &                 ARC(1,FIRST),MXARC))
                  DIFF = DIFF + OFF*REAL(J-1)
                  S(J,N) = DIFF
                  IF(SLOT.EQ.FIRST) CALL PGPT(1, RJ(1), DIFF, 17)
               END DO
               IF(N.EQ.2) THEN
                  DO J = 1, NWAV
                     CALL PGPT(1, RJ(2), S(J,2), 17)
                     CALL PGMOVE(RJ(1), S(J,1))
                     CALL PGDRAW(RJ(2), S(J,2))
                     S(J,1) = S(J,2)
                  END DO
                  RJ(1) = RJ(2)
                  N = 1
               END IF
            END IF
         END DO
      END IF
      IFAIL = 0
      IF(CLOSE) CALL DEV_CLOSE(0,IFAIL)
      RETURN
 999  IFAIL = 1
      RETURN
      END
