CCADD
C CADD N1 N2 N3 CONST -- Adds constant(s) to spectra
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to process.
C  N2    -- Slot number of last spectrum to process.
C  N3    -- Slot number of first output spectrum
C  CONST -- Constant to add onto spectra or ASCII file containing
C           column of constants for each spectrum.
C
C No selection is done; operation only carried out on spectra with fluxes
C present.
CCADD
CCSUB
C CSUB N1 N2 N3 CONST -- Subtracts constant(s) from spectra
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to process.
C  N2    -- Slot number of last spectrum to process.
C  N3    -- Slot number of first output spectrum
C  CONST -- Constant to subtract from spectra or ASCII file containing
C           column of constants for each spectrum.
C
C No selection is done; operation only carried out on spectra with fluxes
C present.
CCSUB
CCMUL
C CMUL N1 N2 N3 CONST -- Multiplies spectra by constant(s)
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to process.
C  N2    -- Slot number of last spectrum to process.
C  N3    -- Slot number of first output spectrum
C  CONST -- Constant to multiply spectra or ASCII file containing
C           column of constants for each spectrum.
C
C No selection is done; operation only carried out on spectra with fluxes
C present.
CCMUL
CCDIV
C CDIV N1 N2 N3 CONST -- Divides spectra by constant(s)
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to process.
C  N2    -- Slot number of last spectrum to process.
C  N3    -- Slot number of first output spectrum
C  CONST -- Constant to divide spectra or ASCII file containing
C           column of constants for each spectrum.
C
C No selection is done; operation only carried out on spectra with fluxes
C present.
CCDIV
      SUBROUTINE CADD(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &     MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     METHOD, SLOTS, MXSLOTS, MUTE, IFAIL)
C     
C     Master routine for adding a constant to spectra 
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     =  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     =  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     =  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     >  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C     METHOD    -- 'A', 'S', 'M', 'D' add, sub etc
C     I     SLOTS(MXSLOTS)     -- Workspace for list of slots
C     <  I     IFAIL            -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX
      INTEGER MXCHAR, MXDOUB, MXREAL, MXINTR, MXARC
      INTEGER NPIX(MXSPEC), NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
      CHARACTER*(*) METHOD
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J, N, LENSTR
      REAL GET_FLX,  CFRAT, RATIO
      DOUBLE PRECISION   DCON
      REAL CONST, FLX
      CHARACTER*100 FILE, STRING
      INTEGER SLOT1, SLOT2,  IFAIL, MAXSPEC,  NCOM, SLOT3
      LOGICAL  DEFAULT, MUTE
C     
      DATA SLOT1, SLOT2, SLOT3/	1,1,1/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      CALL INTR_IN('First slot to process', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to process', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to process'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
      CALL INTR_IN('First slot for output', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NSLOTS+1, IFAIL)
      IF(METHOD.EQ.'A') THEN
         CALL CHAR_IN('Constant (or file of constants) to add', 
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      ELSE IF(METHOD.EQ.'S') THEN
         CALL CHAR_IN('Constant (or file of constants) to subtract', 
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      ELSE IF(METHOD.EQ.'M') THEN
         CALL CHAR_IN('Constant (or file of constants) to multiply by', 
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      ELSE IF(METHOD.EQ.'D') THEN
         CALL CHAR_IN('Constant (or file of constants) to divide by', 
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      END IF
      IF(IFAIL.NE.0) GOTO 999 
C     
C**************************************************************************
C     
C     Now process spectra, working on fluxes only,
C     but adjusting counts to give same ratio.
C     
      N = SLOT3-1
      DO I = 1, NSLOTS
         CALL GETCONST(FILE,DCON,IFAIL)
         IF(IFAIL.EQ.1) THEN
            WRITE(*,*) 'Could not read ',I,'th file entry'
            GOTO 999
         ELSE IF(IFAIL.EQ.2) THEN
            WRITE(*,*) 'Could not interpret ',FILE(:LENSTR(FILE))
            GOTO 999
         ELSE IF(IFAIL.EQ.3) THEN
            WRITE(*,*) 'Reached end-of-file'
            GOTO 999
         END IF
         CONST = REAL(DCON)
         IF(METHOD.EQ.'D' .AND. CONST.EQ.0.) THEN
            WRITE(*,*) 'Can''t divide by 0'
            GOTO 999
         END IF                       
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE
            N = N + 1
            DO J = 1, NPIX(SLOT)
               RATIO = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
               IF(ERRORS(J,SLOT).GT.0.) THEN
                  FLX   = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
                  IF(METHOD.EQ.'A') THEN
                     FLX = FLX + CONST 
                     ERRORS(J,N) = ERRORS(J,SLOT) 
                  ELSE IF(METHOD.EQ.'S') THEN
                     FLX = FLX - CONST 
                     ERRORS(J,N) = ERRORS(J,SLOT) 
                  ELSE IF(METHOD.EQ.'M') THEN
                     FLX = FLX*CONST 
                     ERRORS(J,N) = ABS(CONST)*ERRORS(J,SLOT) 
                  ELSE IF(METHOD.EQ.'D') THEN
                     FLX = FLX/CONST 
                     ERRORS(J,N) = ERRORS(J,SLOT)/ABS(CONST)
                  END IF
                  COUNTS(J,N) = RATIO*FLX
                  IF(COUNTS(J,N).EQ.0) THEN
                     FLUX(J,N)   = RATIO
                  ELSE
                     FLUX(J,N)   = FLX
                  END IF
               ELSE
                  FLUX(J,N) = RATIO
                  COUNTS(J,N) = 0.
                  ERRORS(J,N) = -1.
               END IF
            END DO
C     
C     Copy headers
C     
            CALL SET_HEAD(N, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &           NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
            IF(.NOT.MUTE) THEN
               IF(METHOD.EQ.'A') THEN
                  WRITE(*,*) 'Slot ',N,' = slot ',SLOT,' + ',CONST
               ELSE IF(METHOD.EQ.'S') THEN
                  WRITE(*,*) 'Slot ',N,' = slot ',SLOT,' - ',CONST
               ELSE IF(METHOD.EQ.'M') THEN
                  WRITE(*,*) 'Slot ',N,' = slot ',SLOT,' * ',CONST
               ELSE IF(METHOD.EQ.'D') THEN
                  WRITE(*,*) 'Slot ',N,' = slot ',SLOT,' / ',CONST
               END IF
               CALL SL_INF(N, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &              NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &              NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &              MXREAL, STRING, IFAIL)
               WRITE(*,*) STRING(:LENSTR(STRING))
            END IF
         END IF
      END DO
      WRITE(*,*) 'Finished'
      CALL GETCONST(FILE,DCON,-1)
 999  RETURN
      END
