      SUBROUTINE XTYPE(XAXIS, XLABEL, RECOG)
*
* Subroutine to recognise valid X axis types for plotting.
* Also comes back with a suggested axis label.
*
      IMPLICIT NONE
      CHARACTER*(*) XAXIS, XLABEL
      INTEGER I, SEARC, NDIFF
      LOGICAL RECOG
      PARAMETER (NDIFF = 5)
      CHARACTER*64 TYPE(NDIFF), LABEL(NDIFF)
      DATA TYPE/'PIXELS', 'ANGSTROMS', 'MICRONS',
     &'NANNOMETRES', 'KM/S'/
      DATA LABEL/'Pixels', 'Wavelength (\\A)',
     &'Wavelength (\\gm)', 'Wavelength (nm)', 
     &'Velocity (km/s)'/
*
      I = SEARC(TYPE, NDIFF, NDIFF, XAXIS)
      RECOG = I.NE.0
      IF(RECOG) THEN
        XLABEL = LABEL(I)
      ELSE
        WRITE(*,*) 'Invalid type = ',XAXIS
        WRITE(*,*) 'Possible types are:'
        WRITE(*,*) ' '
        DO I = 1, NDIFF
          WRITE(*,*) TYPE(I)
        END DO
      END IF
      RETURN
      END

      SUBROUTINE YTYPE(YAXIS, YLABEL, RECOG)
*
* Subroutine to recognise valid Y axis types for plotting.
* Also comes back with a suggested axis label.
*
      IMPLICIT NONE
      CHARACTER*(*) YAXIS, YLABEL
      INTEGER SEARC, I, NDIFF
      LOGICAL RECOG
      PARAMETER (NDIFF = 6)
      CHARACTER*64 TYPE(NDIFF), LABEL(NDIFF)
      DATA TYPE/'COUNTS', 'MILLIJANSKYS', 'FLAMBDA', 'AB', 
     &'RESPONSE', 'EFFICIENCY'/
      DATA LABEL/'Counts', 'f\\d\\gn\\u (mJy)', 
     &'f\\d\\gl\\u (ergs cm\\u-2\\d s\\u-1\\d \\A\\u-1\\d)',
     &'AB magnitude', 'AB mag for 1 count/sec/\\A',
     &'Fraction of photons detected'/
*
      I = SEARC(TYPE, NDIFF, NDIFF, YAXIS)
      RECOG = I.NE.0
      IF(RECOG) THEN
        YLABEL = LABEL(I)
      ELSE 
        WRITE(*,*) 'Invalid type = ',YAXIS
        WRITE(*,*) 'Possible types are:'
        WRITE(*,*) ' '
        DO I = 1, NDIFF
          WRITE(*,*) TYPE(I)
        END DO
      END IF
      RETURN
      END









