      SUBROUTINE RTHDAS(LUNIT, NPIX, NARC, MXPIX, MXARC, NCHAR, 
     &NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, IFAIL)
*
* Reads headers in ASCII
*
      IMPLICIT NONE
      INTEGER I, J, K, L,  IFAIL
      INTEGER LUNIT, NPIX, NARC, MXARC, MXPIX
      INTEGER NCHAR, NDOUB, NINTR, NREAL
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL
      CHARACTER*(*)    NMCHAR(MXCHAR)
      CHARACTER*(*)    NMDOUB(MXDOUB)
      CHARACTER*(*)    NMINTR(MXINTR)
      CHARACTER*(*)    NMREAL(MXREAL)
      CHARACTER*(*)    HDCHAR(MXCHAR)
      DOUBLE PRECISION HDDOUB(MXDOUB)
      INTEGER          HDINTR(MXINTR)
      REAL             HDREAL(MXREAL)
*
* Read first line of essential information
*
      READ(LUNIT, '(1X,I6,5(1X,I4))', IOSTAT=IFAIL, ERR=999) 
     &NPIX, NARC, NCHAR, NDOUB, NINTR, NREAL
*
* Check sizes
*
      IF(ABS(NARC).GT.MXARC .OR. NPIX.GT.MXPIX .OR.
     &NCHAR.GT.MXCHAR .OR. NDOUB.GT.MXDOUB .OR. NINTR.GT.MXINTR
     &.OR. NREAL.GT.MXREAL) THEN
        WRITE(*,*) 'One or more dimensions too small'
        WRITE(*,*) NARC,NPIX,NCHAR,NDOUB,NINTR,NREAL
        IFAIL = 1
      END IF
*
* Read names of header parameters
*
      READ(LUNIT, '(4(1X,A16))', IOSTAT=IFAIL, ERR=999) 
     &(NMCHAR(I),I=1,NCHAR),(NMDOUB(J),J=1,NDOUB),
     &(NMINTR(K),K=1,NINTR),(NMREAL(L),L=1,NREAL)
*
* Write values of header parameters
*
      READ(LUNIT, '(2(1X,A32))', IOSTAT=IFAIL, ERR=999) 
     &(HDCHAR(I),I=1,NCHAR)
      READ(LUNIT, '(3(1X,E24.17))', IOSTAT=IFAIL, ERR=999) 
     &(HDDOUB(J),J=1,NDOUB)
      READ(LUNIT, '(7(1X,I10))', IOSTAT=IFAIL, ERR=999) 
     &(HDINTR(K),K=1,NINTR)
      READ(LUNIT, '(4(1X,E15.8))', IOSTAT=IFAIL, ERR=999) 
     &(HDREAL(L),L=1,NREAL)
999   CONTINUE
      IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Error reading ASCII headers'
      ELSE IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'End of ASCII file on trying to read headers'
      END IF
      RETURN
      END

      SUBROUTINE RTDTAS(LUNIT, COUNTS, ERRORS, FLUX, ARC,
     &NPIX, NARC, IFAIL)
*
* Written by TRM 18/11/91
*
* Writes a spectrum in ASCII
*
* Inputs
*
* R*4 COUNTS(NPIX)   -- Counts values 
* R*4 ERRORS(NPIX)   -- 1-sigma uncertainties
* R*4 FLUX(NPIX)     -- flux
* I*4 NPIX  -- Number of pixels obtained from header.
* I*4 NARC  -- Number of arc coefficients 
*
* See WTHEAD for definition of TRM format.
*
*
      IMPLICIT NONE
      INTEGER I
      INTEGER IFAIL, LUNIT, NPIX, NARC
      REAL COUNTS(NPIX), ERRORS(NPIX), FLUX(NPIX)
      DOUBLE PRECISION ARC(1)
*
* Write data 
*
      IFAIL = 0
      READ(LUNIT, '(3(1X,E24.17))', IOSTAT=IFAIL, ERR=999) 
     &(ARC(I),I=1,ABS(NARC))
      READ(LUNIT, '(3(1X,E15.8))', IOSTAT=IFAIL, ERR=999) 
     &(COUNTS(I),ERRORS(I),FLUX(I),I=1,NPIX)
999   CONTINUE
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Error reading ASCII data'
      ELSE IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'End of ASCII file on trying to read data'
      END IF
      RETURN
      END

      SUBROUTINE WTHDAS(LUNIT, NPIX, NARC, NCHAR, NDOUB, NINTR, 
     &NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, NMCHAR, NMDOUB, 
     &NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, IFAIL)
*
* Writes headers out in ASCII
*
      IMPLICIT NONE
      INTEGER I, J, K, L,  IFAIL
      INTEGER LUNIT, NPIX, NARC
      INTEGER NCHAR, NDOUB, NINTR, NREAL
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL
      CHARACTER*(*)    NMCHAR(MXCHAR)
      CHARACTER*(*)    NMDOUB(MXDOUB)
      CHARACTER*(*)    NMINTR(MXINTR)
      CHARACTER*(*)    NMREAL(MXREAL)
      CHARACTER*(*)    HDCHAR(MXCHAR)
      DOUBLE PRECISION HDDOUB(MXDOUB)
      INTEGER          HDINTR(MXINTR)
      REAL             HDREAL(MXREAL)
*
* Write first line of essential information
*
      WRITE(LUNIT, '(1X,I6,5(1X,I4))', IOSTAT=IFAIL, ERR=999) 
     &NPIX, NARC, NCHAR, NDOUB, NINTR, NREAL
*
* Write names of header parameters
*
      WRITE(LUNIT, '(4(1X,A16))', IOSTAT=IFAIL, ERR=999) 
     &(NMCHAR(I),I=1,NCHAR),(NMDOUB(J),J=1,NDOUB),
     &(NMINTR(K),K=1,NINTR),(NMREAL(L),L=1,NREAL)
*
* Write values of header parameters
*
      WRITE(LUNIT, '(2(1X,A32))', IOSTAT=IFAIL, ERR=999) 
     &(HDCHAR(I),I=1,NCHAR)
      WRITE(LUNIT, '(3(1X,E24.17))', IOSTAT=IFAIL, ERR=999) 
     &(HDDOUB(J),J=1,NDOUB)
      WRITE(LUNIT, '(7(1X,I10))', IOSTAT=IFAIL, ERR=999) 
     &(HDINTR(K),K=1,NINTR)
      WRITE(LUNIT, '(4(1X,E15.8))', IOSTAT=IFAIL, ERR=999) 
     &(HDREAL(L),L=1,NREAL)
999   CONTINUE
      IF(IFAIL.GT.0) WRITE(*,*) 'Error writing ASCII headers'
      RETURN
      END

      SUBROUTINE WTDTAS(LUNIT, COUNTS, ERRORS, FLUX, ARC,
     &NPIX, NARC, IFAIL)
*
* Written by TRM 18/11/91
*
* Writes a spectrum in ASCII
*
* Inputs
*
* R*4 COUNTS(NPIX)   -- Counts values 
* R*4 ERRORS(NPIX)   -- 1-sigma uncertainties
* R*4 FLUX(NPIX)     -- flux
* I*4 NPIX  -- Number of pixels obtained from header.
* I*4 NARC  -- Number of arc coefficients 
*
* See WTHEAD for definition of TRM format.
*
*
      IMPLICIT NONE
      INTEGER I
      INTEGER IFAIL, LUNIT, NPIX, NARC
      REAL COUNTS(NPIX), ERRORS(NPIX), FLUX(NPIX)
      DOUBLE PRECISION ARC(1)
*
* Write data 
*
      IFAIL = 0
      WRITE(LUNIT, '(3(1X,E24.17))', IOSTAT=IFAIL, ERR=999) 
     &(ARC(I),I=1,ABS(NARC))
      WRITE(LUNIT, '(3(1X,E15.8))', IOSTAT=IFAIL, ERR=999) 
     &(COUNTS(I),ERRORS(I),FLUX(I),I=1,NPIX)
999   CONTINUE
      IF(IFAIL.NE.0) WRITE(*,*) 'Error writing ASCII data'
      RETURN
      END
