*ASCTOM 
* ASCTOM Filein Fileout  -- Reads an ASCII file in (previously converted
*                          from a MOLLY file) and converts it to a MOLLY 
*                          format file to facilitate file transfer.
*
* Parameters:
*
*    Filein  -- Name of input ASCII file
*    Filiout -- Name of MOLLY output file
*
*ASCTOM 
      SUBROUTINE ASCTOM(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC,
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, CLOBBER, IFAIL)
*
* Converts an ASCII file to MOLLY equivalent
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  L     CLOBBER
* >  I     IFAIL
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      CHARACTER*64 INFILE, OUTFILE
      INTEGER INUNIT, OUTUNIT
      CHARACTER*16 UNITS
      INTEGER IFAIL, ESLOT, NPX
      INTEGER  N, NSPEC, MAXSPEC
      LOGICAL    DEFAULT, CLOBBER
      INTEGER NCOM
*
* Functions
*
*
      DATA INFILE, OUTFILE/'SPECTRUM.MOL', 'SPECTRUM.ASC'/
      DATA INUNIT, OUTUNIT/23,24/
************************************************************************
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      ESLOT = 0
      N = 1
      DO WHILE(ESLOT .EQ. 0 .AND. N.LE.MAXSPEC)
        IF(NPIX(N).EQ.0) ESLOT = N
        N = N + 1
      END DO
      IF(ESLOT.EQ.0) THEN
        WRITE(*,*) 'No empty slots found. Need one for conversion.'
        GOTO 999
      END IF
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
*
      CALL CHAR_IN('ASCII input file', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, INFILE, IFAIL)
      CALL CHAR_IN('MOLLY output file', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, OUTFILE, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
* Open files 
*
      OPEN(UNIT=INUNIT,FILE=INFILE,FORM='FORMATTED',
     &     STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',INFILE
        RETURN
      END IF
      IF(CLOBBER) THEN
        OPEN(UNIT=OUTUNIT,FILE=OUTFILE,FORM='UNFORMATTED',
     &     STATUS='NEW',IOSTAT=IFAIL)
      ELSE
        OPEN(UNIT=OUTUNIT,FILE=OUTFILE,FORM='UNFORMATTED',
     &     STATUS='UNKNOWN',IOSTAT=IFAIL)
      END IF
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',OUTFILE
        RETURN
      END IF
*
* Start to read files, checking headers as we go.
*
      NSPEC = 0
      IFAIL = 0
      DO WHILE(IFAIL.EQ.0)
        NSPEC = NSPEC + 1
*
* Load ASCII file, headers then data
*
        CALL RTHDAS(INUNIT, NPX, NARC(ESLOT), MAXPX, MXCHAR,
     &  NCHAR(ESLOT), NDOUB(ESLOT), NINTR(ESLOT), NREAL(ESLOT), 
     &  MXCHAR, MXDOUB, MXINTR, MXREAL, NMCHAR(1,ESLOT), 
     &  NMDOUB(1,ESLOT), NMINTR(1,ESLOT), NMREAL(1,ESLOT), 
     &  HDCHAR(1,ESLOT), HDDOUB(1,ESLOT), HDINTR(1,ESLOT), 
     &  HDREAL(1,ESLOT), IFAIL)
        IF(IFAIL.NE.0) THEN
          IFAIL = MAX(0, IFAIL)
          GOTO 998
        END IF
*
        CALL RTDTAS(INUNIT, COUNTS(1,ESLOT), ERRORS(1,ESLOT), 
     &  FLUX(1,ESLOT), ARC(1,ESLOT), NPX, NARC, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to write ASCII data'
          WRITE(*,*) 'Failure occurred on spectrum ',NSPEC
          GOTO 998
        END IF
*
* MOLLY internal format only millijanskys
*
        UNITS = 'MILLIJANSKYS'
*
* Write header, format code = 3 for MOLLY.
*
        CALL WTHEAD(OUTUNIT, 3, UNITS, NPX, NARC(ESLOT), 
     &  NCHAR(ESLOT), NDOUB(ESLOT), NINTR(ESLOT), 
     &  NREAL(ESLOT), MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &  NMCHAR(1,ESLOT), NMDOUB(1,ESLOT), NMINTR(1,ESLOT), 
     &  NMREAL(1,ESLOT), HDCHAR(1,ESLOT), HDDOUB(1,ESLOT), 
     &  HDINTR(1,ESLOT), HDREAL(1,ESLOT), IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to write spectrum '
          WRITE(*,*) 'Failure occurred on spectrum ',NSPEC
          GOTO 998
        END IF
*
* Write data
*
        CALL WTDATA(OUTUNIT, COUNTS(1,ESLOT), ERRORS(1,ESLOT), 
     &  FLUX(1,ESLOT), ARC(1,ESLOT), 3, NPX, NARC(ESLOT), 
     &  IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to write spectrum '
          WRITE(*,*) 'Failure occurred on spectrum ',NSPEC
          GOTO 998       
        END IF
      END DO
      IFAIL = 0
998   CLOSE(UNIT=INUNIT)
      CLOSE(UNIT=OUTUNIT)
999   RETURN
      END

