*WASC
* WASC FILE N XAXIS (WZERO) YAXIS -- Dumps spectrum to an ASCII file
*
* Parameters: 
*     
*  FILE -- Filename to dump to (start with ! to get just an extension to
*                               add to the run number. e.g. !.asc, will 
*                               give a filename of the form 1345.asc for
*                               run 1345. There must be no spaces if you
*                               use this option.)
*  N    -- Slot number to dump
*  XAXIS - Units in X to dump. (km/s or Angstroms). This is corrected to a heliocentric scale
*          using the value of 'vearth' if it is available.
*  (WZERO) -- Needed if km/s chosen. Zero wavelength
*  YAXIS - Units in Y to dump. (COUNTS or MJY or FLAMBDA for counts, fnu or 
*                               flambda fluxes)
*
* Related command: LASC
*
*WASC
      SUBROUTINE ASCOUT(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC,
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, CLOBBER, IFAIL)
*
* Dumps a spectrum to an ASCII file
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  I     IFAIL     -- O if read ok
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX, MXBUFF/MAXPX)
      REAL ERRORS(MAXPX, MXBUFF/MAXPX)
      REAL FLUX(MAXPX, MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      CHARACTER*64 FILENAME, FILE
      CHARACTER*16 XAXIS, YAXIS, OBJECT*32
      INTEGER SLOT1,  IFAIL, LUNIT
      INTEGER I,  MAXSPEC, NRUN
      REAL F, E
      LOGICAL  SAMECI,  DEFAULT
      LOGICAL CLOBBER
      DOUBLE PRECISION ANGST, VEARTH, W, VFAC, A, WZERO
      REAL  Z, VLIGHT, CGS, FAC, CFAC
      REAL GET_FLX, GET_ERF
*
* Functions
*
*
      DATA FILENAME/'SPEC.DAT'/
      DATA XAXIS, YAXIS/'ANGSTROMS', 'MJY'/
      DATA WZERO/5.D3/
      DATA SLOT1/1/
      DATA LUNIT/23/
*
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
*
      CALL CHAR_IN('Output file name', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FILENAME, IFAIL)
      CALL INTR_IN('Slot to dump', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT1, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NPIX(SLOT1).LE.0) THEN
        WRITE(*,*) 'Slot empty'
        GOTO 999
      END IF
      IF(FILENAME(1:1).EQ.'!') THEN
        CALL HGETI('Record', NRUN, SLOT1, MXSPEC, NMINTR, 
     &  HDINTR, NINTR, MXINTR, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Could not find run number'
          GOTO 999
        ELSE IF(NRUN.LE.0) THEN
          WRITE(*,*) 'Run number must be > 0'
          GOTO 999
        END IF
        IF(NRUN.LE.9) THEN
          WRITE(FILE,'(I1)') NRUN
          FILE(2:) = FILENAME(2:)
        ELSE IF(NRUN.LE.99) THEN
          WRITE(FILE,'(I2)') NRUN
          FILE(3:) = FILENAME(2:)
        ELSE IF(NRUN.LE.999) THEN
          WRITE(FILE,'(I3)') NRUN
          FILE(4:) = FILENAME(2:)
        ELSE IF(NRUN.LE.9999) THEN
          WRITE(FILE,'(I4)') NRUN
          FILE(5:) = FILENAME(2:)
        ELSE IF(NRUN.LE.99999) THEN
          WRITE(FILE,'(I5)') NRUN
          FILE(6:) = FILENAME(2:)
        ELSE IF(NRUN.LE.999999) THEN
          WRITE(FILE,'(I6)') NRUN
          FILE(7:) = FILENAME(2:)
        ELSE IF(NRUN.LE.9999999) THEN
          WRITE(FILE,'(I7)') NRUN
          FILE(8:) = FILENAME(2:)
        ELSE 
          WRITE(*,*) 'Run number too large'
          GOTO 999
        END IF
      ELSE
        FILE  = FILENAME
      END IF
*
      CALL CHAR_IN('X units', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, XAXIS, IFAIL)
      IF(.NOT.SAMECI(XAXIS,'PIXELS') .AND. 
     &   .NOT.SAMECI(XAXIS,'ANGSTROMS') 
     &   .AND. .NOT.SAMECI(XAXIS,'KM/S')) THEN
        WRITE(*,*) 'Invalid choice. Must be either:'
        WRITE(*,*) 'angstroms -- wavelength in angstroms'
        WRITE(*,*) 'km/s      -- velocity scale in km/s'
        WRITE(*,*) 'pixels    -- pixel scale'
        XAXIS = 'ANGSTROMS'
        GOTO 999
      ELSE IF((SAMECI(XAXIS,'ANGSTROMS') .OR. 
     &     SAMECI(XAXIS,'KM/S')) .AND. NARC(SLOT1).EQ.0) THEN
        WRITE(*,*) 'No arc coefficients present'
        GOTO 999
      END IF
      IF(SAMECI(XAXIS,'KM/S')) CALL DOUB_IN('Central wavelength', 
     &  SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, WZERO, 1.D-10, 
     &  1.D10, IFAIL)
*
      CALL CHAR_IN('Y units', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, YAXIS, IFAIL)
      IF(.NOT.SAMECI(YAXIS,'MJY') .AND. 
     &.NOT.SAMECI(YAXIS,'FLAMBDA')
     &.AND. .NOT.SAMECI(YAXIS,'COUNTS')) THEN
        WRITE(*,*) 'Invalid choice. Must be either:'
        WRITE(*,*) 'COUNTS   -- Counts'
        WRITE(*,*) 'MJY      -- fnu (millijanskys)'
        WRITE(*,*) 'FLAMBDA  -- flambda (cgs)'
        YAXIS = 'MJY'
        GOTO 999
      ELSE IF(SAMECI(YAXIS,'FLAMBDA') .AND. NARC(SLOT1).EQ.0) THEN
        WRITE(*,*) 'No arc coefficients present'
        GOTO 999
      END IF
      IF(IFAIL.NE.0) GOTO 999
*
*
* Open file for writing
*
      IF(CLOBBER) THEN
        OPEN(UNIT=LUNIT,FILE=FILE,FORM='FORMATTED',
     &       STATUS='UNKNOWN',IOSTAT=IFAIL)
      ELSE
        OPEN(UNIT=LUNIT,FILE=FILE,FORM='FORMATTED',
     &     STATUS='NEW',IOSTAT=IFAIL)
      END IF
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FILENAME
        GOTO 999
      END IF
*
      VLIGHT = CGS('C')/1.E5
      CFAC   = 1.E-13*VLIGHT
      CALL HGETD('Vearth', VEARTH, SLOT1, MXSPEC, NMDOUB, 
     &HDDOUB, NDOUB, MXDOUB, IFAIL)
      IFAIL = 0
      VFAC = 1.D0-VEARTH/DBLE(VLIGHT)
      DO I = 1, NPIX(SLOT1)
        Z = REAL(I)
        IF(NARC(SLOT1).NE.0) THEN
          A = ANGST(Z, NPIX(SLOT1), NARC(SLOT1), 
     &               ARC(1,SLOT1), MXARC) 
        ELSE
          A = 0.           
        END IF
        IF(SAMECI(XAXIS,'PIXELS')) THEN
          W = DBLE(Z)
        ELSE IF(SAMECI(XAXIS,'ANGSTROMS')) THEN
          W = VFAC*A
        ELSE IF(SAMECI(XAXIS,'KM/S')) THEN
          W = DBLE(VLIGHT)*(A/WZERO-1.D0)-VEARTH
        END IF
        IF(SAMECI(YAXIS,'COUNTS')) THEN
          F = COUNTS(I,SLOT1)
          E = ERRORS(I,SLOT1)
        ELSE
          FAC = 1.
          IF(SAMECI(YAXIS,'FLAMBDA')) FAC = CFAC/REAL(A**2)
          F = FAC*GET_FLX(COUNTS(I,SLOT1), FLUX(I,SLOT1))
          E = FAC*GET_ERF(COUNTS(I,SLOT1), ERRORS(I,SLOT1), 
     &        FLUX(I,SLOT1))
        END IF
        WRITE(LUNIT,*,IOSTAT=IFAIL) W,F,E
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Error dumping to disc'
          GOTO 999
        END IF
      END DO
      CALL HGETC('Object', OBJECT, SLOT1, MXSPEC, NMCHAR, 
     &HDCHAR, NCHAR, MXCHAR, IFAIL)
      WRITE(*,*) 'Dumped ',OBJECT,' to disc. ',NPIX(SLOT1),' points.'
      IFAIL = 0
999   CLOSE(UNIT=LUNIT)
      RETURN
      END
