*ADD
* ADD N1 N2 N3 N4 N5 -- Adds series of spectra together
*
* Parameters: 
*     
*  N1  -- Start slot of first group to add
*  N2  -- End slot of first group to add
*  N3  -- Start slot of group to add to first set
*  N4  -- End slot of group to add to first set
*  N5  -- First slot for results 
*
* If N3=N4 then the same spectrum will be added to all the spectra N1 to N2
* Header taken from N1 to N2 group.
*
* Selection criteria apply. A valid (non-masked) output pixel only results if
* BOTH input pixels are valid as well. Thus add is NOT the command to use to
* combine spectra of an object covering different wavelength ranges since only
* in the overlap region (if any) will you get any result. Use 'average' 
* instead.
*
* Related commands: DIV, SUB, MUL, AVERAGE, BLAZE
*
*ADD
*SUB
* SUB N1 N2 N3 N4 N5 -- Subtracts sets of spectra 
*
* Parameters: 
*     
*  N1  -- Start slot of first group
*  N2  -- End slot of first group
*  N3  -- Start slot of group to subtract from first set
*  N4  -- End slot of group to subtract from first set
*  N5  -- First slot for results 
*
* If N3=N4 then the same spectrum will be subtracted from all of the spectra 
* N1 to N2. Header taken from N1 to N2 group. Selection criteria apply. 
*
* Related commands: ADD, DIV, MUL, BLAZE
*
*SUB
*MUL
* MUL N1 N2 N3 N4 N5 -- Multiplies series of spectra 
*
* Parameters: 
*     
*  N1  -- Start slot of first group 
*  N2  -- End slot of first group 
*  N3  -- Start slot of group to multiply first set by
*  N4  -- End slot of group to multiply first set by
*  N5  -- First slot for results 
*
* If N3=N4 then the same spectrum will be multiplied into all the spectra N1 
* to N2. Header taken from N1 to N2 group. Selection criteria apply. 
*
* Related commands: ADD, DIV, SUB, BLAZE
*
*MUL
*DIV
* DIV N1 N2 N3 N4 N5 -- Divides series of spectra
*
* Parameters: 
*     
*  N1  -- Start slot of first group 
*  N2  -- End slot of first group 
*  N3  -- Start slot of group to divide into first set
*  N4  -- End slot of group to divide into first set
*  N5  -- First slot for results 
*
* If N3=N4 then the same spectrum will be divided into all the spectra N1 to N2
* Header taken from N1 to N2 group. Selection criteria apply. 
*
* Related commands: ADD, MUL, SUB, BLAZE
*
*DIV
*BLAZE
* BLAZE N1 N2 N3 N4 N5 -- Blaze corrects series of spectra
*
* Parameters: 
*     
*  N1  -- Start slot of first group 
*  N2  -- End slot of first group 
*  N3  -- Start slot of group to divide into first set (blaze curve)
*  N4  -- End slot of group to divide into first set
*  N5  -- First slot for results 
*
* If N3=N4 then the same spectrum will be divided into all the spectra N1 to N2
* Header taken from N1 to N2 group. Selection criteria apply.
*
* Only corrects flux array and keep orginal counts array in order to allow
* sensible response weighting when merging.
*
* Created by Danny Steeghs for echelle data (UVES 2002)
* Related commands: ADD, MUL, SUB, DIV
*
*BLAZE

      SUBROUTINE ADDSUB(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &METHOD, SLOTS1, SLOTS2, MXSLOTS, MUTE, IFAIL)
*
* Adds/subtracts/multiplies/divides spectra
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C     METHOD    -- TRUE for adding, FALSE for subtracting
*    I     SLOTS1(MXSLOTS)
*    I     SLOTS2(MXSLOTS)
*    I     MXSLOTS
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      CHARACTER*(*) METHOD
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS1, NSLOTS2
      INTEGER SLOTS1(MXSLOTS), SLOTS2(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST1, LIST1(2,MXLIST)
      INTEGER NLIST2, LIST2(2,MXLIST)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      INTEGER I, L, N, NVALID
      REAL CFRAT, GET_FLX, GET_ERF
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4, SLOT5
      INTEGER IFAIL, SL1, SL2, SL3
      INTEGER MAXSPEC, NCOM
      REAL FLX1, FLX2, FLX3, RAT1
      REAL ERR1, ERR2
      LOGICAL DEFAULT
      LOGICAL MUTE
*
* Functions
*
*
      DATA SLOT1, SLOT2, SLOT3, SLOT4, SLOT5/1,1,2,2,3/
************************************************************************
*
* Interpret command parameters which are:
*
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM  = 0
      IFAIL = 0
      CALL INTR_IN('First spectrum to process', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      IF(SLOT1.EQ.0) SLOT2 = 0
      CALL INTR_IN('Last spectrum to process', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST1.GT.0) THEN
          CALL SETSLOT(LIST1, NLIST1, MXLIST, SLOTS1, 
     &    NSLOTS1, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to process'
          CALL GETLIS(LIST1, NLIST1, MXLIST, MAXSPEC, SLOTS1, 
     &    NSLOTS1, MXSLOTS)
        END IF
        IF(NSLOTS1.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST1, NLIST1, MXLIST, SLOTS1, 
     &  NSLOTS1, MXSLOTS)
      END IF
*
      IF(METHOD.EQ.'A') THEN
        CALL INTR_IN('First spectrum to add', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      ELSE IF(METHOD.EQ.'S') THEN
        CALL INTR_IN('First spectrum to subtract', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      ELSE IF(METHOD.EQ.'M') THEN
        CALL INTR_IN('First spectrum to multiply by', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B' ) THEN
        CALL INTR_IN('First spectrum to divide by', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      END IF
      IF(SLOT3.EQ.0) THEN
        SLOT4 = 0
      ELSE
        SLOT4 = MIN(SLOT3 + SLOT2 - SLOT1, MAXSPEC)
      END IF
      IF(METHOD.EQ.'A') THEN
        CALL INTR_IN('Last spectrum to add', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      ELSE IF(METHOD.EQ.'S') THEN
        CALL INTR_IN('Last spectrum to subtract', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      ELSE IF(METHOD.EQ.'M') THEN
        CALL INTR_IN('Last spectrum to multiply by', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B') THEN
        CALL INTR_IN('Last spectrum to divide by', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      END IF
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT3.EQ.0 .AND. SLOT4.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT3.EQ.0 .AND. SLOT4.EQ.0) THEN
        IF(DEFAULT .AND. NLIST2.NE.0) THEN
          CALL SETSLOT(LIST2, NLIST2, MXLIST, SLOTS2, 
     &    NSLOTS2, MXSLOTS)
        END IF
        IF(.NOT.DEFAULT .OR. NLIST2.EQ.0 .OR. 
     &     (NSLOTS2.NE.1 .AND. NSLOTS1.NE.NSLOTS2)) THEN
          IF(METHOD.EQ.'A') THEN
            WRITE(*,*) 'Enter list of spectra to add'
          ELSE IF(METHOD.EQ.'S') THEN
            WRITE(*,*) 'Enter list of spectra to subtract'
          ELSE IF(METHOD.EQ.'M') THEN
            WRITE(*,*) 'Enter list of spectra to multiply by'
          ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B') THEN
            WRITE(*,*) 'Enter list of spectra to divide by'
          END IF
          CALL GETLIS(LIST2, NLIST2, MXLIST, MAXSPEC, SLOTS2, 
     &    NSLOTS2, MXSLOTS)
        END IF
        IF(NSLOTS2.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT3, SLOT4, LIST2, NLIST2, MXLIST, SLOTS2, 
     &  NSLOTS2, MXSLOTS)
      END IF
      IF(NSLOTS2.NE.1 .AND. NSLOTS1.NE.NSLOTS2) THEN
        WRITE(*,*) 'Must have equal numbers of spectra or just'
        WRITE(*,*) '1 in the second group'
        GOTO 999
      END IF
*
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT5, 1, MAXSPEC-NSLOTS1+1, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
***************************************************************************
*
* Now add/subtract/multiply/divide spectra, working on fluxes only,
* but adjusting counts to give same ratio.
*
      N = 0
      NVALID = 0
      FLX3 = 0.
      DO I = 1, NSLOTS1
        SL1 = SLOTS1(I)
        IF(NSLOTS2.EQ.1) THEN
          SL2 = SLOTS2(1)
        ELSE
          SL2 = SLOTS2(I)
        END IF
        IF( NPIX(SL1).LE.0 .OR. NPIX(SL2).LE.0 .OR.
     &      NPIX(SL1).NE.NPIX(SL2)) THEN
          IF(.NOT.MUTE) THEN
            WRITE(*,*) 'Slot ',SL1,' and/or ',SL2,' empty or '//
     &      'incompatible.'
            IF(METHOD.EQ.'A') THEN
              WRITE(*,*) 'Operation: ',SL1,' + ',SL2,' skipped.'
            ELSE IF(METHOD.EQ.'S') THEN
              WRITE(*,*) 'Operation: ',SL1,' - ',SL2,' skipped.'
            ELSE IF(METHOD.EQ.'M') THEN
              WRITE(*,*) 'Operation: ',SL1,' * ',SL2,' skipped.'
            ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B' ) THEN
              WRITE(*,*) 'Operation: ',SL1,' / ',SL2,' skipped.'
            END IF
          END IF
        ELSE
*
* Slot number of output
*
          SL3 = SLOT5 + N
          N = N + 1
*
* Set headers of output to headers of first spectrum
*
          CALL SET_HEAD(SL3, SL1, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &    NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &    HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &    MXDOUB, MXINTR, MXREAL, IFAIL)
*
          DO L = 1, NPIX(SL1)
            IF(ERRORS(L,SL1).GT.0. .AND. ERRORS(L,SL2).GT.0) THEN
              RAT1 = CFRAT(COUNTS(L,SL1),   FLUX(L,SL1))
              FLX1 = GET_FLX(COUNTS(L,SL1), FLUX(L,SL1))
              ERR1 = GET_ERF(COUNTS(L,SL1), ERRORS(L,SL1), 
     &               FLUX(L,SL1))
              FLX2 = GET_FLX(COUNTS(L,SL2), FLUX(L,SL2))
              ERR2 = GET_ERF(COUNTS(L,SL2), ERRORS(L,SL2),
     &               FLUX(L,SL2))
*
              IF(METHOD.EQ.'A') THEN
                FLX3 = FLX1 + FLX2
              ELSE IF(METHOD.EQ.'S') THEN
                FLX3 = FLX1 - FLX2
              ELSE IF(METHOD.EQ.'M') THEN
                FLX3 = FLX1*FLX2
              ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B') THEN
                IF(ABS(FLX1).LT.1.E30*ABS(FLX2)) THEN
                  FLX3 = FLX1/FLX2
                ELSE IF(FLX1*FLX2.GT.0.) THEN
                  FLX3 = 1.E30
                ELSE
                  FLX3 = -1.E30
                END IF
              END IF
*
              FLUX(L,SL3)   = FLX3
!
!DS  add blaze option where one only divides the flux array and maintains
!DS  the counts array in order to preserve the counts and use response weigths
!DS  intended for echelle data
! 
              IF (METHOD .EQ. 'B' ) THEN
                 COUNTS(L,SL3) = RAT1*FLX1
              ELSE
                 COUNTS(L,SL3) = RAT1*FLX3
              ENDIF
!
              IF(METHOD.EQ.'A' .OR. METHOD.EQ.'S') THEN
                ERRORS(L,SL3) = RAT1*SQRT(ERR1*ERR1+ERR2*ERR2)
              ELSE IF(METHOD.EQ.'M') THEN
                ERRORS(L,SL3) = RAT1*SQRT((FLX2*ERR1)**2+
     &                       (FLX1*ERR2)**2)
              ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B') THEN
                IF(ERR1.LT.ABS(1.E14*FLX2) .AND. 
     &             FLX3*ERR2.LT.ABS(1.E14*FLX2) ) THEN
                  ERRORS(L,SL3) = RAT1*SQRT((ERR1/FLX2)**2+
     &                       (FLX3*ERR2/FLX2)**2)
                ELSE
                  ERRORS(L,SL3) = RAT1*1.E14
                END IF
              END IF 
              IF(COUNTS(L,SL3).EQ.0.) FLUX(L,SL3) = RAT1
              NVALID = NVALID + 1
            ELSE
              ERRORS(L,SL3) = -1.
            END IF
*
          END DO  
*
* Report results
*
          IF(NVALID.EQ.0) THEN
             WRITE(*,*) 'There were no valid output pixels',
     &            ' suggesting that'
             WRITE(*,*) 'the input spectra do not overlap',
     &            ' at all. Output'
             WRITE(*,*) 'spectrum in slot ',SL3,' will be deleted.'
             NPIX(SL3) = 0
          ELSE IF(.NOT.MUTE) THEN
            IF(METHOD.EQ.'A') THEN
              WRITE(*,*) 'Slot ',SL3,' = ',SL1,' + ',SL2
            ELSE IF(METHOD.EQ.'S') THEN
              WRITE(*,*) 'Slot ',SL3,' = ',SL1,' - ',SL2
            ELSE IF(METHOD.EQ.'M') THEN
              WRITE(*,*) 'Slot ',SL3,' = ',SL1,' * ',SL2
            ELSE IF(METHOD.EQ.'D' .or. METHOD.EQ.'B') THEN
              WRITE(*,*) 'Slot ',SL3,' = ',SL1,' / ',SL2
            END IF
            CALL SL_INF(SL3, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &      NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &      NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &      MXINTR, MXREAL, STRING, IFAIL)  
            WRITE(*,*) STRING
          END IF
        END IF
      END DO
      WRITE(*,*) 'Finished'
999   RETURN
      END
