#!/usr/local/bin/perl -w
#
# Script to perform a quick plot of every spectrum in a molly file.
#
# Invoke as: 'pmol.pl device file'
#
# Written T.R.Marsh August 1998.

use lib "/home/sousun/trm/code/molly/perl";
use PDL;
use Molly;
use PGPLOT;

@ARGV == 2 or die "Need to supply device name and file name\n";

$device = $ARGV[0];
$file   = $ARGV[1];

open(MOLLY, $file) or die "Failed to open $file\n";
dev $device;
$n = 1;
while( cmol(*MOLLY) ){
    $spec = rmol(*MOLLY);
    $nspec++;
    $hdr = $spec->gethdr;
    @dims = $spec->dims; 
    print "Spectrum $nspec, name = $$hdr{'Object'}\n";
    line $spec->gethwav, $spec->getflux;
    $n--;
    if(!$n){
	print "Enter <CR> for next spectrum or n<CR> for next n: ";
	$answer = <STDIN>;
	if($answer =~ /^\s*$/){
	    $n = 1;
	}else{
	    $n = $answer;
	}
    }
}
close(MOLLY);
exit;


