#!/usr/local/bin/perl -w
#
# Perl script to locate spectra amongst directory tree starting form 
# working directory downwards.
#
# Invoke as 'fspec.pl' in whatever directory you want to process.
#
# The search criteria are currently hard coded into this routine and
# some extra work would be needed to make it more flexible. Editing it
# is easy enough though.
#
# Written by T.R.Marsh Aug 1998.

use lib "/home/sousun/trm/code/molly/perl";

use PDL;
use Molly;
use Gsubs;

# Get list of molly files starting from the current directory.

@molly_file = findmol('.');

# Go through them searching out ones wanted.

foreach(@molly_file){

    # Ignore temp, junk and crap files

    next if (/temp\d*\.mol$/ || /junk\d*\.mol$/ || /crap\d*\.mol$/);

    $input  = $_;

    next unless open(INPUT, $input);
    print "\nSearching file $input\n";

    $nspec = 0;
    while(cmol(*INPUT)){
	$hdr = hmol(*INPUT);
	$nspec++;

	# Now the search criteria. If header item not defined,
	# still include spectrum as a possible.

	# Object name

	next unless (!defined $$hdr{'Object'} ||
		     $$hdr{'Object'} =~ /6/);

	# RA constraint

	next unless (!defined $$hdr{'RA'} ||
		     ($$hdr{'RA'} > 16 && $$hdr{'RA'} < 18));

	# Dec constraint

	next unless (!defined $$hdr{'Dec'} ||
		     ($$hdr{'Dec'} > -10));

	# S/N constraint

	next unless (!defined $$hdr{'Mean counts'} || 
		     !defined $$hdr{'Mean errors'} ||
		     $$hdr{'Mean counts'} > 5.*$$hdr{'Mean errors'});

	# All OK, let user know.

	print "Spectrum $nspec, name $$hdr{'Object'}, file $input is OK\n";

    }
    close(INPUT);
}

print "\nDone.\n\n";
exit;



