package Gsubs;

# Package of general subroutines 

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(findmol);

# Subroutine to recursively find .mol files
# The files found are contained in the array @molly_file
# If using more than once both this array and the scalar $nmol
# should be cleared. This version only comes back with molly files 
# which are readable and lie in directories that can be accessed.

sub findmol{
    my($dir,$nlink) = @_;
    my($dev,$ino,$mode,$subcount);

    ($dev,$ino,$mode,$nlink) = stat('.') unless $nlink;

    opendir(DIR,'.') || die "Could not open $dir\n";
    my(@filenames) = readdir(DIR);
    closedir(DIR);

    if($nlink == 2){
	for(@filenames){
	    if(/\.mol$/ && -r $_ && -f $_){
		$molly_file[$nmol++] = "$dir/$_";
	    }
	}
    }else{
	$subcount = $nlink - 2;
	for(@filenames){
	    next if ($_ eq '.' || $_ eq '..');
	    $name = "$dir/$_";
	    if(/\.mol$/ && -r $_ && -f $_){
		$molly_file[$nmol++] = $name;
	    }
	    next if $subcount == 0;
	    ($dev,$ino,$mode,$nlink) = lstat($_);
	    next unless (-d $_ && -r $_ && -x $_);

	    chdir $_ || die "Can't cd to $name\n";

	    findmol($name, $nlink);
	    chdir '..';
	    --$subcount;
	}
    }
    return @molly_file;
}

1;
