#
# Perl script to generate html help pages for molly.
# Generates 
# 
# 1) Help on each command
# 2) Class command lists
# 3) List of classes.
# 4) List of commands
#
# Load hash of pointers to where help is contained on each command

(@ARGV == 2) or die "usage: genhtml.pl directory alias\n";
 
$html  = shift;
$alias = shift;

open(HELP,"help_pointers")
    or die "Could not open help_pointers!\n";
while(<HELP>){
    ($command,$file) = split(' ');
    $command = lc $command;
    $help{$command} = "src/$file";
}
close(HELP);

open(CDEFS,"command_defs")
    or die "Could not open command_defs!\n";
$i = 0;
while(<CDEFS>){
    if(/^class (.*?) *# *(.*)$/){
       $class = lc $1;
       $classes{$class} = $2;
    }
    if(/^([a-zA-Z]*) *-- *(.*) *# *(.*)/){
       $command = lc $1;		
       $prompt  = $2;
       $classes = [split(' ', $3)];
       $comms{$command} = {
	   "PROMPT"  => $prompt,
           "CLASSES" => $classes,
       };
    }
}
close(CDEFS);

# Now generate html for every command

print "Generating command help files ...\n";

foreach $command (keys %comms){
    if($help{$command}){
	open(IFILE, $help{$command}) or 
	    die "Failed to open $help{$command} for input\n";

	# Open output and write out standard preamble. Gives command
	# name, standard links to command and class lists and intro.
	# Sets up rest for preformatted input. Use a css file to define the
	# style.

	open(OFILE, ">$html/$command.html") or 
	    die "Failed to open $html/$command.html for output\n";
	
	print OFILE "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n";
	print OFILE "  \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n";
	print OFILE "<html>\n<head>\n<title>Help text on $command</title>\n";
	print OFILE "<link rel=stylesheet href=\"molly.css\" type=\"text/css\">\n";
	print OFILE "</head>\n<body>\n<h1>$command</h1>\n\n";
	print OFILE "<p>\n<pre>\n";

	# Now get stuff from input file

	$output = 0;
	$found = 0;
	while(<IFILE>){
	    if(/^\*$command/i){
		$output = !$output;
	    }elsif($output){
                if(/.( *Related *commands?): *(.*) *$/){
		    $found = 1;
		    $save = $1;
		    @related = split / *, */, $2;
		}else{
		    $_ =~ s/^.//;                   
		    print OFILE;
		}
	    }
	}
	close(IFILE);
	print OFILE "</pre>\n";
	if($found){
	    print OFILE "$save:\n";  
	    $n = 0;
	    foreach $com (@related){
		$com = lc $com;
		if($n){
		    print OFILE ", <a href=\"$com.html\">$com</a>\n";
		}else{
		    print OFILE "<a href=\"$com.html\">$com</a>\n";
		}
		$n++;
	    }
	}

	if(@{$comms{$command}->{"CLASSES"}} > 1){
	    print OFILE "\n<p>This command belongs to the classes:\n";
	}else{
	    print OFILE "\n<p>This command belongs to the class:\n";
	}
	$n = 0;
	foreach $class (@{$comms{$command}->{"CLASSES"}}){
	    $class = lc $class;
	    if($n){
		print OFILE ", <a href=\"$class.class.html\">$class</a>\n";
	    }else{
		print OFILE "<a href=\"$class.class.html\">$class</a>\n";
	    }
	    $n++;
	}

	print OFILE "\n<p>\n<hr>\n<address>\n";
	print OFILE "Tom Marsh, Warwick\n</address>\n</body>\n</html>\n";
	close(OFILE);
    }else{
	print "No help found on \"$command\"\n";
    }
}

# Now generate html for every class

print "Generating class help files ...\n";

foreach $class (keys %classes){

    open(OFILE, ">$html/$class.class.html") or 
	die "Failed to open $html/$class.class.html for output\n";
	
    print OFILE "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n";
    print OFILE "  \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n";
    print OFILE "<html>\n<head>\n<title>Help text on $class molly class</title>\n";
    print OFILE "<link rel=stylesheet href=\"molly.css\" type=\"text/css\">\n";
    print OFILE "</head>\n<body>\n<h1>molly $class commands</h1>\n";
    print OFILE "\n<p>\n<table>\n<ul>\n";
    
    foreach $command (sort keys %comms){
	$found = 0;
	foreach $clss (@{$comms{$command}->{"CLASSES"}}){
	    if($class eq $clss){
		$found = 1;
	    }
	}
	if($found){
	    print OFILE "<tr><td><a href=\"$command.html\">$command</a></td>";
	    print OFILE "<td>--</td>";
	    print OFILE "<td>$comms{$command}->{PROMPT}</td></tr>\n";
	}
    }
    print OFILE "\n</table>\n</ul>\n\n<p>\n<hr>\n<address>\n";
    print OFILE "Tom Marsh, Warwick\n</address>\n</body>\n</html>\n";
    close(OFILE);
}


# Now generate class list

print "Generating class list ...\n";

open(OFILE, ">$html/CLASSES.html") or 
    die "Failed to open $html/CLASSES.html for output\n";
	
print OFILE "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n";
print OFILE "  \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n";
print OFILE "<html>\n<head>\n<title>molly command classes</title>\n";
print OFILE "<link rel=stylesheet href=\"molly.css\" type=\"text/css\">\n";
print OFILE "</head>\n<body>\n<h1>molly command classes</h1>\n";

print OFILE <<END1;
<p>
The following headings classify molly commands lossely according to their 
function. The same command may appear in more than one class. The help
files on individual commands sometimes give links to other closely related 
commands as well.
END1
 
print OFILE "\n<p>\n<ul>\n<table>\n";

foreach $class (sort keys %classes){
    print OFILE "<tr><td><a href=\"$class.class.html\">$class</a></td>\n";
    print OFILE "<td>--</td>";
    print OFILE "<td>$classes{$class}</td></tr>\n";
}
print OFILE "\n</table>\n</ul>\n\n<p>\n<hr>\n<address>\n";
print OFILE "Tom Marsh, Warwick\n</address>\n</body>\n</html>\n";
close(OFILE);

# The full command list

print "Generating command list ...\n";

open(OFILE, ">$html/COMMANDS.html") or 
    die "Failed to open $html/COMMANDS.html for output\n";
	
print OFILE "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"\n";
print OFILE "  \"http://www.w3.org/TR/REC-html40/strict.dtd\">\n";
print OFILE "<html>\n<head>\n<title>molly commands</title>\n";
print OFILE "<link rel=stylesheet href=\"molly.css\" type=\"text/css\">\n";
print OFILE "</head>\n<body>\n<h1>molly commands</h1>\n";

print OFILE <<END2;
<p>
This is the full list of commands available inside molly. If you
are new to the program you may find it easier to search using
the <a href="CLASSES.html">command classes</a> first of all.
END2
 
print OFILE "\n<p>\n<ul>\n<table>\n";

foreach $command (sort keys %comms){ 
    print OFILE "<tr><td><a href=\"$command.html\">$command</a></td>";
    print OFILE "<td>--</td>";
    print OFILE "<td>$comms{$command}->{PROMPT}</td></tr>\n";
}
print OFILE "\n</table>\n</ul>\n\n<p>\n<hr>\n<address>\n";
print OFILE "Tom Marsh, Warwick\n</address>\n</body>\n</html>\n";
close(OFILE);

# Finally generate overall index file

open(INDEX, ">$html/INDEX.html") or die "Could not open index file\n";
print INDEX <<END3;
<html>
<head>
<title>molly</title>
<link rel=stylesheet href="molly.css" type="text/css">
</head>
<body>
<h1>molly</h1>

<P> <i> I have invested much time in molly, so if you find molly useful in your
research, and publish any papers based extensively upon molly analysis, I would appreciate an
acknowledgement as in "I/We thank Tom Marsh for the use of 'molly'."</i>

<P>
molly is a program for the analysis of 1D astronomical spectra. It
overlaps with the various similar programs such as dipso and has strengths
and weaknesses compared to them. molly is at its best when handling
large numbers of similar spectra, and, in particular, time-series spectra.  

<P> molly is freely available at the user's own risk.
See <A HREF = "SETUP.html">molly setup</A> for installation instructions.

<P>An ever-increasing list of <A HREF="CHANGES.html"> changes </A> to molly 
dating from 15 September 1994 is available.

<P> Help text is available for all commands inside molly via 'help
command' however, some advantage is gained from html linkage in
particular links between commands and between commands and their classes can
be made.  The html files are automatically generated from the help text
files used by molly. The majority of these form the first lines of the
subroutines that do the work and are usually accurate. 

<P> The wildcard facility in the internal molly help is good if you have a 
rough memory of the command you are looking for. If you are looking for a 
completely new command then the html help may be better. When using the
html help links are provided to the class and command list in the help to
every command, however it is better to use the 'back' facility when possible
to avoid building up too long a list of links for when you really do want to go
back. 

<P> The date at the bottom of the html help pages show when they were
last generated and can be compared to the dates in the list of changes
to see how up to date everything is.

<p>The locally installed version of molly corresponding to these web pages
is located at <strong>$alias</strong>. You may want to setup an alias to point
to it if you use molly frequently.

<P> You can access the html documentation through the following 
links:

<MENU>

<LI> <A HREF="USER_GUIDE.html"> User guide. </A> </LI>

<LI> <A HREF = "CLASSES.html"> Commands grouped into classes by their function. </A></li>

<LI> <A HREF = "COMMANDS.html"> Commands listed alphabetically.</A></LI>

</MENU>

<HR>
<ADDRESS>
Tom Marsh, Warwick.
</ADDRESS>
</BODY>
END3

close(INDEX);


print "Finished.\n\n";
exit;


