      SUBROUTINE SINFIT(XDATA, YDATA, YERR, NUM, PERIOD,
     &GAM, KVEL, PHI0, COV, NP, F, IFAIL)
C
C SUBROUTINE TO FIT " Y = GAM + KVEL*SIN( 2*PI*(X/PERIOD-PHI0) ) "
C RETURNING GAM, KVEL, PHI0
C
C METHOD FITS " Y = A + B*SIN(2*PI/PERIOD*X) + C*COS(2*PI/PERIOD*X) "
C USING LINEAR LEAST SQUARES, THEN CONVERTS A,B,C TO GAM, KVEL, PHI0
C FORMAL LEAST SQUARES ERROR MATRIX FOR A, B, C TRANSFORMED TO THE
C MATRIX FOR GAM, KVEL, PHI0 USING A LINEAR APPROXIMATION
C
C PASSED:
C REAL*4 XDATA(NUM) -- ARRAY OF X VALUES
C REAL*4 YDATA(NUM) -- ARRAY OF Y VALUES
C REAL*4 YERR(NUM)  -- ARRAY OF ERRORS ON Y VALUES 1-SIGMA
C
C INTEGER*4 NUM -- NUMBER OF VALUES
C
C REAL*4 PERIOD -- ( X VALUE/PERIOD ) REPRESENT A PHASE OF THE SINE CURVE
C
C RETURNED:
C
C REAL*4 GAM   -- "GAMMA VELOCITY"
C REAL*4 KVEL  -- "K VELOCITY"
C REAL*4 PHI0  -- "PHASE OFFSET" 0 IF RED STAR VELOCITY
C REAL*4 COV(6) -- VARIANCE MATRIX OF THE ABOVE. Y ERROR ARRAY MUST BE CORRECT
C                  THESE ARE CALCULATED BY TRANSFORMING THE COVARIANCE MATRIX
C                  FOR A, B, C USING A LINEAR APPROXIMATION
C
C INTEGER*4 NP    -- ACTUAL NUMBER OF POINTS USED
C REAL*4    F     -- VALUE OF CHI-SQUARED, CORRECT IF YERR ARE SCALED CORRECTLY
C INTEGER*4 IFAIL -- =0 IF NO ERROR , 1 OTHERWISE
C
C TO IGNORE ANY POINT, YERR SHOULD BE SET TO LESS THAN OR EQUAL 0.
C
C
C
      REAL XDATA(NUM), YDATA(NUM), YERR(NUM), A, B, C, PERIOD, COV(6)
      REAL KVEL, GAM, PHI0
      DOUBLE PRECISION SW, SY, SY2, SS, SS2, SYS, SYC, SC, SSC, SC2
      DOUBLE PRECISION C1, C2, C3, C4, C5, C6, DET
C
C SET DUMMY VARIABLES TO 0., TO ACCUMULATE SUMS
C
      TWOPI = 8.*ATAN(1.)
      IF(PERIOD.LE.0.) THEN
        IFAIL = 1
        WRITE(*,*) '** Period input error'
        RETURN
      END IF
      IFAIL = 0
      SW  = 0.D0
      SY  = 0.D0
      SY2 = 0.D0
      SS  = 0.D0
      SS2 = 0.D0
      SYS = 0.D0
      SYC = 0.D0
      SC  = 0.D0
      SSC = 0.D0
      SC2 = 0.D0
      NP = 0
      DO I = 1, NUM
        IF(YERR(I) .GT. 0.) THEN
          NP = NP + 1
          XX = TWOPI*XDATA(I)/PERIOD
          SN = SIN(XX)
          CN = COS(XX)
          WW = 1./YERR(I)/YERR(I)
          W1 = WW*SN
C ACCUMULATE SUMS
          SW  = SW  + WW
          SY  = SY  + WW*YDATA(I)
          SY2 = SY2 + WW*YDATA(I)*YDATA(I)
          SS  = SS  + W1
          SS2 = SS2 + W1*SN
          SYS = SYS + W1*YDATA(I)
          SYC = SYC + WW*CN*YDATA(I)
          SC  = SC  + WW*CN
          SSC = SSC + W1*CN
          SC2 = SC2 + WW*CN*CN
        END IF
      END DO
      IF(NP.LT.3) THEN
        WRITE(*,*) '** <3 VALID POINTS FOR A 3 PARAMETER FIT'
        IFAIL = 1
      END IF
C
C LINEAR LEAST SQUARES TO FIND A , B , C
C
C NEED TO INVERT 3 X 3 MATRIX. (SYMMETRIC)
C CALCULATE CO-FACTORS (ONLY 6)
C
      C1 = SS2*SC2 - SSC*SSC
      C2 = SC*SSC  - SS*SC2
      C3 = SS*SSC  - SC*SS2
      C4 = SW*SC2  - SC*SC
      C5 = SC*SS   - SW*SSC
      C6 = SW*SS2  - SS*SS
C
C CALCULATE DETERMINANT
C
      DET = SW*C1 + SS*C2 + SC*C3
      IF(ABS(DET) .LT. 1.D-30) THEN
        IFAIL = 1
        WRITE(*,*) '** ABS(DETERMINANT) < 1.E-30'
        RETURN
      END IF
C
C CALCULATE A, B, C
C
      A = (C1*SY + C2*SYS + C3*SYC) / DET
      B = (C2*SY + C4*SYS + C5*SYC) / DET
      C = (C3*SY + C5*SYS + C6*SYC) / DET
C
C CALCULATE CHI-SQUARED
C
      F = SY2 + A*A*SW + B*B*SS2 + C*C*SC2 + 2.*B*C*SSC + 2.*A*B*SS
     &          + 2.*A*C*SC - 2.*A*SY - 2.*B*SYS - 2.*C*SYC
C
C CALCULATE GAM, KVEL AND PHI0, AND THEIR ERRORS.
C
      SQ  = B*B + C*C
      KVEL  = SQRT( SQ )
      COV(1) =  C1 / DET
      COV(2) = (C2*B + C3*C) /KVEL /DET
      COV(3) = (C2*C - C3*B) /SQ /TWOPI /DET
      COV(4) = (C4*B*B + 2.*C5*B*C + C6*C*C) /SQ /DET
      COV(5) = ((C4-C6)*B*C + C5*(C*C - B*B)) /SQ /KVEL /TWOPI /DET
      COV(6) = (C4*C*C - 2.*C5*B*C + C6*B*B)/DET /SQ /SQ /TWOPI/TWOPI
      GAM   = A
      PHI0  = ATAN2(-C, B)/TWOPI
      RETURN
      END
