        SUBROUTINE POSPEC(X,L,N,WORK,IFAIL)
*
*  Subroutine to work out the power spectrum of the real array
*  in 'X', putting into a double precision array for nag call
*  written 21/11/84
*
* L length of original array
* N length of array after padding out with zeroes
*
        INTEGER*4 END,N,L
        REAL*4 X(N)
        REAL*8 WORK(N)
        INTEGER*4 IFAIL
*
*  APODIZE THE TOP AND BOTTOM 10% OF THE SPECTRUM
*
        PI = 4.*ATAN(1.)
        F  = 0.1*REAL(L)
        F1 = PI/F
        F2 = 0.5*F
        F3 = 0.95*REAL(L)
*
        DO I = 1, INT(F)+1
          X(I) = X(I)*0.5E0*(1.0E0+SIN(F1*(REAL(I-1)-F2)))
        END DO
        DO I = L-INT(F),L
          X(I)=X(I)*0.5E0*(1.0E0+SIN(F1*(F3-FLOAT(I))))
        END DO
*
        DO I = 1, N
          WORK(I) = DBLE(X(I))
        END DO
*
        IFAIL = 1
        CALL C06EAF(WORK,N,IFAIL)
        IF(IFAIL.NE.0) RETURN
*
        X(1) = SNGL(WORK(1)*WORK(1))
        END = N + 2
        DO I = 2, N/2
          X(I) = SNGL(WORK(I)*WORK(I)+WORK(END-I)*WORK(END-I))
        END DO
*
        RETURN
        END
