      REAL FUNCTION POISSON(MEAN, SEED)
*
* Generates Poisson distributed variate with mean MEAN
* Uses RAN1
*
      IMPLICIT NONE
      REAL MEAN, OMEAN, G, EM, SQ, T, LXM, PI
      REAL Y, RAN1, GAMMLN
      INTEGER SEED
      LOGICAL FIRST, OK
      DATA FIRST/.TRUE./
      DATA OMEAN/-1./
*
      IF(FIRST) THEN
        PI = 4.*ATAN(1.)
        FIRST = .FALSE.
      END IF
      IF(MEAN.LT.12.) THEN
        IF(MEAN.NE.OMEAN) THEN
          OMEAN = MEAN
          G = EXP(-MEAN)
        END IF
        EM = -1.
        T  = 1.
        DO WHILE(T.GT.G)
          EM = EM + 1.
          T  = T*RAN1(SEED)
        END DO
      ELSE
        IF(MEAN.NE.OMEAN) THEN
          OMEAN = MEAN
          SQ = SQRT(2.*MEAN)
          LXM = LOG(MEAN)
          G   = MEAN*LXM-GAMMLN(MEAN+1.)
        END IF
        OK = .TRUE.
        DO WHILE(OK)
          EM = -1.
          DO WHILE(EM.LT.0.)
            Y  = TAN(PI*RAN1(SEED))
            EM = SQ*Y+MEAN
          END DO
          EM = INT(EM)
          T = 0.9*(1.+Y**2)*EXP(EM*LXM-GAMMLN(EM+1.)-G)
          OK = RAN1(SEED).GT.T
        END DO
      END IF
      POISSON = EM
      RETURN
      END

      REAL FUNCTION GAMMLN(XX)
*
* Natural log of gamma function. Accurate for XX>1, use reflection formula
* 6.1.4 from Num Rec for XX<1
*
      DOUBLE PRECISION COF(6), STP, HALF, ONE, FPF, X, TMP, SER
      DATA COF, STP/76.18009173D0,-86.50532033D0,24.01409822D0,
     &  -1.231739516D0,.120858003D-2,-.536382D-5,2.50662827465D0/
      DATA HALF,ONE,FPF/0.5D0,1.0D0,5.5D0/
*
      X = XX - ONE
      TMP = X+FPF
      TMP = (X+HALF)*LOG(TMP)-TMP
      SER = ONE
      DO J=1,6
        X = X + ONE
        SER = SER + COF(J)/X
      END DO
      GAMMLN = TMP+LOG(STP*SER)
      RETURN
      END
