        SUBROUTINE MEMCOF(DATA, N, M, PM, COF, WK1, WK2, WKM)

* Taken from Numerical Recipes.
* Given DATA(N) returns COF(M) with COF(I)  and scalar PM the
* coefficients for MEM spectral estimation. WK1, WK2, WKM
* workspace vectors lengths N,N, M.

        IMPLICIT NONE 
        INTEGER N, M, I, J, K
        DOUBLE PRECISION DATA(N), COF(M), WK1(N), WK2(N), WKM(M)
        DOUBLE PRECISION P, PM, PNEUM, DENOM

        P = 0.D0
        DO J = 1, N
          P = P + DATA(J)**2
        END DO
        PM = P/DBLE(N)
        WK1(1) =   DATA(1)
        WK2(N-1) = DATA(N)
        DO J = 2, N-1
          WK1(J)   = DATA(J)
          WK2(J-1) = DATA(J)
        END DO
        DO K = 1, M
          PNEUM = 0.D0
          DENOM = 0.D0
          DO J = 1, N-K
            PNEUM = PNEUM + WK1(J)*WK2(J)
            DENOM = DENOM + WK1(J)**2 + WK2(J)**2
          END DO
          COF(K) = 2.*PNEUM/DENOM
          PM = PM*(1.-COF(K)**2)
          IF(K.NE.1) THEN
            DO I = 1, K-1
              COF(I) = WKM(I) - COF(K)*WKM(K-I)
            END DO
          END IF

* Algoritm is recursive building up answer for larger and larger M
* until desired value is reached. At this point in the algorithm,
* one could return the vector COF and scalar PM for an MEM
* estimate of K rather than M terms.

          IF(K.EQ.M) RETURN
          DO I = 1, K
            WKM(I) = COF(I)
          END DO
          DO J = 1, N-K-1
            WK1(J) = WK1(J) -WKM(K)*WK2(J)
            WK2(J) = WK2(J+1) - WKM(K)*WK1(J+1)
          END DO
        END DO
        END
