        INTEGER*4 FUNCTION IPRIME(N, M)
*
* Function to find the smallest integer greater than or equal
* to N which has a maximum prime factor of M
* This is useful for implementing the fast fourier transform
* routines
*
* M can be one of the following:
*
* 2,3,5,7,11,13,17,19
*
* If function fails the value 0 will be returned
*
        INTEGER*4 PRIMES(8)
        DATA PRIMES/2,3,5,7,11,13,17,19/
*
        IPRIME = 0
*
* Test value of M
*
        ITEST = 1
        DO WHILE(PRIMES(ITEST).NE.M .AND. ITEST.LT.8)
          ITEST = ITEST + 1
        END DO
        IF(PRIMES(ITEST).NE.M) RETURN
*
        NUSE = N
        NKEEP = N
*
* Loop until number is found which
* has no prime larger than M
*
        DO WHILE(NUSE.GT.1)
*
* Loop through the primes less than
* or equal to M
*
          DO I = 1, ITEST
            J = PRIMES(I)
*
* Divide out each prime as far as possible
*
            DO WHILE(MOD(NUSE,J).EQ.0)
              NUSE = NUSE/J
            END DO
          END DO
*
* If the remainder is greater than 1, add one
* to the original number and repeat process
*
          IF(NUSE.GT.1) THEN
            NKEEP = NKEEP + 1
            NUSE  = NKEEP
          END IF
        END DO
        IPRIME = NKEEP
        RETURN
        END
