*---------------------------------------------------------------------
      SUBROUTINE GJR(A, N, EPS, MSING)
*
C     GAUSS-JORDAN-RUTISHAUSER MATRIX INVERSION WITH DOUBLE PIVOTING.
*
*  Input:
*       A       = Matrix to be inverted
*       N       = Dimension of matrix
*       EPS     = Convergence criterion
*  Output:
*       A       = Inverse matrix
*       MSING   = 1 for successful completion
*                 2 for singular matrix
*
      PARAMETER (MAXPARM = 50)  ! Maximum allowed number of parameters
      PARAMETER (IOUT=6)        ! Output unit number
      REAL*4 A(MAXPARM, MAXPARM )
      REAL*4 B(MAXPARM), C(MAXPARM)
      INTEGER*4 IPIV(MAXPARM), JPIV(MAXPARM)
      MSING = 1
      DO 100 K = 1, N
*  Locate the pivot element
        PIVOT = 0.
        DO J = K, N
          DO I = K, N
            IF( ABS(A(I,J)) .GT. ABS(PIVOT) ) THEN
              PIVOT = A(I,J)
              IPIV(K) = I
              JPIV(K) = J
            END IF
          END DO
        END DO
*  Check for singular matrix
        IF( ABS(PIVOT).LE.EPS ) THEN
          WRITE(IOUT, 57) IPIV(K), JPIV(K), PIVOT
57    FORMAT(' SINGULAR MATRIX I=', 
     &I3, ' J=', I3, ' PIVOT=', E16.8, /)
          MSING = 2
          RETURN
        END IF
*  Exchange the pivotal row with the kth row
        IF( IPIV(K).NE.K ) THEN
          DO J = 1, N
            HOLD = A(IPIV(K),J)
            A(IPIV(K),J) = A(K,J)
            A(K,J) = HOLD
          END DO
        END IF
*  Exchange the pivotal column with the kth column
        IF( JPIV(K).NE.K ) THEN
          DO I = 1, N
            HOLD = A(I,JPIV(K))
            A(I,JPIV(K)) = A(I,K)
            A(I,K) = HOLD
          END DO
        END IF
*  Jordan step
        DO J = 1, N
          IF( J.EQ.K ) THEN
            B(J) = 1./PIVOT
            C(J) = 1.
          ELSE
            B(J) = -A(K,J)/PIVOT
            C(J) = A(J,K)
          END IF
          A(K,J) = 0.
          A(J,K) = 0.
        END DO

        DO I = 1, N
          DO J = 1, N
            A(I,J) = A(I,J) + C(I)*B(J)
          END DO
        END DO
100   END DO
*  Reordering the matrix
      DO K = N,1,-1
        IF( K.NE.IPIV(K) ) THEN
          DO I = 1, N
            HOLD = A(I,IPIV(K))
            A(I,IPIV(K)) = A(I,K)
            A(I,K) = HOLD
          END DO
        END IF
        IF( K.NE.JPIV(K) ) THEN
          DO J = 1, N
            HOLD = A(JPIV(K),J)
            A(JPIV(K),J) = A(K,J)
            A(K,J) = HOLD
          END DO
        END IF
      END DO
*  Normal return
      RETURN
      END 
