C
C Computes eigenvalues and vectors of symmetric N by N matrix A 
C stored in NP by NP array
C
C D(N) are eigenvalues
C Columns of V (i.e V(1,J), V(2,J) etc is Jth col) contain eigenvectors.
C
      SUBROUTINE EIGVEC(A,N,NP,D,V,NROT,B,Z,STATUS)
      IMPLICIT NONE
      INTEGER IP, N, NP, NROT, IQ, STATUS, I, J
      REAL SM, TRESH, G, H, T, THETA, C, S, TAU
      REAL A(NP,NP), V(NP,NP), D(N), B(N), Z(N)

      IF(STATUS.NE.0) RETURN
      DO IP=1,N
         DO IQ=1,N
            V(IP,IQ)=0.
         END DO
         V(IP,IP) = 1.
      END DO
      DO IP=1,N
         B(IP)=A(IP,IP)
         D(IP)=B(IP)
         Z(IP)=0.
      END DO
      NROT=0
      DO I=1,50
         SM=0.
         DO IP=1,N-1
            DO IQ=IP+1,N
               SM=SM+ABS(A(IP,IQ))
            END DO
         END DO
         IF(SM.EQ.0.) RETURN
         IF(I.LT.4) THEN
            TRESH=0.2*SM/N**2
         ELSE
            TRESH=0.
         END IF
         DO IP=1,N-1
            DO IQ=IP+1,N
               G=100.*ABS(A(IP,IQ))
               IF((I.GT.4).AND.(ABS(D(IP))+G.EQ.ABS(D(IP)))
     &              .AND.(ABS(D(IQ))+G.EQ.ABS(D(IQ)))) THEN
                  A(IP,IQ)=0.
               ELSE IF(ABS(A(IP,IQ)).GT.TRESH) THEN
                  H=D(IQ)-D(IP)
                  IF(ABS(H)+G.EQ.ABS(H)) THEN
                     T=A(IP,IQ)/H
                  ELSE
                     THETA=0.5*H/A(IP,IQ)
                     T=1./(ABS(THETA)+SQRT(1.+THETA**2))
                     IF(THETA.LT.0.) T=-T
                  END IF
                  C=1./SQRT(1.+T**2)
                  S=T*C
                  TAU=S/(1.+C)
                  H=T*A(IP,IQ)
                  Z(IP)=Z(IP)-H
                  Z(IQ)=Z(IQ)+H
                  D(IP)=D(IP)-H
                  D(IQ)=D(IQ)+H
                  A(IP,IQ)=0.
                  DO J=1,IP-1
                     G=A(J,IP)
                     H=A(J,IQ)
                     A(J,IP)=G-S*(H+G*TAU)
                     A(J,IQ)=H+S*(G-H*TAU)
                  END DO
                  DO J=IP+1,IQ-1
                     G=A(IP,J)
                     H=A(J,IQ)
                     A(IP,J)=G-S*(H+G*TAU)
                     A(J,IQ)=H+S*(G-H*TAU)
                  END DO
                  DO J=IQ+1,N
                     G=A(IP,J)
                     H=A(IQ,J)
                     A(IP,J)=G-S*(H+G*TAU)
                     A(IQ,J)=H+S*(G-H*TAU)
                  END DO
                  DO J=1,N
                     G=V(J,IP)
                     H=V(J,IQ)
                     V(J,IP)=G-S*(H+G*TAU)
                     V(J,IQ)=H+S*(G-H*TAU)
                  END DO
                  NROT = NROT + 1
               END IF
            END DO
         END DO
         DO IP=1,N
            B(IP)=B(IP)+Z(IP)
            D(IP)=B(IP)
            Z(IP)=0.
         END DO
      END DO
      WRITE(*,*) '50 iterations should not have happened.'
      STATUS = 1
      RETURN
      END

      SUBROUTINE EIGSRT(D,V,N,NP)
      IMPLICIT NONE
      INTEGER N,NP,I,J,K
      REAL P, D(N), V(NP,NP)
C
      DO I=1, N-1
         K=I
         P=D(I)
         DO J=I+1,N
            IF(D(J).GE.P) THEN
               K=J
               P=D(J)
            END IF
         END DO
         IF(K.NE.I) THEN
            D(K)=D(I)
            D(I)=P
            DO J=1,N
               P=V(J,I)
               V(J,I)=V(J,K)
               V(J,K)=P
            END DO
         END IF
      END DO
      RETURN
      END
