
        SUBROUTINE ECCENTRIC(XDATA, YDATA, YERR, NUM, PERIOD,
     &  GAM, KVEL, PHI0, ECC, FIT, COV, NP, F, IFAIL)
C
C METHOD FITS " Y = A + B*SIN(2*PI/PERIOD*X) + C*COS(2*PI/PERIOD*X)
C                     + D*SIN(4*PI/PERIOD*X) + E*COS(4*PI/PERIOD*X)
C USING LINEAR LEAST SQUARES, THEN CONVERTS A,B,C,D,E TO GAM, KVEL, PHI0,
C ECC
C
C PASSED:
C REAL*4 XDATA(NUM) -- ARRAY OF X VALUES
C REAL*4 YDATA(NUM) -- ARRAY OF Y VALUES
C REAL*4 YERR(NUM)  -- ARRAY OF ERRORS ON Y VALUES 1-SIGMA
C
C INTEGER*4 NUM -- NUMBER OF VALUES
C
C REAL*4 PERIOD -- ( X VALUE/PERIOD ) REPRESENT A PHASE OF THE SINE CURVE
C
C RETURNED:
C
C REAL*4 GAM   -- "GAMMA VELOCITY"
C REAL*4 KVEL  -- "K VELOCITY"
C REAL*4 PHI0  -- "PHASE OFFSET" 0 IF RED STAR VELOCITY
C REAL*4 ECC   -- Eccentricity
C REAL*4 COV(6) --  Not used yet
C
C INTEGER*4 NP    -- ACTUAL NUMBER OF POINTS USED
C REAL*4    F     -- VALUE OF CHI-SQUARED, CORRECT IF YERR ARE SCALED CORRECTLY
C INTEGER*4 IFAIL -- =0 IF NO ERROR , 1 OTHERWISE
C
C TO IGNORE ANY POINT, YERR SHOULD BE SET TO LESS THAN OR EQUAL 0.
C
C
C
        REAL*4 XDATA(1), YDATA(1), YERR(1), PERIOD, COV(6)
        REAL*4 KVEL, GAM, PHI0, ECC, FIT(5)
        REAL*8 A(5,5), B(5), C(5), V1, V2, V3, V4, V5, WW, DY
        REAL*8 WORK(5,5), WKS1(5), WKS2(5)
C
C SET DUMMY VARIABLES TO 0., TO ACCUMULATE SUMS
C
        IF(IJK.EQ.0) THEN
          TWOPI = 8.*ATAN(1.)
          IJK = 1
        END IF
        IF(PERIOD.LE.0.) THEN
          IFAIL = 1
          PRINT *,CHAR(7),'** Period input error'
          RETURN
        END IF
        IFAIL = 0
        NP = 0
        DO I = 1, 5
          DO J = 1, 5
            A(J,I) = 0.D0
          END DO
          B(I) = 0.D0
        END DO
        DO I = 1, NUM
          IF(YERR(I) .GT. 0.) THEN
            NP = NP + 1
            XX = 360.*XDATA(I)/PERIOD
            V1 = 1.D0
            V2 = SIND(XX)
            V3 = COSD(XX)
            V4 = SIND(2.*XX)
            V5 = COSD(2.*XX)
            WW = 1./YERR(I)/YERR(I)
            DY = YDATA(I)

* Accumulate sums least squares
* matrix

            A(1,1) = A(1,1) + WW*V1*V1
            A(2,1) = A(2,1) + WW*V2*V1
            A(3,1) = A(3,1) + WW*V3*V1
            A(4,1) = A(4,1) + WW*V4*V1
            A(5,1) = A(5,1) + WW*V5*V1
            A(2,2) = A(2,2) + WW*V2*V2
            A(3,2) = A(3,2) + WW*V3*V2
            A(4,2) = A(4,2) + WW*V4*V2
            A(5,2) = A(5,2) + WW*V5*V2
            A(3,3) = A(3,3) + WW*V3*V3
            A(4,3) = A(4,3) + WW*V4*V3
            A(5,3) = A(5,3) + WW*V5*V3
            A(4,4) = A(4,4) + WW*V4*V4
            A(5,4) = A(5,4) + WW*V5*V4
            A(5,5) = A(5,5) + WW*V5*V5

* Accumulate sums for vector

            B(1) = B(1) + WW*DY*V1
            B(2) = B(2) + WW*DY*V2
            B(3) = B(3) + WW*DY*V3
            B(4) = B(4) + WW*DY*V4
            B(5) = B(5) + WW*DY*V5

          END IF
        END DO
        IF(NP.LT.5) THEN
          PRINT *,CHAR(7),'** <5 VALID POINTS FOR A 5 PARAMETER FIT'
          IFAIL = 1
        END IF

* Load other side of matrix A

        DO I = 1, 5
          DO J = 1, I-1
            A(J,I) = A(I,J)
          END DO
        END DO

* Solve 5 simultaneous linear equations

        IFAIL = 1
        CALL F04ATF(A, 5, B, 5, C, WORK, 5, WKS1, WKS2, IFAIL)

* Set parameters GAM, K, PHI0, ECC

        GAM = C(1)
        A1 = SQRT(C(2)**2 + C(3)**2)
        A2 = SQRT(C(4)**2 + C(5)**2)
        ECC = A2/A1
        KVEL = SQRT(A1*A1+A2*A2)
        ALPHA1 = ATAN2(C(3),C(2))
        ALPHA2 = ATAN2(C(5),C(4))
        PHI0 = - ALPHA1
        OLD = PHI0 + 0.1
        DO WHILE(ABS(OLD-PHI0).GT.1.E-5)
          OLD = PHI0
          FUNC  = A1*SIN(PHI0+ALPHA1) + A2*SIN(2.*PHI0+ALPHA2)
          DFUNC = A1*COS(PHI0+ALPHA1) + 2.*A2*COS(2.*PHI0+ALPHA2)
          PHI0 = PHI0 - FUNC/DFUNC
        END DO
        PHI0 = PHI0/TWOPI
        DO I = 1, 5
          FIT(I) = C(I)
        END DO
        RETURN
        END
