      SUBROUTINE BOXFILT( NPIX, FILT, NFILT )
*
*  Boxcar filter
*
*  Inputs:
*      NPIX      = NUMBER OF DATA VALUES
*      FILT      = DATA ARRAY
*      NFILT     = FILTER WIDTH ( should be odd)
*  Outputs:
*      DATA      = Filtered data array
*
*  Feb 1985 by Keith Horne at IOA
*
      IMPLICIT NONE
      INTEGER NPIX, NFILT, MAXBOX, NHBOX, NBOX, I
      INTEGER ICEN1, ICEN2, NEXTPUT, NEXTGET
      REAL FILT(NPIX)
      PARAMETER (MAXBOX = 1001)
      REAL BOX(MAXBOX)
      DOUBLE PRECISION SUM
      REAL SLOPE1, SLOPE2
*     
      IF( NPIX.LE.1 ) RETURN
*     
*     Determine boxcar width
*     
      NBOX = MIN( NPIX, NFILT, MAXBOX)
      NHBOX= NBOX/2
      NBOX = NHBOX*2+1
      IF( NBOX.LT.3 ) RETURN
*     
*     Determine slopes for end corrections
*     
      SUM = 0.D0
      DO I=1,NHBOX
         SUM = SUM - FILT(I)
      END DO
      DO I=NHBOX+2,NBOX
         SUM = SUM + FILT(I)
      END DO
      SLOPE1 = REAL(SUM) / REAL(NHBOX*(NHBOX+1))
      ICEN1 = NHBOX+1
*     
      SUM = 0.D0
      DO I=NPIX-2*NHBOX,NPIX-NHBOX-1
         SUM = SUM - FILT(I)
      END DO
      DO I=NPIX-NHBOX+1,NPIX
         SUM = SUM + FILT(I)
      END DO
      SLOPE2 = REAL(SUM) / REAL(NHBOX*(NHBOX+1))
      ICEN2 = NPIX-NHBOX
*     
*     Load and sum first box of data
*     
      SUM = 0.D0
      DO I=1,NBOX
         BOX(I) = FILT(I)
         SUM = SUM + BOX(I)
      END DO
*     
*     Loop thru the array, computing box averages
*     
      NEXTPUT = NHBOX+1
      DO I = 1, NPIX
         NEXTGET = NHBOX + I
         IF( NEXTGET.LE.NPIX ) THEN
            SUM = SUM - BOX(NEXTPUT) + FILT(NEXTGET)
            BOX(NEXTPUT) = FILT(NEXTGET)
            NEXTPUT = NEXTPUT + 1
            IF( NEXTPUT.GT.NBOX ) NEXTPUT = 1
         END IF
         FILT(I) = REAL(SUM)/REAL(NBOX)
      END DO
*     
*     Make end corrections
*     
      DO I = 1, ICEN1-1
         FILT(I) = FILT(I) + SLOPE1 * REAL(I-ICEN1)
      END DO
      DO I = NPIX-ICEN1+1, NPIX
         FILT(I) = FILT(I) + SLOPE2 * REAL(I-ICEN2)
      END DO
*     
      RETURN
      END
      
