*TYPE
* TYPE SLOT N1 N2 -- Types data arrays to screen for a spectrum
*
* Parameters: 
*     
*  SLOT -- Slot number to examine
*  N1    -- First pixel to type out.
*  N2    -- Last pixel to type out.
*
* This types out the pixel number, its wavelength (if set), the number
* of counts, the error on the counts, the flux and the error on the flux.
*
*TYPE
      SUBROUTINE TYSPC(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC,
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, IFAIL)
*
* Dumps a spectrum to terminal
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  I     IFAIL     -- O if read ok
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX, MXBUFF/MAXPX)
      REAL ERRORS(MAXPX, MXBUFF/MAXPX)
      REAL FLUX(MAXPX, MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      INTEGER SLOT,  IFAIL
      INTEGER I,  MAXSPEC, N1, N2
      REAL C, EC, F, EF
      LOGICAL DEFAULT
      DOUBLE PRECISION ANGST, VEARTH, W, VFAC
      REAL  Z, VLIGHT, CGS
      REAL GET_FLX, GET_ERF
*
* Functions
*
      DATA SLOT, N1/1, 0/
      SAVE SLOT, N1, N2
*
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
*
      CALL INTR_IN('Slot to list', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NPIX(SLOT).LE.0) THEN
         WRITE(*,*) 'Slot empty'
         GOTO 999
      END IF
      IF(N1.EQ.0) THEN
         N1 = 1
         N2 = NPIX(SLOT)
      END IF
      CALL INTR_IN('First pixel', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, N1, 1, NPIX(SLOT), IFAIL)
      CALL INTR_IN('First pixel', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, N2, N1, NPIX(SLOT), IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*     
      VLIGHT = CGS('C')/1.E5
      CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &HDDOUB, NDOUB, MXDOUB, IFAIL)
      IFAIL = 0
      VFAC = 1.D0-VEARTH/DBLE(VLIGHT)
      IF(NARC(SLOT).NE.0) THEN
        WRITE(*,*) 'Wavelength scale is present'
      ELSE
        WRITE(*,*) 'No wavelength scale is present'
      END IF
      DO I = N1, N2
        Z = REAL(I)
        IF(NARC(SLOT).NE.0) THEN
          W = VFAC*ANGST(Z, NPIX(SLOT), NARC(SLOT), 
     &        ARC(1,SLOT), MXARC)            
        END IF
        C  = COUNTS(I,SLOT)
        EC = ERRORS(I,SLOT)
        F  = GET_FLX(COUNTS(I,SLOT), FLUX(I,SLOT))
        EF = GET_ERF(COUNTS(I,SLOT), ERRORS(I,SLOT), 
     &        FLUX(I,SLOT))
        IF(NARC(SLOT).NE.0) THEN
          WRITE(*,'(I5,1X,1PG17.10,4(1X,1PG12.5))') I,W,C,EC,F,EF
        ELSE
          WRITE(*,'(I5,4(1X,1PG12.5))') I,C,EC,F,EF
        END IF
      END DO
      IFAIL = 0
999   RETURN
      END
