*TPOLY
* TPOLY N1 N2 N3 NPOLY THRLO THRHI NREJ CREM -- Removes polynomial from every 
*                         wavelength, fitting as a function of HJD.
*
* Masked data will be ignored and nothing will be subtracted from it.
*
* Parameters: 
*     
*  N1    -- Slot number of first spectrum to fit
*  N2    -- Slot number of last spectrum to fit
*  N3    -- Slot of first output spectrum with polynomials subtracted 
*  NPOLY -- Number of coefficients of polynomial to subtract
*  THRLO -- Lower sigma reject threshold
*  THRHI -- Upper sigma reject threshold
*  NREJ  -- Number of reject cycles
*  CREM  -- Yes to remove constant part along with higher order poly terms
*
* Related command: sdec
*  
*TPOLY
      SUBROUTINE TFILT(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &MXSINTR, MXSREAL, DWORK1, DWORK2, DWORK3, WHICH, MXWORK, SLOTS, 
     &MXSLOTS, IFAIL)
*
* Filters in time
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
* >  D     DWORK1  Work array
* >  D     DWORK2      "
* >  D     DWORK3      "
* >  I     WHICH       "
* >  I     MXWORK     Size of work array
*    I     SLOTS(MXSLOTS) -- Work array for list of slots
*    I     MXSLOTS
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Search parameters
*
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
      INTEGER MXWORK
      DOUBLE PRECISION DWORK1(MXWORK), DWORK2(MXWORK)
      DOUBLE PRECISION DWORK3(MXWORK)
      INTEGER WHICH(MXWORK)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT, SLT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Local variables
*
      INTEGER I, J, K,  N
      INTEGER   NV, NSAME
      REAL GET_FLX, GET_ERF, CFRAT, RATIO
      DOUBLE PRECISION POLY, CON
      DOUBLE PRECISION AVE, LOW, HIGH, RANGE
      INTEGER MXPOL, NPOLY, NOK, NCOM
      PARAMETER (MXPOL=20)
      DOUBLE PRECISION XM(MXPOL,2*MXPOL+3), CHISQ, AF(MXPOL)
      DOUBLE PRECISION RMS, DIFF
      INTEGER SLOT1, SLOT2, SLOT3
      INTEGER  IFAIL, NTOT, NCYC
      INTEGER  MAXSPEC,  NR
      INTEGER   NREJ
      REAL THRLO, THRHI
      CHARACTER*5 CREM
      LOGICAL SELECT, REMOVE
      LOGICAL DEFAULT
*
* Functions
*
*
      DATA SLOT1, SLOT2, SLOT3/1,3,4/
      DATA CREM/'Y'/
      DATA NPOLY, NREJ, THRLO, THRHI/2, 10, -3., 3./
*
************************************************************************
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL   = 0
      NCOM    = 0
*
* Get inputs
*
      CALL INTR_IN('First spectrum to fit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to fit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to fit'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.LE.0) GOTO 999
*
* Check through for valid spectra. Store values for ease
* of reference later
*
      NSAME = 0
      NV    = 0
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).GT.0 .AND. NPIX(SLOT).LE.MXWORK .AND.
     &      SELECT(SLOT,NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &      HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &      MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &      VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &      VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &      MXSDOUB, MXSINTR, MXSREAL)) THEN
          IF(NSAME.EQ.0) THEN
            NSAME = NPIX(SLOT)
            NV = 1
            WHICH(NV) = SLOT
          ELSE IF(NPIX(SLOT).NE.NSAME) THEN
            WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT),' pixels'
            WRITE(*,*) 'rather than ',NSAME,' as the first valid'
            WRITE(*,*) 'spectrum. Choose again.'
            GOTO 999
          ELSE
            NV = NV + 1
            WHICH(NV) = SLOT
          END IF
        END IF
      END DO
      CALL INTR_IN('First slot for output', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NV+1, IFAIL)
      CALL INTR_IN('Order of poly to subtract (1=const)', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, NPOLY, 1, MXPOL, IFAIL)
      IF(NPOLY.GE.NV) THEN
        WRITE(*,*) 'Too few spectra for poly order = ',NV
        GOTO 999
      END IF
      CALL REAL_IN('Lower reject threshold', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, THRLO, -1.E20, 1.E20, IFAIL)
      THRHI = MAX(THRLO, THRHI)
      CALL REAL_IN('Upper reject threshold', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, THRHI, THRLO, 1.E20, IFAIL)
      CALL INTR_IN('Number of reject cycles', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, NREJ, 0, 100000, IFAIL)
      CALL CHAR_IN('Leave constant part unsubstracted?', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, CREM, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL UPPER_CASE(CREM)
      IF(CREM.EQ.'Y') THEN
        REMOVE = .FALSE.
      ELSE IF(CREM.EQ.'N') THEN
        REMOVE = .TRUE.        
      ELSE
        CREM = 'Y'
        WRITE(*,*) 'Must answer Y or N'
        GOTO 999
      END IF
*
***************************************************************************
*
* Store times 
*     
      AVE = 0.D0
      DO I = 1, NV
        SLOT = WHICH(I)
        CALL HGETD('HJD', DWORK1(I), SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to find HJD in slot ',SLOT
          GOTO 999
        END IF
        AVE = AVE + DWORK1(I)
      END DO
      AVE = AVE/DBLE(NV)
*
* Scale for least squares fitting
*
      LOW  =  1.D30
      HIGH = -1.D30
      DO I = 1, NV
        DWORK1(I) = DWORK1(I) - AVE
        LOW  = MIN(LOW, DWORK1(I))
        HIGH = MAX(HIGH, DWORK1(I))
      END DO
      RANGE = HIGH-LOW
      DO I = 1, NV
        DWORK1(I) = DWORK1(I)/RANGE
      END DO
*
* Loop through pixels
*
      NCYC = 0
      NTOT = 0
      DO J = 1, NSAME
        NOK = 0
        DO I = 1, NV
          SLOT = WHICH(I)
          DWORK2(I) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
          DWORK3(I) = GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT), 
     &                 FLUX(J,SLOT))
          IF(DWORK3(I).GT.0.D0) NOK = NOK + 1
        END DO
*
* Fit and subtract poly 
*
100     IF(NOK.GE.NPOLY) THEN
          N = 0
          CALL LEASQ(DWORK1, DWORK2, DWORK3, NV, NPOLY, AF,
     &    CHISQ,XM,1)
          IF(N.LT.NREJ) THEN
            NOK = 0
            NR = 0
            RMS = 0.
            DO K = 1, NV
              IF(DWORK3(K).GT.0.D0) THEN
                DIFF = DWORK2(K) - POLY(AF,NPOLY,DWORK1(K))
                RMS = RMS + (DIFF/DWORK3(K))**2
                NOK = NOK + 1
              END IF
            END DO   
            RMS = SQRT(RMS/DBLE(NOK))
            DO K = 1, NV
              IF(DWORK3(K).GT.0.D0) THEN
                DIFF = DWORK2(K) - POLY(AF,NPOLY,DWORK1(K))
                IF(DIFF.LT.RMS*THRLO*DWORK3(K) .OR. 
     &             DIFF.GT.RMS*THRHI*DWORK3(K)) THEN
                  DWORK3(K) = - ABS(DWORK3(K))
                  NR = NR + 1
                END IF
              END IF
              IF(DWORK3(K).GT.0.D0) NOK = NOK + 1
            END DO   
            N = N + 1
            NTOT = NTOT + NR
            IF(NR.GT.0) GOTO 100
          END IF
          NCYC = NCYC + N
          IF(.NOT.REMOVE) THEN
            CALL LEASQ(DWORK1, DWORK2, DWORK3, NV, 1, CON,
     &      CHISQ,XM,1)
          ELSE
            CON = 0.D0
          END IF
          DO I = 1, NV
            DWORK2(I) = DWORK2(I) - POLY(AF,NPOLY,DWORK1(I)) + CON
          END DO
*
* Now store results, which may replace data
*
          DO I = 1, NV
            SLOT = SLOT3+I-1
            SLT  = WHICH(I)
            IF(ERRORS(J,SLT).GT.0.) THEN
              RATIO = CFRAT(COUNTS(J,SLT),FLUX(J,SLT))
              COUNTS(J,SLOT) = REAL(RATIO*DWORK2(I))
              ERRORS(J,SLOT) = ERRORS(J,SLT)
              IF(COUNTS(J,SLOT).EQ.0.) THEN
                FLUX(J,SLOT) = RATIO
              ELSE
                FLUX(J,SLOT) = REAL(DWORK2(I))
              END IF
            ELSE
              COUNTS(J,SLOT) = COUNTS(J,SLT)
              ERRORS(J,SLOT) = ERRORS(J,SLT)
              FLUX(J,SLOT)   = FLUX(J,SLT)
            END IF
          END DO
        ELSE
*
* No poly fit possible, copy over directly
*
          DO I = 1, NV
            SLOT = SLOT3+I-1
            SLT  = WHICH(I)
            COUNTS(J,SLOT) = COUNTS(J,SLT)
            ERRORS(J,SLOT) = ERRORS(J,SLT)
            FLUX(J,SLOT)   = FLUX(J,SLT)
          END DO
        END IF
        IF(MOD(J,MAX(NSAME/10,10)).EQ.0) THEN
          WRITE(*,'(1X,A,I4,A,F7.2,A,F7.2)') 
     &    'Pixel ',J,', average of ',REAL(NCYC)/REAL(J),
     &    ' cycles and ',REAL(NTOT)/REAL(J),' rejects/pix'
        END IF
      END DO
      WRITE(*,'(1X,A,F7.2,A,F7.2)') 
     &    'Average of ',REAL(NCYC)/REAL(NSAME),
     &    ' cycles and ',REAL(NTOT)/REAL(NSAME),' rejects/pix'
*
* Set headers of output spectra equal to those of input spectra
*
      DO I = 1, NV
        CALL SET_HEAD(SLOT3+I-1, WHICH(I), MXSPEC, NPIX, ARC, NARC, 
     &  MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &  HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &  MXDOUB, MXINTR, MXREAL, IFAIL)
      END DO
      WRITE(*,*) 'Spectra with polynomials subtracted are stored in'
      WRITE(*,*) 'slots ',SLOT3,' to ',SLOT3+NV-1
999   RETURN
      END


