      SUBROUTINE SPLMOLA( NDATA, XDATA, YDATA, YSIGMA, YFIT,
     +NSPLINE, NCYCLE, THRHI, THRLO, W1, W2, W3, W4, 
     +XKNOT, CSPLINE, NCAP7,MAXKNOT,
     +MXWORK, FIX, IFAIL )
*
* Fits spline to data and performs reject cycles with
* no user interaction.
*
*  Inputs:
*      NDATA       = number of data values
*      XDATA       = X data values
*      YDATA       = Y data values
*      YSIGMA      = Y uncertainties (1-sigma) (negative to reject)
*      NSPLINE     = Number of spline nodes
*      NCYCLE      = Max number of reject cycles
*      THRHI       = high threshold for sigma clipping
*      THRLO       = low threshold for sigma clipping
*      W1(MXWORK)    Work arrays (R*8)
*      W2(MXWORK)
*      W3(MXWORK)
*      W4(MXWORK)
*      MXWORK        Dimension. Should be >2 more than NDATA
*      FIX           True if knot positions must remain fixed
*                    otherwise determined automatically.
*
*      IFAIL = -1 to suppress messages.
*  Output:
*      YFIT       = Y FIT VALUES
*      IFAIL      = 0 IF SUCCESSFUL, 1 IF FAILED.
*
* Converted to use PDA_DEFC, PFLM 05Feb97
*
      IMPLICIT NONE
      INTEGER NDATA, NSPLINE, NCYCLE, NREJ, ICYCLE
      INTEGER LASTREJ, IFAIL
      REAL XDATA(NDATA), YDATA(NDATA), YSIGMA(NDATA)
      REAL YFIT(NDATA), THRHI, THRLO, RMS
      INTEGER MXWORK
      DOUBLE PRECISION W1(MXWORK), W2(MXWORK)
      DOUBLE PRECISION W3(MXWORK), W4(MXWORK)
      LOGICAL FIX, LOUD
*       
* Spline parameters
*
      INTEGER NCAP7,MAXKNOT 
      DOUBLE PRECISION  XKNOT(MAXKNOT), CSPLINE(MAXKNOT+3)

*
* Test inputs
*
      LOUD = .NOT.IFAIL.EQ.-1
      IF(NDATA.LE.0) THEN
        WRITE(*,*) '** No data.', NDATA
        GOTO 999
      END IF

      NREJ = 0      
      ICYCLE = -1   
100   ICYCLE = ICYCLE + 1
      LASTREJ = NREJ      
*
* Fit the spline
*
      CALL SPLMOL1( NDATA, XDATA, YDATA, YSIGMA, YFIT, NSPLINE, 
     &     W1, W2, W3, W4, MXWORK, FIX,
     &     XKNOT, CSPLINE, NCAP7,MAXKNOT, IFAIL)
      IF( IFAIL.NE.0 ) GOTO 999
*
*     Evaluate the fit
*     Do not restore any points
*
      NREJ = -1
*
      IF( NCYCLE.EQ.0 ) THEN
         CALL REJECT( NDATA, YDATA, YSIGMA, YFIT, 
     &        1.E20, -1.E20, RMS, NREJ )
*
*     Evaluate the fit and reject large outliers
*
      ELSE
         CALL REJECT( NDATA, YDATA, YSIGMA, YFIT, 
     &        THRHI, THRLO, RMS, NREJ )
      END IF
*
*     Report results of this reject
*
      IF(LOUD) WRITE(*,*) ' Cycle', ICYCLE, '  RMS =', RMS,
     *     ' (sigma)  Rejects =', NREJ
*
*     Next fit-reject cycle
*
      IF( ICYCLE.LT.NCYCLE .AND. NREJ.NE.LASTREJ ) GOTO 100
*
*     normal return
*
      IFAIL = 0
      RETURN
*
* error return
*
999   IFAIL = 1
      WRITE(*,*) 'SPLFITA aborted.'
      RETURN
      END

      SUBROUTINE SPLMOL1( NDATA, XDATA, YDATA, YSIGMA, 
     +     YFIT, SPLASK, W1, W2, W3, W4, MXWORK, FIX,
     &     XKNOT, CSPLINE, NCAP7,MAXKNOT, IFAIL )
*
*  Computes weighted least-squares spline fit to data pairs
*
*  Input:
*      NDATA      = Number of data pairs
*      XDATA      = Data X values
*      YDATA      = Data Y values
*      YSIGMA     = Uncertainty in Y (1-sigma) (negative to reject)
*      SPLASK     = Number of splines requested
*      W1,W2,W3,W4  R*8 work arrays MXWORK dimension
*      MXWORK       Dimension should be at least 
*                    2*NDATA+5*(NSPLINE+8)+16
*  Output:
*      YFIT       = Fitted Y values
*      XKNOT      = Position of knots used
*      CSPLINE    = Spline coefficients
*      NCAP7      = Number of knots used
*      RMS        = RMS normalized residual of points not rejected
*      IFAIL      = 0 if successful, 1 if failed.
*
* PFLM 06Feb97  
*
      IMPLICIT NONE
      INTEGER NDATA, SPLASK, MAXKNOT
      REAL XDATA(NDATA), YDATA(NDATA)
      REAL YSIGMA(NDATA), YFIT(NDATA)
      DOUBLE PRECISION RANGE, XMIN, XMAX
*
      INTEGER MXWORK
      DOUBLE PRECISION W1(MXWORK), W2(MXWORK), W3(MXWORK)
      DOUBLE PRECISION W4(MXWORK), CALC
      DOUBLE PRECISION XKNOT(MAXKNOT)
      INTEGER NCAP7, NFIT, I, LW,  IE
      DOUBLE PRECISION CSPLINE(MAXKNOT+3)
      INTEGER  NSPLINE, IFAIL, MDEOUT
      REAL  RMS, YMEAN
      LOGICAL FIX
*
      IF(NDATA.LE.0) THEN
         WRITE(*,*) '** NO DATA IN ''SPLMOL1'','
         GOTO 999
      END IF
 
*     Load data arrays for spline fit
 
      CALC = 0.D0
      YMEAN=0.0
      NFIT = 0
      XMIN = DBLE(XDATA(1))
      XMAX = DBLE(XDATA(1))
      DO I= 1, NDATA
         IF( YSIGMA(I).GT.0.) THEN      
            NFIT = NFIT + 1
            W1(NFIT) = DBLE(XDATA(I))
            W2(NFIT) = DBLE(YDATA(I))
            W3(NFIT) = DBLE(YSIGMA(I))
            YMEAN    = YMEAN + REAL(W1(NFIT))
            CALC     = CALC  + W3(NFIT)*W3(NFIT)
            IF(XMIN.GT.W1(NFIT)) XMIN = W1(NFIT)
            IF(XMAX.LT.W1(NFIT)) XMAX = W1(NFIT)
         END IF
      END DO
      RANGE = XMAX - XMIN
      XMIN = XMIN - 0.001*RANGE
      XMAX = XMAX + 0.001*RANGE

      IF(NFIT.LE.0) THEN
         WRITE(*,*) '** NO DATA IN ''SPLMOL1'','
         GOTO 999
      END IF
      
      RMS=REAL(SQRT(CALC/REAL(NFIT)))
      YMEAN = YMEAN/NFIT
      
*  Use mean of YDATA if there is not enough data for a spline fit
      
      IF(NFIT.LT.3) THEN
         WRITE(*,*) '** WARNING: Mean of', NFIT,
     &        ' data points instead of spline fit.'
         DO I=1,NDATA
            YFIT(I) = YMEAN
         END DO
         GOTO 1000
      END IF
      
*     Re-scale sigmas
      
      DO I=1,NFIT
c     W3(I) = RMS/W3(I) bug till 26/10/98 PDA_DEFC wants
c     sigmas not 1/sigmas 
         W3(I) = W3(I)/RMS
      END DO
 
*  Decide how many splines will be used
 
      NSPLINE = MAX(1, MIN(SPLASK, MIN(NFIT/2+1, MAXKNOT) ) )
      IF(NSPLINE.LT.SPLASK) THEN
        WRITE(*,*) '** Number of splines reduced from', SPLASK,
     &  ' to', NSPLINE
        IF(FIX) WRITE(*,*) 'Spline knots cannot be left fixed'
      END IF

*  Distribute spline knots ---------------------------------------------

      IF(FIX .AND. NSPLINE.EQ.SPLASK) THEN
*
*     Must check that all fixed knots are within range. If they are not
*     they are eliminated. This possibility arises because of the reject 
*     cycles.
*     
         IE = 0
         DO I = 5, NSPLINE+3
            IF (XKNOT(I).GE.XMIN .AND. XKNOT(I).LE.XMAX) THEN
               IE=IE+1
               XKNOT(IE+4)=XKNOT(I)
            ENDIF
         ENDDO
         IF (IE.LT.NSPLINE-1) WRITE(*,*)'Rejected',NSPLINE-IE-1,' knots'
         NSPLINE = IE+1
      ELSE 
C
C     Distribute interior knots
C     
         DO I = 0, NSPLINE
            XKNOT(I+4) = XMIN+I*(XMAX-XMIN)/NSPLINE
         END DO

      END IF
C     
C     Initialize end knots (extra part to reduce chace of error)
C
      DO I=1,3
         XKNOT(I)           =  XMIN
         XKNOT(NSPLINE+4+I) =  XMAX
      ENDDO
      NCAP7 = NSPLINE+7

      LW = (NCAP7-1)*5 + (NCAP7+1)*5
     :              + 2*MAX(NFIT,NCAP7) + NCAP7 + 16
      IF (LW .GT. MXWORK) THEN
         WRITE(*,*) 'SPLMOL: INSUFFICIENT WORKSPACE FOR PDA_DEFC'
         WRITE(*,*) 'Array elements required : ',LW
         WRITE(*,*) 'Array elements available: ',MXWORK
         IFAIL = 99
         RETURN
      ENDIF

      IFAIL = 0
      CALL PDA_DEFC( NFIT, W1, W2, W3, 4,NCAP7,XKNOT,1,MDEOUT, 
     +     CSPLINE, MXWORK, W4, IFAIL)
      IF( MDEOUT.NE.1 .OR. IFAIL.NE.0) THEN
         WRITE(*,*) '** PDA_DEFC failed.  IFAIL=',IFAIL
         WRITE(*,*) '** PDA_DEFC failed.  MDEOUT=',MDEOUT
         RETURN
      END IF
      
*     Evaluate spline at required points
      
      CALL SPLCALC1( NDATA, XDATA, XKNOT, CSPLINE, NCAP7,
     +     YFIT, IFAIL )
*     
*     Normal RETURN
*     
 1000 IFAIL = 0
      RETURN
*     
*     Error RETURN
*     
 999  IFAIL = 1
      RETURN
*     
      END
      
      SUBROUTINE SPLCALC1( NDATA, XDATA, XKNOT, CSPLINE, NCAP7,
     +     YFIT, IFAIL )
*     
*     EVALUATES SPLINE FIT
*     
*     Input:
*     NDATA      = NUMBER OF DATA PAIRS
*     XDATA      = DATA X VALUES
*     XKNOT      = KNOT X VALUES
*     CSPLINE    = SPLINE COEFFS
*     NCAP7      = NUMBER OF KNOTS
*     Output:
*     YFIT      = CORRESPONDING Y VALUE OF SPLINE FIT
*     IFAIL      = 0 IF SUCCESSFUL, 1 IF FAILED.
*     
*     
      IMPLICIT NONE
      INTEGER NDATA, IFAIL
      REAL  XDATA(NDATA), YFIT(NDATA)
*
      INTEGER NCAP7, I,  KNOT
      DOUBLE PRECISION DERIV
      DOUBLE PRECISION XKNOT(NCAP7), CSPLINE(NCAP7-4)
      DOUBLE PRECISION WORK(12)
      DOUBLE PRECISION PDA_DBVALU
      INTEGER INBV,K
      
      INBV = 1
      IFAIL = 0
      K=4
      
C     Loop thru the data

      DO I=1,NDATA
         
C  Evaluate spline at desired x-value
         
         IF( XDATA(I).GE.XKNOT(1).AND.
     &        XDATA(I).LE.XKNOT(NCAP7) ) THEN
            YFIT(I)  = REAL(PDA_DBVALU(XKNOT,CSPLINE,NCAP7-K
     +           ,K,0,DBLE(XDATA(I)),INBV,WORK,IFAIL))
            IF( IFAIL.NE.0) THEN
               WRITE(*,*) '** PDA_DBVALU failed.(1) IFAIL=',IFAIL
               print *,' XDATA(',I,') = ',XDATA(I)
               print *,' XKNOT(1) = ', XKNOT(1)
               print *,' XKNOT(',NCAP7,') = ', XKNOT(NCAP7)
               RETURN  
            END IF
         ELSE
C     
C     Evaluate spline and first derivative at the end knot
C     
            IF (XDATA(I).GT.XKNOT(NCAP7)) THEN
               KNOT=NCAP7
            ELSE 
               KNOT = 1
            ENDIF
            
            YFIT(I) = REAL(PDA_DBVALU(XKNOT,CSPLINE,NCAP7-K
     +           ,K,0,XKNOT(KNOT),INBV,WORK,IFAIL))
            IF( IFAIL.NE.0) THEN
               WRITE(*,*) '** PDA_DBVALU Failed.(2) IFAIL=',IFAIL
               print *,'XKNOT(',KNOT,') = ',XKNOT(KNOT)
               RETURN
            ENDIF
            
            DERIV = REAL(PDA_DBVALU(XKNOT,CSPLINE,NCAP7-4
     +           ,4,1,XKNOT(KNOT),INBV,WORK,IFAIL))
            IF( IFAIL.NE.0) THEN
               WRITE(*,*) '** PDA_DBVALU Failed.(3) IFAIL=',IFAIL
               RETURN
            ENDIF
C     
C     Linear extrapolation to desired point
C     
            YFIT(I) = YFIT(I) + REAL(DERIV * ( XDATA(I) - XKNOT(KNOT)))
            
         END IF
      END DO
      RETURN
      END
