*TRAIL
* TRAIL N1 N2 C1 C2 XT A1 A2 NBIN    -- Plots trailed spectrum on greyscale
*                               devices. Use COLOUR to set look up table on
*                               devices which support it.
*
* TRAIL will provide valiues covering the whole of the first valid spectrum
* as the defaults the first time a given mode of X axis is used. The
* upper and lower limits of the greyscale can also be determined automatically
* (see below).
*
* NB: If you are using the STARLINK PGPLOT you can only get colour by calling
*     the command 'colour' after 'trail'. You will also not be able to make
*     colour PostScript plots. Get onto to PGPLOT 5.0 asap!
*
* Parameters: 
*     
*  N1  -- Slot number of first spectrum to plot.
*  N2  -- Slot number of last spectrum to plot.
*  C1  -- Flux level to plot as lowest colour index  (usually dark)
*  C2  -- Flux level to plot as highest colour index (usually bright)
*         NB If you set C1=C2 the plot will be scaled from the lowest to
*            the highest value. If in addition C1=C2=0. then the autoscaled
*            values will be set as the defaults for next time otherwise the
*            autoscaling remains on.
*
*  XT  -- X-axis type (W=wavelength,V=velocity,P=pixel)
*  A1  -- W=start wavelength, V=central wavelength, P=start pixel
*  A2  -- W=end wavelength, V=km/s/pixel, P=end pixel
*  NBIN - Number of output bins.
* 
*
*TRAIL
      SUBROUTINE SPCTRL(SPLIT, NSPLIT, MXSPLIT, WORK1, 
     &MXWORK, COUNTS, ERRORS, FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, 
     &ARC, NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &MXDOUB, MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL, LW, CLOSE, 
     &SLOTS, MXSLOTS, IFAIL)
*
* Master routine for plotting trailed spectra.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  R     WORK1(MXWORK)    -- Work array for plotting
* >  I     MXWORK           -- Size of work array
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*                                incremented and returned by routine.
* >  L     CLOSE              -- TRUE means plot will be closed before exiting
*                                routine
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
      LOGICAL CLOSE, NEW
*
* Plot parameters
*
      INTEGER MXWORK
      REAL WORK1(MXWORK)
      REAL WMID, WSTART, WEND, VPIX, TR(6)
      INTEGER PSTART, PEND
*
* Data arrays
*
      REAL COUNTS(MXBUFF)
      REAL ERRORS(MXBUFF)
      REAL FLUX(MXBUFF)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
      DOUBLE PRECISION W, W1, W2
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Plot parameters
*
      INTEGER LW
      CHARACTER*32 XLABEL, YLABEL, TLABEL
*
* Local variables
*
      INTEGER I, J,  L,  INSPEC,  NCOM
      REAL GET_FLX, LOW, HIGH
      DOUBLE PRECISION VEARTH, ANGST
      REAL   XR1, XR2, YR1, YR2
      REAL  C1, C2, TC1, TC2
      CHARACTER*3 XAXIS
      INTEGER SLOT1, SLOT2,  IFAIL
      INTEGER   MAXSPEC,  ISO, NMX, FSLOT
      INTEGER INDI, INDK, IS, MXWK, IL
      LOGICAL SELECT, DEFAULT, WAVE, SAMECI, FIRST
      REAL VLIGHT, CGS
      INTEGER NAOUT, NAIN, NBIN, NS, NV, MXIN
      PARAMETER (MXIN=50)
      DOUBLE PRECISION AOUT(2), AIN(MXIN)
*
      DATA SLOT1, SLOT2/1,1/
      DATA WMID, WSTART, PSTART/0., 0., 0/
      DATA VPIX, WEND, PEND/0., 0., 0/
      DATA XAXIS, NBIN/'W', 0/
      DATA C1, C2/0., 0./
*
      IFAIL = 1
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
*
      CALL INTR_IN('First slot for trail', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot for trail', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) '0,0 only for list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to trail'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
* Check requested spectra
*
      WAVE = .TRUE.
      NV = 0      
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).LE.0) THEN
          WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
        ELSE IF(NPIX(SLOT).GT.MXWORK) THEN
          WRITE(*,*) 'Too large for work arrays'
          GOTO 999
        ELSE IF(ABS(NARC(SLOT)).GT.MXIN) THEN
          WRITE(*,*) 'SPCTRL internal buffer size MXIN'
          WRITE(*,*) 'is too small'
          WRITE(*,*) 'Slot ',SLOT,' will be skipped.'
          GOTO 999
        ELSE IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, 
     &    NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &    NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC,
     &    NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &    NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, 
     &    MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
          WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
        ELSE
          NV = NV + 1
          IF(NV.EQ.1) FSLOT = SLOT
          WAVE = WAVE .AND. NARC(SLOT).NE.0
        END IF
      END DO
      IF(NV.LE.0) THEN
        WRITE(*,*) 'No valid spectra found'
        GOTO 999
      END IF
*
* Display levels
*
      CALL REAL_IN('Level for lowest colour index', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, C1, -1.E30, 1.E30, IFAIL)
      CALL REAL_IN('Level for highest colour index', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, C2, -1.E30, 1.E30, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
* Type of wavelength scale
*
      IF(WAVE) THEN
        CALL CHAR_IN('Enter X axis type', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, XAXIS, IFAIL)
        IF(.NOT.SAMECI(XAXIS,'W') .AND. .NOT.SAMECI(XAXIS,'V')
     &     .AND. .NOT.SAMECI(XAXIS,'P')) THEN
          WRITE(*,*) 'Invalid X scale. Possibilities are:'
          WRITE(*,*) ' '
          WRITE(*,*) 'W  -- Wavelength scale'
          WRITE(*,*) 'V  -- Velocity scale'
          WRITE(*,*) 'P  -- Pixel scale.'
          XAXIS = 'W'
          GOTO 999
        END IF
      ELSE
        WRITE(*,*) 'At least one slot has no wavelength scale so'
        WRITE(*,*) 'a pixel scale will be used.'
        XAXIS = 'P'
      END IF
*
* Set defaults if necessary and then specify X scale
*
      VLIGHT = CGS('C')/1.E5
      IF((SAMECI(XAXIS,'W') .AND. WSTART.EQ.WEND) .OR.
     &   (SAMECI(XAXIS,'V') .AND. VPIX.EQ.0.)) THEN
*
        CALL HGETD('Vearth', VEARTH, FSLOT, MXSPEC, 
     &  NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
        IFAIL = 0
        DO J = 1, ABS(NARC(FSLOT))
          AIN(J) = ARC(J,FSLOT)
        END DO
        IF(NARC(FSLOT).GT.0) THEN
          DO J = 1, NARC(SLOT)
            AIN(J) = AIN(J)*(1.-VEARTH/VLIGHT)
          END DO
        ELSE
          AIN(1) = AIN(1) + LOG(1.D0 - VEARTH/DBLE(VLIGHT))
        END IF
        W1  = ANGST(0.5, NPIX(SLOT), NARC(SLOT), AIN, MXARC)
        W2  = ANGST(REAL(NPIX(FSLOT))+0.5, NPIX(SLOT), 
     &        NARC(SLOT), AIN, MXARC)
        IF(W1.GT.W2) THEN
          W  = W1
          W1 = W2
          W2 = W
        END IF
        IF(SAMECI(XAXIS,'W')) THEN
          WSTART = REAL(W1)
          WEND   = REAL(W2)
        ELSE IF(SAMECI(XAXIS,'V')) THEN
          WMID = REAL(SQRT(W1*W2))
          VPIX = REAL(VLIGHT*(EXP(LOG(W2/W1)/DBLE(NPIX(FSLOT)))-1.))
        END IF
        NBIN = NPIX(FSLOT)
      ELSE IF(SAMECI(XAXIS,'P') .AND. PSTART.EQ.PEND) THEN
        PSTART = 1
        PEND   = NPIX(FSLOT)
        NBIN   = NPIX(FSLOT)
      END IF
*
      IF(SAMECI(XAXIS,'W')) THEN
        CALL REAL_IN('Start wavelength', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, WSTART, 0., 1.E6, IFAIL)
        CALL REAL_IN('End wavelength', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, WEND, 0., 1.E6, IFAIL)
      ELSE IF(SAMECI(XAXIS,'V')) THEN
        CALL REAL_IN('Central wavelength', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, WMID, 0., 1.E6, IFAIL)
        CALL REAL_IN('Number of km/s/pixel', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, VPIX, 0., 1.E6, IFAIL)
      ELSE IF(SAMECI(XAXIS,'P')) THEN
        CALL INTR_IN('Start pixel', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PSTART, 1, 100000, IFAIL)
        CALL INTR_IN('End pixel', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PEND, 1, 100000, IFAIL)
      END IF
*
* Number of pixels
*
      IF(SAMECI(XAXIS,'P')) NBIN = PEND-PSTART+1
      CALL INTR_IN('Number of pixels', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, NBIN, 1, MXWORK, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
* Now rebin requested spectra 
*
* First compute output wavelength coefficients
*
      IF(SAMECI(XAXIS,'W')) THEN
        NAOUT = 2
        IF(NBIN.GT.1) THEN
          AOUT(2) = (WEND-WSTART)/(1.D0-1.D0/DBLE(NBIN))
        ELSE
          AOUT(2) = WEND-WSTART
        END IF
        AOUT(1) = WSTART - AOUT(2)/DBLE(NBIN)
      ELSE IF(SAMECI(XAXIS,'V')) THEN
        NAOUT = -2
        AOUT(2) = DBLE(NBIN)*LOG(1.D0+DBLE(VPIX/VLIGHT))
        AOUT(1) = LOG(WMID) - AOUT(2)*DBLE(NBIN+1)/DBLE(NBIN)/2.D0
      ELSE IF(SAMECI(XAXIS,'P')) THEN
        NAOUT = 2
        IF(NBIN.GT.1) THEN
          AOUT(2) = (PEND-PSTART)/(1.D0-1.D0/DBLE(NBIN))
        ELSE
          AOUT(2) = PEND-PSTART
        END IF
        AOUT(1) = PSTART - AOUT(2)/DBLE(NBIN)
      END IF
*
* Now search for work space in data arrays.
*
      IS = 0
      MXWK = 0
      DO I = 1, MXSPEC
        IF(IS.EQ.0 .AND. NPIX(I).LE.0) THEN
          IS = MAXPX*(I-1) + 1
        ELSE IF(IS.GT.0 .AND. NPIX(I).GT.0) THEN
          IL = MAXPX*(I-1)-IS+1
          IF(IL.GT.MXWK) THEN
            MXWK = IL
            ISO  = IS
          END IF
          IS = 0
        END IF
      END DO
      IF(IS.EQ.0) THEN
        IL = MXBUFF - MXSPEC*MAXPX
        IF(IL.GT.MXWK) THEN
          MXWK = IL
          ISO  = MXSPEC*MAXPX+1
        END IF
      ELSE
        IL = MXBUFF-IS+1 
        IF(IL.GT.MXWK) THEN
          MXWK = IL
          ISO  = IS
        END IF
      END IF
      IF(MXWK.LT.NBIN) THEN
        WRITE(*,*) 'Can''t find sufficient workspace'
        WRITE(*,*) 'for plotting trailed spectra.'
        WRITE(*,*) 'You should clear some spectra'
        GOTO 999
      END IF
      NMX = MXWK/NBIN
      IF(NV.GT.NMX) WRITE(*,*) 'Will be plotted in groups of ',NMX
*
*     Open plot device
*
      CALL DEV_OPEN(.TRUE.,NEW,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(SAMECI(XAXIS,'W')) THEN
         XR1 = WSTART
         XR2 = WEND
         XLABEL = 'Wavelength (\\A)'
      ELSE IF(SAMECI(XAXIS,'V')) THEN
         XR1 = -VPIX*REAL(NBIN)/2.
         XR2 = -XR1
         XLABEL = 'Velocity (km/s)'
      ELSE IF(SAMECI(XAXIS,'P')) THEN
         XR1 = PSTART
         XR2 = PEND
         XLABEL = 'Pixel'
      END IF
      YLABEL = 'Spectrum'
      TLABEL = 'Trailed spectrum'
      TR(2) = (XR2-XR1)/REAL(NBIN-1)
      TR(1) = XR1 - TR(2)
      TR(3) = 0.
      TR(5) = 0.
      TR(6) = 1.
      YR1 = 0.5
      YR2 = REAL(NV) + 0.5
      CALL PGWINDOW(XR1, XR2, YR1, YR2)
      CALL DEF_COL(IFAIL)
*     
*     Loop through spectra
*     
      NS = 0      
      NV = 0
      LOW  =  1.E30
      HIGH = -1.E30
      FIRST = .TRUE.
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC,
     &           NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &           NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, 
     &           MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
*     
*     Search for double precision header item Vearth
*     
            IF(SAMECI(XAXIS,'W') .OR. SAMECI(XAXIS,'V')) THEN
               CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &              HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
*     
*     Fudge arc coefficients to remove this velocity to get
*     heliocentric wavelength scale
*     
               DO J = 1, ABS(NARC(SLOT))
                  AIN(J) = ARC(J,SLOT)
               END DO
               IF(NARC(SLOT).GT.0) THEN
                  DO J = 1, NARC(SLOT)
                     AIN(J) = AIN(J)*(1.-VEARTH/VLIGHT)
                  END DO
               ELSE
                  AIN(1) = AIN(1) + LOG(1.D0 - VEARTH/DBLE(VLIGHT))
               END IF
               NAIN = NARC(SLOT)
            ELSE
               AIN(1) = 0.D0
               AIN(2) = DBLE(NPIX(SLOT))
               NAIN   = 2
            END IF
*     
            NV = NV + 1
            NS = NS + 1
            INDI = INSPEC(0,SLOT,MAXPX)
            INDK = ISO + NBIN*(NS-1)
*     
*     Load up work array with fluxes
*     
            DO J = 1, NPIX(SLOT)
               L = INDI + J
               WORK1(J) = GET_FLX(COUNTS(L), FLUX(L))
            END DO
*     
*     Linear rebin 
*     
            CALL REBIN(1, 0, WORK1, NPIX(SLOT), FLUX(INDK), 
     &           NBIN, 0., NAIN, AIN, NAOUT, AOUT)
*     
*     Compute lowest and highest
*     
            DO J = 1, NBIN
               L = INDK + J - 1
               LOW  = MIN(LOW, FLUX(L))
               HIGH = MAX(HIGH, FLUX(L))
            END DO
*     
*     Plot section if buffer full
*     
            IF(NS.EQ.NMX) THEN
               IF(FIRST .AND. C1.EQ.C2) THEN
                  TC1 = LOW
                  TC2 = HIGH
                  IF(C1.EQ.0.) THEN
                     C1 = LOW
                     C2 = HIGH
                  END IF
                  FIRST = .FALSE.
               ELSE
                  TC1 = C1
                  TC2 = C2
               END IF
               TR(4) = REAL(NV-NS)
               CALL PGIMAG(FLUX(ISO),NBIN,NS,1,NBIN,1,NS,TC1,TC2,TR)
               NS = 0
            END IF
         END IF
      END DO
      IF(FIRST .AND. C1.EQ.C2) THEN
         TC1 = LOW
         TC2 = HIGH
         IF(C1.EQ.0.) THEN
            C1 = LOW
            C2 = HIGH
         END IF
         FIRST = .FALSE.
      ELSE
         TC1 = C1
         TC2 = C2
      END IF
      TR(4) = REAL(NV-NS)
      CALL PGIMAG(FLUX(ISO),NBIN,NS,1,NBIN,1,NS,TC1,TC2,TR)
      CALL PGBOX('BCNST', 0., 0, 'BCNST', 0., 0)
      CALL PGLABEL(XLABEL, YLABEL, TLABEL)
      CALL PGIDEN
      IF(CLOSE) CALL DEV_CLOSE(0,IFAIL)
 999  RETURN
      END
