CWRITE
C WRITE FILE N1 N2 OLD -- Writes out spectra in MOLLY format.
C
C Parameters: 
C     
C   File - File name to write to
C   N1  -- First spectrum to write
C   N2  -- Last spectrum to write or 'LR' to write out the same number of
C          spectra as were Last Read in.
C   OLD  - If Y then routine tries to open old file and add spectra to it.
C         If N it opens a new file.
C
C Selection criteria apply. Use 'molex' to set/unset default file extension
C .mol
C
C Related commands: molex, load
CWRITE
      SUBROUTINE SPCDMP(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &     HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &     MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &     NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &     MXSDOUB, MXSINTR, MXSREAL, SLOTS, MXSLOTS, MUTE, CLOBBER, 
     &     MOLEX, NREAD, IFAIL)
C     
C     Master routine for dumping spectra from MOLLY buffers
C     allowing selection criteria to be applied.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  I     SLOTS(MXSLOTS)     -- Work array for list
C     >  I     MXSLOTS            -- Size of work array
C     >                              incremented and returned by routine.
C     >  L     MUTE               -- Cut out terminal I/O
C     >  L     CLOBBER            -- Overwrite files on output
C     >  L     MOLEX              -- Default file extension .mol
C     >  I     NREAD              -- Number last read by SPCRED
C     >  I     IFAIL
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, NREAD
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      CHARACTER*200 FILENAME
      CHARACTER*210 FILE
      CHARACTER*100 STRING
      CHARACTER*16 UNITS
      CHARACTER*32 LAST
      CHARACTER*10 FSTAT
      INTEGER SLOT1, SLOT2, IFAIL, LUNIT, ND
      INTEGER I,   MAXSPEC
      LOGICAL SELECT, SAME,  OLD, DEFAULT, MUTE, ESAMECI
      LOGICAL CLOBBER, MOLEX
      INTEGER  NCOM, L, LENSTR
C     
      DATA FILENAME, FSTAT/'spectrum', 'N'/
      DATA SLOT1, SLOT2/1,1/
      DATA LAST/'1'/
      DATA LUNIT/23/
      SAVE FILENAME, SLOT1, SLOT2, LIST, NLIST, FSTAT
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM = 0
      IFAIL = 0
      CALL CHAR_IN('File name', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, FILENAME, IFAIL)
      CALL INTR_IN('First slot to dump', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      IF(.NOT.ESAMECI(LAST, 'LR')) WRITE(LAST,*) SLOT2
      CALL CHAR_IN('Last slot to dump', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, LAST, IFAIL)
      IF(.NOT.ESAMECI(LAST, 'LR')) THEN
         READ(LAST,*,IOSTAT=IFAIL) SLOT2
         IF(IFAIL.NE.0) THEN
            SLOT2 = SLOT1
            GOTO 999
         END IF
         IF(SLOT2.LT.SLOT1 .OR. SLOT2.GT.MAXSPEC) THEN
            WRITE(*,*) 'Slot out of range.'
            SLOT2 = SLOT1
            GOTO 999
         END IF
      ELSE IF(NREAD.EQ.0) THEN
         WRITE(*,*) 'No spectra have been read yet.'
         GOTO 999
      ELSE IF(NREAD+SLOT1-1.GT.MAXSPEC) THEN
         WRITE(*,*) 'Number last read = ',NREAD,' which takes'
         WRITE(*,*) 'you beyond maximum slot.'
         GOTO 999
      ELSE
         SLOT2 = SLOT1 + NREAD - 1
      END IF
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to dump'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
C     
      CALL CHAR_IN('Is this an old file?', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FSTAT, IFAIL)
      CALL UPPER_CASE(FSTAT)
      IF(SAME(FSTAT,'YES') .OR. SAME(FSTAT,'OLD')) THEN
         OLD = .TRUE.
      ELSE IF(SAME(FSTAT,'NO') .OR. SAME(FSTAT,'NEW') ) THEN
         OLD = .FALSE.
      ELSE
         WRITE(*,*) 'Invalid parameter ',FSTAT
         FSTAT = 'N'
         GOTO 999
      END IF
C     
C     Open file for writing
C     
      L = LENSTR(FILENAME)
      IF(MOLEX .AND. (INDEX(FILENAME, '.mol').EQ.0 .OR. 
     &     INDEX(FILENAME, '.mol').NE.L-3)) THEN
         FILE = FILENAME(:L)//'.mol'
      ELSE
         FILE = FILENAME
      END IF
      IF(OLD) THEN
         OPEN(UNIT=LUNIT,FILE=FILE,FORM='UNFORMATTED',
     &        STATUS='OLD',IOSTAT=IFAIL)
      ELSE IF(CLOBBER) THEN
         OPEN(UNIT=LUNIT,FILE=FILE,FORM='UNFORMATTED',
     &        STATUS='UNKNOWN',IOSTAT=IFAIL)
      ELSE 
         OPEN(UNIT=LUNIT,FILE=FILE,FORM='UNFORMATTED',
     &        STATUS='NEW',IOSTAT=IFAIL)
      END IF
      IF(IFAIL.NE.0) THEN
         WRITE(*,*) 'Could not open ',FILE(:LENSTR(FILE))
         RETURN
      END IF
C     
C     If an old file skip down to end. 5 records per spectrum
C     see WTHEAD
C     
      IF(OLD) THEN
 100     CONTINUE
         CALL SKIP_SPEC(LUNIT, IFAIL)
         IF(IFAIL.EQ.0) THEN
            GOTO 100
         ELSE IF(IFAIL.GT.0 .OR. IFAIL.NE.-100) THEN
            WRITE(*,*) 'Error while skipping to end-of-file ',IFAIL
            GOTO 999
         END IF
      END IF
C     
C     Start to dump files, checking headers as we go.
C     
      ND = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
C     
C     Apply selection criteria
C     
         IF(NPIX(SLOT).LE.0 .OR. .NOT.SELECT(SLOT, NMCHAR, NMDOUB, 
     &        NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &        NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &        MXREAL, MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &        NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &        NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &        MXSREAL)) THEN
            IF(.NOT.MUTE) WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
            GOTO 200
         END IF
C     
C     MOLLY internal format only millijanskys
C     
         UNITS = 'MILLIJANSKYS'
C     
C     Write header, format code = 3 for MOLLY.
C     
         CALL WTHEAD(LUNIT, 3, UNITS, NPIX(SLOT), 
     &        NARC(SLOT), NCHAR(SLOT), NDOUB(SLOT), NINTR(SLOT), 
     &        NREAL(SLOT), MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        NMCHAR(1,SLOT), NMDOUB(1,SLOT), NMINTR(1,SLOT), 
     &        NMREAL(1,SLOT), HDCHAR(1,SLOT), HDDOUB(1,SLOT), 
     &        HDINTR(1,SLOT), HDREAL(1,SLOT), IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed on spectrum ',SLOT
            GOTO 999
         END IF
C     
C     Write data
C     
         CALL WTDATA(LUNIT, COUNTS(1,SLOT), ERRORS(1,SLOT), 
     &        FLUX(1,SLOT), ARC(1,SLOT), 3, NPIX(SLOT), NARC(SLOT), 
     &        IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed on spectrum ',SLOT
            GOTO 999       
         END IF
C     
         IF(.NOT.MUTE) THEN
            CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
         ND = ND + 1
 200     CONTINUE
      END DO
      WRITE(*,*) 'Dumped ',ND,' spectra to ',FILE(:LENSTR(FILE))
      IFAIL = 0
 999  CLOSE(UNIT=LUNIT)
      RETURN
      END
