*VBIN
* VBIN N1 N2 N3 W0 VP NP METHOD [FRAC] -- Rebins to uniform velocity scale
*
* The earth's velocity will be removed, or in other words the spectrum is
* rebinned to a heliocentric frame. Edit out Vearth if you don't want this.
* Selection criteria can be applied. The program interpolates bad pixels
* prior to rebinning but masks output pixels if they are more than FRAC
* covered by bad input pixels.
*
* Parameters: 
*     
*  N1    -- Slot number of first spectrum to rebin
*  N2    -- Slot number of last spectrum to rebin
*  N3    -- Slot in which to start results
*  W0    -- Central wavelength of region in Angstroms
*  VP    -- km/s/pixel
*  NP    -- Number of pixels (symmetric about W0)
*  METHOD - Interpolation method. Choices:
*           L(inear), Q(uadratic), S(inc)
*
*           Quadratic rebinning is recommended for most purposes. Linear
*           rebinning is only in case speed is of the essence. Both linear
*           and quadratic rebinning cause significant smoothing of the data
*           (especially linear). In an effort to reduce this, rebinning using
*           a (Sin X)/X = "Sinc" has been implemented. This is much slower, but 
*           may be necessary if you are interested in measuring broadening at 
*           a level near your spectral resolution for example. The sinc
*           function is tapered by a window function to reduce overshoot in
*           frequency space. If you do use sinc rebinning, it would be well to
*           get rid of cosmic rays and other bad pixels first since their
*           effects can spread. A check is made to see if the rebinning 
*           requested is really just a shift in which case a fast version
*           of sinc interpolation is used.
*
*  FRAC --  (Not prompted for) Minimum fraction of output pixel covered
*           by input pixel for it to be masked.
*
* Related commands: WBIN, TBIN
*VBIN
*WBIN
* WBIN N1 N2 N3 W1 W2 NP METHOD [FRAC] -- Rebins to uniform wavelength scale
*
* The earth's velocity will be removed, or in other words the spectrum is
* rebinned to a heliocentric frame. Edit out Vearth if you don't want this.
* Selection criteria can be applied. The program interpolates bad pixels
* prior to rebinning but masks output pixels if they are more than FRAC
* covered by bad input pixels.
*
* Parameters: 
*     
*  N1    -- Slot number of first spectrum to rebin
*  N2    -- Slot number of last spectrum to rebin
*  N3    -- Slot in which to start results
*  W1    -- Start wavelength in Angstroms (left edge of first pixel)
*  W2    -- End wavelength in Angstroms (right edge of last pixel)
*  NP    -- Number of pixels
*  METHOD - Interpolation method. Choices:
*           L(inear), Q(uadratic), S(inc)
*
*           Quadratic rebinning is recommended for most purposes. Linear
*           rebinning is only in case speed is of the essence. Both linear
*           and quadratic rebinning cause significant smoothing of the data
*           (especially linear). In an effort to reduce this rebinning using
*           a (Sin X)/X = "Sinc" has been implemented. This is much slower, but 
*           may be necessary if you are interested in measuring broadening at 
*           a level near your spectral resolution for example. The sinc
*           function is tapered by a window function to reduce overshoot in
*           frequency space. If you do use sinc rebinning, it would be well to
*           get rid of cosmic rays and other bad pixels first since their
*           effects can spread. A check is made to see if the rebinning 
*           requested is really just a shift in which case a fast version
*           of sinc interpolation is used.
*
*  FRAC --  (Not prompted for) Minimum fraction of output pixel covered
*           by input pixel for it to be masked.
*
* Related commands: VBIN, TBIN
*WBIN
*TBIN
* TBIN N1 N2 N3 NT1 NT2 METHOD [FRAC] -- Rebins to wavelength scale of
*                                        template spectra.
*
* Spectra will be rebinned onto the wavelength scale of another set of 
* spectra or a single spectrum.
*
* Parameters: 
*     
*  N1    -- Slot number of first spectrum to rebin
*  N2    -- Slot number of last spectrum to rebin
*  N3    -- Slot in which to start results
*  NT1   -- First and last template spectra. Same to
*  NT2   -- get just one.
*  METHOD - Interpolation method. Choices:
*           L(inear), Q(uadratic), S(inc)
*
*           Quadratic rebinning is recommended for most purposes. Linear
*           rebinning is only in case speed is of the essence. Both linear
*           and quadratic rebinning cause significant smoothing of the data
*           (especially linear). In an effort to reduce this rebinning using
*           a (Sin X)/X = "Sinc" has been implemented. This is much slower, but 
*           may be necessary if you are interested in measuring broadening at 
*           a level near your spectral resolution for example. The sinc
*           function is tapered by a window function to reduce overshoot in
*           frequency space. If you do use sinc rebinning, it would be well to
*           get rid of cosmic rays and other bad pixels first since their
*           effects can spread. A check is made to see if the rebinning 
*           requested is really just a shift in which case a fast version
*           of sinc interpolation is used.
*
*  FRAC --  (Not prompted for) Minimum fraction of output pixel covered
*           by input pixel for it to be masked.
*
* Related commands: VBIN, WBIN
*TBIN
      SUBROUTINE SPCBIN(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &     HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &     MXDOUB, MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, 
     &     VSDOUB, NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &     NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &     MXSREAL, RMETH, WORK1, WORK2, WORK3, WORK4, WORK5,
     &     WORK6, MXWORK, SLOTS1, SLOTS2, MXSLOTS, IFAIL)
C
C Rebins spectra to a uniform velocity or wavelength scale.
C 
C Arguments:
C
C >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C                              zero in which case defaults are used.
C >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C >  I     MXSPEC           -- Maximum number of spectra allowed by size
C                              of header buffers. 
C >  I     MAXPX            -- Maximum number of pixels/spectrum
C <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C <  I     NCHAR(MXSPEC)  -- Number of character header items.
C <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C <  I     NINTR(MXSPEC)  -- Number of integer items.
C <  I     NREAL(MXSPEC)  -- Number of real items.
C >  I     MXCHAR    -- Maximum number of character header items/spec
C >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C >  I     MXINTR    -- Maximum number of integer header items/spec
C >  I     MXREAL    -- Maximum number of real headers items/spec
C >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C >  I     NSCHAR             -- Number of character selection items.
C >  I     NSDOUB             -- Number of double precsion selection items.
C >  I     NSINTR             -- Number of integer selection items.
C >  I     NSREAL             -- Number of real selection items.
C >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C >  C     RMETH              -- 'W', 'V' or 'T': method being used
C >  R     WORK1  Work array
C >  R     WORK2      "
C >  R     WORK3      "
C >  R     WORK4      "
C >  R     WORK5      "
C >  R     WORK6      "
C >  I     MXWORK     Size of work array
C    I     SLOTS1(MXSLOTS) -- Work array for list of slots
C    I     SLOTS2(MXSLOTS) -- Work array for list of slots
C    I     MXSLOTS
C <  I     IFAIL              -- Error return.
C
      IMPLICIT NONE

C
C Integer parameters
C
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MX
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C
C Data arrays
C
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C
C Numbers of header items
C
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C
C Names of header items
C
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C
C Values of header items
C
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C
C Search parameters
C
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C
C Search parameters, names then values.
C
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C
C Arc coefficients
C
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C
C Command parameters
C
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*(*) RMETH
C
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
      REAL WORK5(MXWORK), WORK6(MXWORK)
C
C     Slot lists
C
      INTEGER MXSLOTS, NSLOTS1, NSLOTS2, SLOT, OUT
      INTEGER SLOTS1(MXSLOTS), SLOTS2(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST1, LIST1(2,MXLIST)
      INTEGER NLIST2, LIST2(2,MXLIST)
C
C Local variables
C
      INTEGER I, J, K,  N, I1, I2, J1, J2, NBAD, NTEMP
      INTEGER   NV, K1, K2, NNEW, L, M, M1, M2
      REAL GET_FLX,  CFRAT, FLX1, FLX2, VAR1, VAR2
      DOUBLE PRECISION  ANGST, PIXL, W, W1, W2
      DOUBLE PRECISION SUM, ALPHA, BETA, FAC
      DOUBLE PRECISION WSTART, WEND, WMID, VPIX, VAVE
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, IFAIL, MAXSPEC
      REAL  FRAC, TOTAL, BAD
      REAL  VLIGHT, Z, P, P1, P2
      LOGICAL SELECT, SAMECI
      LOGICAL DEFAULT, SHIFT
      REAL SSKEW
      INTEGER NBIN, NAOUT, MXABF, TSLOT1, TSLOT2, TEMP
      PARAMETER (MXABF=30)
      DOUBLE PRECISION AOUT(MXABF), AIN(MXABF), AOUTTEMP(MXABF)
      DOUBLE PRECISION STORE(MXABF), VEARTH, VTEMP
      CHARACTER*1 METHOD
C
C Functions
C
      REAL CGS
C
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA WSTART, WMID, WEND/0.D0, 0.D0, 0.D0/
      DATA NBIN, VPIX, FRAC/0, 0.D0, 0.3/
      DATA TSLOT1, TSLOT2, METHOD/1, 1, 'Q'/
C
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C
C First slot
C
      CALL INTR_IN('First spectrum to rebin', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C
C Second slot
C
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to rebin', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to rebin'
         CALL GETLIS(LIST1, NLIST1, MXLIST, MAXSPEC, SLOTS1, 
     &        NSLOTS1, MXSLOTS)
         IF(NSLOTS1.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST1, NLIST1, MXLIST, SLOTS1, 
     &        NSLOTS1, MXSLOTS)
      END IF
C     
C     Determine upper and lower wavelengths of first valid spectrum
C     
      VLIGHT = CGS('C')/1.E5
      W1 =  1.D30
      W2 = -1.D30
      NV = 0
      DO I = 1, NSLOTS1
         SLOT = SLOTS1(I)
         IF(NPIX(SLOT).GT.0 .AND. NARC(SLOT).NE.0 .AND.
     &        SELECT(SLOT,NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &        HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &        VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &        NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN 
            IF(NV.EQ.0) THEN
               NV = NV + 1
               CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
C     
C     Fudge arc coefficients to remove this velocity to get
C     heliocentric wavelength scale
C     
               DO J = 1, ABS(NARC(SLOT))
                  AIN(J) = ARC(J,SLOT)
               END DO
               IF(NARC(SLOT).GT.0) THEN
                  DO J = 1, NARC(SLOT)
                     AIN(J) = AIN(J)*(1.-VEARTH/VLIGHT)
                  END DO
               ELSE
                  AIN(1) = AIN(1) - VEARTH/VLIGHT
               END IF 
               W  = ANGST(0.5, NPIX(SLOT), NARC(SLOT), AIN, MXARC)
               W1 = MIN(W1, W)
               W2 = MAX(W2, W)
               Z  = REAL(NPIX(SLOT)) + 0.5
               W  = ANGST(Z, NPIX(SLOT), NARC(SLOT), AIN, MXARC)
               W1 = MIN(W1, W)
               W2 = MAX(W2, W)
               IF(SAMECI(RMETH,'W')) THEN
                  WRITE(*,'(1X,A,G12.6,A,G12.6,A,I5,A)') 
     &                 'First valid spectrum covers ',W1,
     &                 ' to ',W2,' in ',NPIX(SLOT),' pixels.'
                  IF(NBIN.LE.0)    NBIN   = NPIX(SLOT)
                  IF(WSTART.LE.0.D0) WSTART = W1
                  IF(WEND  .LE.0.D0) WEND   = W2
               ELSE IF(SAMECI(RMETH,'V')) THEN
                  VAVE = VLIGHT*(EXP(LOG(W2/W1)/DBLE(NPIX(SLOT)))-1.)
                  IF(VPIX.EQ.0.D0) VPIX = VAVE
                  IF(NBIN.LE.0)  NBIN = NPIX(SLOT)
                  WRITE(*,'(1X,A,G12.6,A,G12.6)') 
     &                 'First valid spectrum covers ',W1,' to ',W2
                  WRITE(*,'(1X,A,I5,A,G11.4,A)')
     &                 'Using ',NPIX(SLOT),' pixels at ',VAVE,
     &                 ' km/s/pixel.'
                  WRITE(*,*) 'Velocity centre is at ',SQRT(W1*W2)
                  IF(WMID.LE.0.D0) WMID = SQRT(W1*W2)
               END IF
            ELSE
               NV = NV + 1
            END IF
         END IF
      END DO
      IF(NV.EQ.0) THEN
         WRITE(*,*) 'No valid spectra'
         GOTO 999    
      END IF
C     
C     First slot for output
C     
      CALL INTR_IN('First spectrum for output', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NV+1, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
C     First template slot
C     
      IF(SAMECI(RMETH,'T')) THEN
         CALL INTR_IN('First template spectrum', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, TSLOT1, 0, MAXSPEC, IFAIL)
C     
C     Second slot
C     
         TSLOT2 = MAX(TSLOT1, TSLOT2)
         CALL INTR_IN('Last template spectrum', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, TSLOT2, TSLOT1, MAXSPEC, IFAIL)
         IF(IFAIL.NE.0) GOTO 999
         IF(TSLOT1.EQ.0 .AND. TSLOT2.NE.0) THEN
            WRITE(*,*) 'Only 0,0 to get list option'
            GOTO 999
         ELSE IF(TSLOT1.EQ.0 .AND. TSLOT2.EQ.0) THEN
            WRITE(*,*) 'Enter list of template spectra'
            CALL GETLIS(LIST2, NLIST2, MXLIST, MAXSPEC, SLOTS2, 
     &           NSLOTS2, MXSLOTS)
            IF(NSLOTS2.EQ.0) GOTO 999
         ELSE
            CALL SETLIS(TSLOT1, TSLOT2, LIST2, NLIST2, MXLIST, 
     &           SLOTS2, NSLOTS2, MXSLOTS)
         END IF
         IF(NSLOTS2.NE.1 .AND. NSLOTS2.NE.NSLOTS1) THEN
            WRITE(*,*) 'Must either have the same number of templates'
            WRITE(*,*) 'as input spectra or just one.'
            GOTO 999
         END IF
      ELSE
C     
C     Start or central wavelength
C     
         IFAIL = 0
         IF(SAMECI(RMETH,'W')) THEN
            CALL DOUB_IN('Start wavelength', SPLIT, NSPLIT,
     &           MXSPLIT, NCOM, DEFAULT, WSTART, 0.D0, 1.D20, IFAIL)
         ELSE IF(SAMECI(RMETH,'V')) THEN
            CALL DOUB_IN('Central wavelength', SPLIT, NSPLIT, 
     &           MXSPLIT, NCOM, DEFAULT, WMID, 0.D0, 1.D20, IFAIL)
         END IF
C     
C     End wavelength or number of km/s/pixel
C     
         IF(SAMECI(RMETH,'W')) THEN
            CALL DOUB_IN('End wavelength', SPLIT, NSPLIT, 
     &           MXSPLIT, NCOM, DEFAULT, WEND, 0.D0, 1.D20, IFAIL)
         ELSE IF(SAMECI(RMETH,'V')) THEN
            CALL DOUB_IN('Number of km/s/pixel', SPLIT, NSPLIT, 
     &           MXSPLIT, NCOM, DEFAULT, VPIX, -1.D20, 1.D20, IFAIL)
         END IF
         IF(IFAIL.NE.0) GOTO 999
         IF(SAMECI(RMETH,'W') .AND. WEND.EQ.WSTART) THEN
            WRITE(*,*) 'Null range'
            GOTO 999
         ELSE IF(SAMECI(RMETH,'V') .AND. VPIX.EQ.0.D0) THEN
            WRITE(*,*) 'Cannot have 0 km/s/pixel'
            GOTO 999
         END IF
C     
C     Number of pixels
C     
         MX = MIN(MXWORK,MAXPX)
         CALL INTR_IN('Number of pixels', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, NBIN, 1, MX, IFAIL)
      END IF
C     
C     Interpolation method
C     
      CALL CHAR_IN('Interpolation method (L,Q,S)', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, METHOD, IFAIL)
      IF(.NOT.SAMECI(METHOD,'L') .AND. .NOT.SAMECI(METHOD,'Q')
     &     .AND. .NOT.SAMECI(METHOD,'S')) THEN
         WRITE(*,*) 'Unrecognised interpolation method'
         WRITE(*,*) 'Valid methods are:'
         WRITE(*,*) '  L -- Linear'
         WRITE(*,*) '  Q -- Quadratic'
         WRITE(*,*) '  S -- Sinc function'
         METHOD = 'L'
         GOTO 999
      END IF
      IF(NCOM+1.EQ.NSPLIT) THEN
         CALL REAL_IN('Minimum bad pixel fraction', SPLIT, 
     &        NSPLIT, MXSPLIT, NCOM, DEFAULT, FRAC, 0., 1., IFAIL)
      END IF
      IF(IFAIL.NE.0) GOTO 999
C     
C     Now perform rebin
C     
C     First compute output wavelength coefficients.
C     
      IF(SAMECI(RMETH,'W')) THEN
         NAOUT = 2
         AOUT(2) = WEND-WSTART
         AOUT(1) = WSTART - AOUT(2)/DBLE(NBIN)/2.D0
      ELSE IF(SAMECI(RMETH,'V')) THEN
         NAOUT   = -2
         AOUT(2) = DBLE(NBIN)*LOG(1.D0+DBLE(VPIX/VLIGHT))
         AOUT(1) = LOG(WMID) - AOUT(2)*DBLE(NBIN+1)/DBLE(NBIN)/2.D0
      END IF
C     
C     Loop through spectra
C     
      NV = 0      
      DO I = 1, NSLOTS1
         SLOT = SLOTS1(I)
C     
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NPIX(SLOT).GT.MXWORK) THEN
            WRITE(*,*) 'Too large for work arrays'
         ELSE IF(NARC(SLOT).EQ.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no wavelength scale'
            WRITE(*,*) 'and will be skipped'
         ELSE IF(ABS(NARC(SLOT)).GT.MXABF) THEN
            WRITE(*,*) 'SPCBIN internal buffer size MXABF'
            WRITE(*,*) 'is too small'
            WRITE(*,*) 'Slot ',SLOT,' will be skipped.'
         ELSE IF(.NOT.SELECT(SLOT,NMCHAR, NMDOUB, 
     &           NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &           NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &           MXINTR, MXREAL, MXSPEC, NMSCHAR, VSCHAR, 
     &           NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, VSREAL, 
     &           NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &           MXSINTR, MXSREAL)) THEN                
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
C     
C     Check out template if need be
C     
            IF(SAMECI(RMETH,'T')) THEN
               IF(NSLOTS2.EQ.1) THEN
                  TEMP = SLOTS2(1)
               ELSE
                  TEMP = SLOTS2(I)
               END IF
               IF(NPIX(TEMP).LE.0) THEN
                  WRITE(*,*) 'Oh dear. Template slot is empty.'
                  GOTO 999
               ELSE IF(NARC(TEMP).EQ.0) THEN
                  WRITE(*,*) 'Oh dear. Template slot'//
     &                 ' has no wavelength scale.'
                  GOTO 999
               END IF
               NBIN  = NPIX(TEMP)
               NAOUT = NARC(TEMP)
               DO J = 1, ABS(NAOUT)
                  AOUT(J) = ARC(J,TEMP)
               END DO
               CALL HGETD('Vearth', VTEMP, TEMP, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
            END IF
C     
C     Search for double precision header item Vearth
C     
            CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &           NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'No Vearth for slot ',SLOT,'; assume = 0'
            END IF
            IFAIL = 0
            IF(SAMECI(RMETH,'T')) VEARTH = VEARTH - VTEMP
C     
C     Fudge arc coefficients to remove this velocity to get
C     heliocentric wavelength scale (use the difference in the template
C     case)
C     
            DO J = 1, ABS(NARC(SLOT))
               AIN(J) = ARC(J,SLOT)
            END DO
            IF(NARC(SLOT).GT.0) THEN
               DO J = 1, NARC(SLOT)
                  AIN(J) = AIN(J)*(1.-VEARTH/VLIGHT)
               END DO
            ELSE
               AIN(1) = AIN(1) + LOG(1.D0-VEARTH/DBLE(VLIGHT))
            END IF 
C     
C     Load up work arrays with fluxes, variances in counts and
C     count/flux ratios. Only rebin within range of good pixels
C     although note that this does not account properly for
C     bad pixels within the range (this is done later).
C     
            I1 = 0
            I2 = 0
            N  = 0
            DO J = 1, NPIX(SLOT)
               IF(ERRORS(J,SLOT).GT.0.) THEN
                  IF(I1.EQ.0) I1 = J
                  I2 = J
               END IF
               IF(I1.GT.0) THEN
                  N = N + 1
                  WORK1(N) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
                  WORK2(N) = ERRORS(J,SLOT)**2
                  WORK3(N) = CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                  IF(ERRORS(J,SLOT).GT.0.) THEN
                     WORK4(N) = 1.
                  ELSE
                     WORK4(N) = -1.
                  END IF
               END IF
            END DO
            NNEW = I2-I1+1
C     
C     Second pass to interpolate over bad pixels
C     
            DO J = 1, NNEW
               IF(WORK4(J).LT.0.) THEN
                  K = J - 1
                  DO WHILE(WORK4(K).LT.0.)
                     K = K - 1
                  END DO
                  FLX1 = WORK1(K)
                  VAR1 = WORK2(K)
                  K1   = K            
                  K = J + 1
                  DO WHILE(WORK4(K).LT.0.)
                     K = K + 1
                  END DO
                  FLX2 = WORK1(K)
                  VAR2 = WORK2(K)
                  K2   = K            
                  WORK1(J) = (REAL(J-K1)*FLX2+REAL(K2-J)*FLX1)/
     &                 REAL(K2-K1)
                  WORK2(J) = (REAL(J-K1)*VAR2+REAL(K2-J)*VAR1)/
     &                 REAL(K2-K1)
               END IF
            END DO
C     
C     Correct ARC scale first to remove bad end pixels from consideration
C     
            IF(I1.GT.1 .OR. I2.LT.NPIX(SLOT)) THEN
               ALPHA = DBLE(NNEW)/DBLE(NPIX(SLOT))
               BETA  = DBLE(I1-1)/DBLE(NPIX(SLOT))
               DO J = 1, ABS(NARC(SLOT))
                  IF(J.EQ.1) THEN
                     FAC = 1.D0
                  ELSE
                     FAC = ALPHA**(J-1)
                  END IF
                  SUM = 0.D0
                  DO K = J, ABS(NARC(SLOT))
                     SUM = SUM + FAC*AIN(K)
                     FAC = FAC*BETA*DBLE(K)/DBLE(K-J+1)
                  END DO
                  STORE(J) = SUM
               END DO
               DO J = 1, ABS(NARC(SLOT))
                  AIN(J) = STORE(J)
               END DO
            END IF
C     
C     Get output slot
C     
            NV = NV + 1
            OUT = SLOT3 + NV - 1
C     
C     Determine pixels of output slot covered by input spectrum
C
            Z = 0.5
            W1 = ANGST(Z, NNEW, NARC(SLOT), AIN, MXARC)
            Z = REAL(NNEW)+0.5
            W2 = ANGST(Z, NNEW, NARC(SLOT), AIN, MXARC)
            P1 = REAL(PIXL(W1, NBIN, NAOUT, AOUT, MXABF))
            P2 = REAL(PIXL(W2, NBIN, NAOUT, AOUT, MXABF))
C
C     This deals with reverse scales
C
            IF(P1.GT.P2) THEN
               P  = P1
               P1 = P2
               P2 = P
            END IF

C     Danny Steeghs
C
C     REBIN BUG: doesn't handle output scale that vastly exceeds input scale
C     such as in echelle orders. need to constrain AOUT within REBIN
C 
C     construct temp AOUTTEMP(NAOUT) for rebin restricting its range
C     rebin then operates on workarray from P1-P2 with restricted scale
C
C     (check for reversed arc scales)

C     DS
C     Determine relevant output pixel range M1-M2
C
            M1 = MAX(1,NINT(P1))
            M2 = MIN(NBIN,NINT(P2))
            NTEMP=M2-M1+1
C     DS
C     Adjust arcscale temporarily to span the NTEMP elements M1 to M2
C
      IF( SAMECI(RMETH,'W') .OR. SAMECI(RMETH,'V') ) THEN

C
C     Modified method TRM 16/06/03 after Pablo reported a problem with vbin.
C
         AOUTTEMP(1) = AOUT(1) + DBLE(M1-1)/DBLE(NBIN)*AOUT(2)
         AOUTTEMP(2) = DBLE(NTEMP)/DBLE(NBIN)*AOUT(2)

c     DS
c     Watch for reversals
c
c         IF ( W1 .GT. W2 ) THEN
c            W1TEMP=MAX(WSTART,W2)
c            W2TEMP=MIN(WEND,W1)
c         ELSE
c            W1TEMP=MAX(WSTART,W1)
c            W2TEMP=MIN(WEND,W2)
c         END IF
c         AOUTTEMP(2) = W2TEMP-W1TEMP
c         AOUTTEMP(1) = W1TEMP-AOUTTEMP(2)/DBLE(NTEMP)/2.D0
c
c      ELSE IF( SAMECI(RMETH,'V') ) THEN
c
c         AOUTTEMP(2) = DBLE(NTEMP)*LOG(1.D0+DBLE(VPIX/VLIGHT))
c         Z = 0.5
c         WSTART = ANGST(Z, NBIN, NAOUT, AOUT, MXARC)
c         Z = REAL(NBIN)+0.5
c         WEND = ANGST(Z, NBIN, NAOUT, AOUT, MXARC)
c         IF ( W1 .GT. W2 ) THEN
c            W1TEMP=MAX(WSTART,W2)
c            W2TEMP=MIN(WEND,W1)
c         ELSE
c            W1TEMP=MAX(WSTART,W1)
c            W2TEMP=MIN(WEND,W2)
c         END IF
c         AOUTTEMP(1) = LOG( W1TEMP+(W2TEMP-W1TEMP)/2.D0)-
c     &        AOUTTEMP(2)*DBLE(NTEMP+1)/DBLE(NTEMP)/2.D0

      ELSE IF( SAMECI(RMETH,'T') ) THEN
C     DS
C     Don't do anything if template slot is to be used
C
         NTEMP=NBIN
         M1=1
         DO J=1,ABS(NAOUT)
            AOUTTEMP(J)=AOUT(J)
         ENDDO
      END IF

C  
C     Rebin flux array with method of choice, but rebin
C     errors and counts/flux ratio with a linear rebin to
C     save time. The latter are rebinned by summing to preserve
C     the total number of counts. For sincbin check to see
C     whether the rebin is a straight shift in which case it
C     can be made much faster
C     
            IF(SAMECI(METHOD,'L')) THEN
               CALL REBIN(1, 0, WORK1, NNEW, WORK4(M1), NTEMP, 0.,
     &              NARC(SLOT), AIN, NAOUT, AOUTTEMP)
            ELSE IF(SAMECI(METHOD,'Q')) THEN
               CALL REBIN(1, 1, WORK1, NNEW, WORK4(M1), NTEMP, 0.,
     &              NARC(SLOT), AIN, NAOUT, AOUTTEMP)
            ELSE IF(SAMECI(METHOD,'S')) THEN
               CALL ARCSHF(AIN, NARC(SLOT), NNEW, AOUTTEMP, NAOUT, 
     &              NTEMP, MXARC, SHIFT, SSKEW)
               IF(SHIFT) THEN
                  WRITE(*,*) 'Shift of ',SSKEW,' pixels to the left'
                  CALL SINCBIN(0, WORK1, NNEW, WORK4(M1), NTEMP, SSKEW,
     &                 NARC(SLOT), AIN, NAOUT, AOUTTEMP, WORK5, WORK6)
               ELSE
                  CALL SINCBIN(1, WORK1, NNEW, WORK4(M1), NTEMP, 0.,
     &                 NARC(SLOT), AIN, NAOUT, AOUTTEMP, WORK5, WORK6)
               END IF
            END IF
            CALL REBIN(-1, 0, WORK2, NNEW, WORK1(M1), NTEMP, 0.,
     &           NARC(SLOT), AIN, NAOUT, AOUTTEMP)
            CALL REBIN(-1, 0, WORK3, NNEW, WORK2(M1), NTEMP, 0.,
     &           NARC(SLOT), AIN, NAOUT, AOUTTEMP)

C
C     Eliminate those not covered by the input spectrum.
C     
            NBAD = 0
            DO J = 1, NBIN
               WORK3(J) = 1.
            END DO

            IF(P1-NINT(P1)+0.5.GT.FRAC) THEN
               J1 = NINT(P1)
            ELSE
               J1 = NINT(P1)-1
            END IF
            DO J = 1, J1
               NBAD = NBAD + 1
               WORK3(J) = -1.
            END DO
            IF(NINT(P2)+0.5-P2.GT.FRAC) THEN
               J2 = NINT(P2)
            ELSE
               J2 = NINT(P2)+1
            END IF
            DO J = J2, NBIN
               NBAD = NBAD + 1
               WORK3(J) = -1.
            END DO
C     
C     For speed, now check through old spectrum for bad pixels. When found
C     then new spectrum pixels affected are inverted back onto old array
C     and the fractional coverage is added up. This is faster than checking 
C     every new pixel directly since most pixels should be ok. Further savings
C     are made by never rejecting the same pixel twice.
C     
            DO L = 1, NNEW
               IF(ERRORS(I1+L-1,SLOT).LE.0.) THEN
                  Z  = REAL(L-0.5)
                  W1 = ANGST(Z, NNEW, NARC(SLOT), AIN, MXARC)
                  Z  = REAL(L+0.5)
                  W2 = ANGST(Z, NNEW, NARC(SLOT), AIN, MXARC)
                  P1 = REAL(PIXL(W1, NBIN, NAOUT, AOUT, MXABF))
                  P2 = REAL(PIXL(W2, NBIN, NAOUT, AOUT, MXABF))
                  IF(P1.GT.P2) THEN
                     P  = P1
                     P1 = P2
                     P2 = P
                  END IF
                  M1 = MAX(1,NINT(P1))
                  M2 = MIN(NBIN,NINT(P2))
C     
C     Now check these potentially duff pixels
C     
                  DO M = M1, M2
                     IF(WORK3(M).GT.0.) THEN
                        Z  = REAL(M-0.5)
                        W1 = ANGST(Z, NBIN, NAOUT, AOUT, MXABF)
                        Z  = REAL(M+0.5)
                        W2 = ANGST(Z, NBIN, NAOUT, AOUT, MXABF)
                        P1 = REAL(PIXL(W1, NNEW, 
     &                       NARC(SLOT), AIN, MXARC))
                        P2 = REAL(PIXL(W2, NNEW, 
     &                       NARC(SLOT), AIN, MXARC))
                        IF(P1.GT.P2) THEN
                           P  = P1
                           P1 = P2
                           P2 = P
                        END IF
                        TOTAL = P2-P1
                        IF(P2.LT.0.5 .OR. 
     &                       P1.GT.REAL(NNEW)+0.5) THEN
C     
C     Completely outside good spectrum range
C     
                           BAD = P2 - P1
                        ELSE
                           BAD = 0.
C     
C     Pixels over the end
C     
                           IF(P1.LT.0.5) BAD = BAD+0.5-P1
                           IF(P2.GT.REAL(NNEW)+0.5) 
     &                          BAD = BAD+P2-REAL(NNEW)-0.5
                           P1 = MAX(0.5, P1)
                           P2 = MIN(REAL(NNEW)+0.5,P2)
                           K1 = MAX(1,NINT(P1))
                           K2 = MIN(NNEW,NINT(P2))
                           IF(K1.EQ.K2 .AND. 
     &                          ERRORS(I1+K1-1,SLOT).LE.0.) THEN
C     
C     Boundaries wholly inside old pixel
C     
                              BAD = BAD + P2 - P1
                           ELSE
C     
C     end pixels
C     
                              IF(ERRORS(I1+K1-1,SLOT).LE.0.) 
     &                             BAD = BAD + REAL(K1)+0.5-P1
                              IF(ERRORS(I1+K2-1,SLOT).LE.0.) 
     &                             BAD = BAD + P2-REAL(K2)+0.5
C     
C     The rest
C     
                              DO K = K1+1, K2-1
                                 IF(ERRORS(I1+K-1,SLOT).LE.0.) 
     &                                BAD = BAD + 1.
                              END DO
                           END IF
                        END IF
                        IF(BAD.GT.FRAC*TOTAL) THEN
                           WORK3(M) = -1.
                           NBAD = NBAD + 1
                        END IF
                     END IF
                  END DO
               END IF
            END DO
C     
C     Now set output spectrum
C     
            DO J = 1, NBIN
               IF(J.GE.J1 .AND. J.LE.J2 .AND. WORK1(J).GT.0.) THEN
                  IF(WORK4(J).EQ.0.) THEN
                     COUNTS(J,OUT) = 0.
                     FLUX(J,OUT)   = WORK2(J)
                     ERRORS(J,OUT) = WORK3(J)*SQRT(WORK1(J))
                  ELSE
                     COUNTS(J,OUT) = WORK2(J)*WORK4(J)
                     FLUX(J,OUT)   = WORK4(J)
                     ERRORS(J,OUT) = WORK3(J)*SQRT(WORK1(J))
                  END IF
               ELSE
                  IF(WORK3(J) .GT. 0 .AND. WORK1(J).LE.0.) THEN
                     WRITE(*,*) '** Variance non-positive on pixel ',J
                     WRITE(*,*) 'possibly as a result of strange input'
                     WRITE(*,*) 'errors. Pixel will be masked'
                  END IF
                  COUNTS(J,OUT) =  0.
                  ERRORS(J,OUT) = -1.
                  FLUX(J,OUT)   =  1.
               END IF
            END DO
C     
C     Set headers equal to those of input spectrum 
C     
            CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &           MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
C     Set arc
C     
            NARC(OUT) = NAOUT
            DO J = 1, ABS(NAOUT)
               ARC(J,OUT) = AOUT(J)
            END DO
C     
C     Set Vearth = 0 or VTEMP
C     
            IF(SAMECI(RMETH,'T')) THEN
               CALL HSETD('Vearth', VTEMP, OUT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE
               CALL HSETD('Vearth', 0.D0, OUT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            END IF
            NPIX(OUT) = NBIN
            CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) STRING
            IF(NBAD.GT.0.) THEN
               WRITE(*,*) NBAD,' pixels were masked in slot ',OUT
               WRITE(*,*) ' '
            END IF
         END IF
      END DO
 999  RETURN
      END




