CAVERAGE
C AVERAGE N1 N2 N3 METHOD WEIGHTS -- Averages spectra together
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to average
C  N2    -- Slot number of last spectrum to average
C  N3    -- Slot in which to put results
C  METHOD - Averaging method. At present supports
C           U  -- Unit weights
C           D  -- Dwell weights
C           R  -- Response weights
C           V  -- Variance weights
C
C  WEIGHTS -- a file of weights that multiply whatever weights are generated
C             by method. <CR> to ignore. The weights should be for every
C             spectrum regardless of selection.
C
C Response weights are proportional to the local ratio of COUNTS/FLUX
C and thus effectively add the counts together (optimum for photon
C counting data). Variance weights use a single value equal to the
C mean Signal/noise**2 for each spectrum.
C
C Average is the command to use if you are combining spectra covering different
C wavelength ranges of the same object. If these overlap at all response 
C weights are designed to optimise the signal-to-noise on a pixel by pixel 
C basis. This is useful when as is typical in the overlap region one or other
C spectrum is better than the other and which is better changes with the
C exact wavelength.
C
C Selection is done. 
C
C The spectra must have equal numbers of pixels, but no other properties
C in common. A warning is given if the wavelength scales differ but
C averaging still goes ahead
C
C Related commands: PBIN, GROUP
C
CAVERAGE
      SUBROUTINE SPCAVE(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WORK2, WORK3, WORK4, MXWORK, SLOTS, 
     &     WSLOTS, MXSLOTS, MUTE, IFAIL)
C     
C     Averages spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.
C     >  R     WORK1(MXWORK) Work arrays
C     >  R     WORK2(MXWORK)
C     >  R     WORK3(MXWORK)
C     >  R     WORK4(MXWORK)
C     >  I     MXWORK        Size of work arrays
C     >  I     SLOTS(MXSLOTS)   Array for list of slot numbers
C     >  R     WSLOTS(MXSLOTS)  Array for list of weights 
C     >  I     MXSLOTS         Size of list arrays 
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      REAL WSLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J, LENSTR, NVAL
      REAL GET_FLX, GET_ERF, CFRAT, W, VAR, WINIT
      DOUBLE PRECISION  SUM1, SUM2
      CHARACTER*64 FILENAME
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3
      INTEGER  IFAIL, NSAME, NASAM, NW
      INTEGER  MAXSPEC,  ncom
      INTEGER    IV
      REAL   WONE
      LOGICAL SELECT
      LOGICAL DEFAULT, WARN,  MUTE
      CHARACTER*1 METHOD
C     
C     Functions
C     
C     
      DATA SLOT1, SLOT2, SLOT3/1,2,3/
      DATA METHOD/'U'/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
C     
      CALL INTR_IN('First spectrum to average', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to average', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to average'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
C     
      CALL INTR_IN('Slot for average spectrum', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
C     
      CALL CHAR_IN('What method of averaging (U,D,R,V)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, METHOD, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL UPPER_CASE(METHOD)
      IF(METHOD.NE.'U' .AND. METHOD.NE.'D' .AND. METHOD.NE.'R'
     &     .AND. METHOD.NE.'V') THEN
         WRITE(*,*) 'Invalid averaging method'
         WRITE(*,*) 'Possibilities are:'
         WRITE(*,*) 'U -- Unit weights.'
         WRITE(*,*) 'D -- Dwell weights.'
         WRITE(*,*) 'R -- Response weights.'
         WRITE(*,*) 'V -- Variance weights.'
         METHOD = 'U'
         GOTO 999
      END IF
      FILENAME = ' '
      CALL CHAR_IN('File of weights', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILENAME, IFAIL)
      IF(FILENAME.NE.' ') THEN
         OPEN(UNIT=47,FILE=FILENAME,STATUS='OLD',IOSTAT=IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to open ',FILENAME
            GOTO 999
         END IF
      END IF
C     
C     Initialise work arrays and then average spectra
C     Check that spectra are compatible. Only requirements are that they
C     have same number of pixels which must be less than MXWORK. Zero pixel
C     spectra are skipped. A warning is given if the arc coefficients vary.
C     For dwell weights, the dwell must be present.
C     
      DO I = 1, MIN(MXWORK, MAXPX)
         WORK1(I) = 0.
         WORK2(I) = 0.
         WORK3(I) = 0.
         WORK4(I) = 0.
      END DO
      NSAME = 0
      NASAM = 0
      NVAL  = 0
      WARN = .FALSE.
      WONE = -1.
      DO I = 1, NSLOTS
         SLOT = SLOTS(I) 
         WSLOTS(I) = - 1.
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NPIX(SLOT).GT.MXWORK) THEN
            WRITE(*,*) 'Too many pixels for work array'
            WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT),' pixels.'
            GOTO 999
         ELSE
C     
C     Read weights prior to selection since they then do not
C     have to be changed every time the selection is changed
C     
            IF(FILENAME.NE.' ') THEN
               READ(47,*,IOSTAT=IFAIL) WINIT
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Error reading weight from ',FILENAME
                  CLOSE(UNIT=47)
                  GOTO 999
               END IF
            ELSE
               WINIT = 1.
            END IF
C     
            IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &           HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &           MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &           VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &           NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
               WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
            ELSE
               IF(NSAME.EQ.0) THEN
                  NSAME = NPIX(SLOT)
                  NASAM = NARC(SLOT)
                  IV    = SLOT
                  NVAL = NVAL + 1
               ELSE IF(NSAME.NE.NPIX(SLOT)) THEN
                  WRITE(*,*) 'Incompatible numbers of pixels'
                  WRITE(*,*) 'First valid spectrum has ',NSAME
                  WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT)
                  GOTO 999
               ELSE IF(NARC(SLOT).NE.NASAM) THEN
                  WARN = .TRUE.
                  NVAL = NVAL + 1
               ELSE
                  DO J = 1, ABS(NASAM)
                     WARN = WARN .OR. 
     &                    ABS(ARC(J,SLOT)-ARC(J,IV)).GT.
     &                    1.D-5*ABS(ARC(J,IV))
                  END DO
                  NVAL = NVAL + 1
               END IF
C     
               IF(METHOD.EQ.'U') THEN
                  W = WINIT
               ELSE IF(METHOD.EQ.'D') THEN
                  CALL HGETR('Dwell', W, SLOT, MXSPEC, NMREAL, 
     &                 HDREAL, NREAL, MXREAL, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) 'No dwell for slot ',SLOT
                     GOTO 999
                  END IF
                  W = WINIT*W
               ELSE IF(METHOD.EQ.'V') THEN
                  SUM1 = 0.D0
                  SUM2 = 0.D0
                  DO J = 1, NSAME
                     IF(ERRORS(J,SLOT).GT.0.) THEN
                        SUM1 = SUM1 + GET_FLX(COUNTS(J,SLOT), 
     &                       FLUX(J,SLOT))
                        SUM2 = SUM2 + GET_ERF(COUNTS(J,SLOT), 
     &                       ERRORS(J,SLOT), FLUX(J,SLOT))**2
                     END IF
                  END DO
                  W = REAL(WINIT*SUM1/SUM2)
               END IF
               SUM1 = 0.
               NW = 0
               DO J = 1, NSAME
                  IF(ERRORS(J,SLOT).GT.0.) THEN
                     IF(METHOD.EQ.'R') THEN
                        W = WINIT*CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                     END IF
                     SUM1 = SUM1 + W
                     NW = NW + 1
                     WORK1(J) = WORK1(J) + W
                     WORK2(J) = WORK2(J) + W*GET_FLX(COUNTS(J,SLOT), 
     &                    FLUX(J,SLOT))
                     VAR = (W*GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT), 
     &                    FLUX(J,SLOT)))**2
                     WORK3(J) = WORK3(J) + VAR
                     WORK4(J) = WORK4(J) + W/CFRAT(COUNTS(J,SLOT), 
     &                    FLUX(J,SLOT))
                  END IF
               END DO
               IF(NW.GT.0) THEN
                  IF(WONE.LT.0. .AND. SUM1.GT.0.) 
     &                 WONE = REAL(SUM1/FLOAT(NW))
                  WSLOTS(I) = REAL(SUM1/FLOAT(NW)/WONE)
                  IF(.NOT.MUTE) THEN
                     WRITE(*,*) 'Added in slot ',SLOT,
     &                    ', mean weight ',WSLOTS(I)
                  ELSE IF(MOD(NVAL,50).EQ.0) THEN
                     WRITE(*,*) 'Added in ',NVAL,' spectra.'
                  END IF
               ELSE 
                  WRITE(*,*) 'Slot ',SLOT,' had no valid points.'
               END IF
            END IF
         END IF
      END DO
      IF(NVAL.LT.1) THEN
         WRITE(*,*) 'Too few valid spectra to average'
         GOTO 999
      ELSE
         WRITE(*,*) 'Number of spectra averaged = ',NVAL
      END IF
      IF(WARN) THEN
         WRITE(*,*) 'WARNING: Arc scales of spectra are not'
         WRITE(*,*) 'the same. Averaging will go ahead though'
      END IF
C     
C     Store result in output slot
C     
      DO I = 1, NSAME
         IF(WORK3(I).GT.0.) THEN
            COUNTS(I,SLOT3) = WORK2(I)/WORK4(I)
            ERRORS(I,SLOT3) = SQRT(WORK3(I))/WORK4(I)
            IF(COUNTS(I,SLOT3).EQ.0.) THEN
               FLUX(I,SLOT3) = WORK1(I)/WORK4(I)
            ELSE
               FLUX(I,SLOT3) = WORK2(I)/WORK1(I)
            END IF
         ELSE
            ERRORS(I,SLOT3) = -1.
            COUNTS(I,SLOT3) =  0.
            FLUX(I,SLOT3)   =  1.
         END IF
      END DO
C     
C     Average headers
C     
      CALL HEDAVE(SLOT3, SLOTS, WSLOTS, NSLOTS, MXSPEC, NPIX, ARC, 
     &     NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &     HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &     MXINTR, MXREAL, IFAIL)
      CALL SL_INF(SLOT3, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &     NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, 
     &     NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, IFAIL)
      WRITE(*,*) 'Result stored in:'
      WRITE(*,*) STRING(:LENSTR(STRING))
C     
 999  CLOSE(UNIT=47)
      RETURN
      END
