      DOUBLE PRECISION LONG, LAT, HEIGHT
      DOUBLE PRECISION R1950, D1950, R2000, D2000
      DOUBLE PRECISION MJD, SECS, DAYS
      INTEGER DAY, MONTH, YEAR
      INTEGER HOURS, MINS
      CHARACTER*10 RA, DEC
      INTEGER NSTRT
      DOUBLE PRECISION DTT, SLA_DTT, SLA_AIRMAS
      DOUBLE PRECISION RAA, DECA, P, AM
      DOUBLE PRECISION AZ, ZD, HA, RAO, DECO
      DATA RA, DEC/'17 58 11.4','+08 10 16'/
      DATA DAY, MONTH, YEAR/24, 4, 1994/
      DATA HOURS, MINS, SECS/04, 32, 28.528'
*
      NSTRT = 1
      CALL SLA_DAFIN(RA,NSTRT,R1950,IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL SLA_DAFIN(DEC,NSTRT,D1950,IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL SLA_FK45Z(R1950,D1950,1994.D0,R2000,D2000)
      CALL SLA_CLDJ(YEAR, MONTH, DAY, MJD, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL SLA_DTF2D(HOURS, MINS, SECS, DAYS, IFAIL) 
      IF(IFAIL.NE.0) GOTO 999
      MJD = MJD + DAYS
      DTT = SLA_DTT(MJD)
      MJD = MJD + DTT
*
* In theory MJD should be TDB but the difference between TT
* is negligible in this case
*                             
      CALL SLA_MAP(R2000,D2000,0.D0,0.D0,0.D0,0.D0,2000.D0,MJD,
     &RAA,DECA)
      CALL SLA_OBS(0, 'LPO2.5', LONG, LAT, HEIGHT)
      LONG = -LONG
*
* Various approximations are made here which should be ok for most
* ordinary work these are:
* (1) Delta UT is input here as 0 although in reality it ranges 
*     from -0.9 to +0.9s. 
* (2) Polar motion set to zero (can be as much as 0.3")
* (3) Local ambient temp set to 10C, 283K
* (4) Pressure derived from the height rather than input independently
* (5) Relative humidity set = 0.1 (=10%)
* (6) Observing wavelength = 0.55 micron
* (7) tropospheric lapse rate = 0.0065D0 K/metre
*
      MJD = MJD - DTT
      P = 1013.25D0*EXP(-HEIGHT/8149.9415D0)
      CALL SLA_AOP(RAA, DECA, MJD, 0.D0, LONG, LAT, HEIGHT,
     &0.D0, 0.D0, 283.D0, P, 0.1D0, 0.55D0, 0.0065D0,
     &AZ, ZD, HA, DECO, RAO)
      AM  = SLA_AIRMAS(ZD)
     
