      SUBROUTINE SITEQ(TELESCOPE, SITE, GDLAT, GCLONG, ELEV)
C
C  Returns the name and coordinates of telescope/observing site. Allows
C  user to add to list of sites.
C
C  Inputs:
C
C      TELESCOPE  = 'LIST' to list and prompt for new observatory,
C      otherwise checks that site entered is valid.
C
C  Revised 22 Jan 84 by KDH.
C  Revised July 84 by KDH
C  Revised May 94 by TRM
C  Revised Oct 96 by TRM
C  Revised Sept 05 by AD
C  Added Gemini-South, Aug 08, PFLM
C  Added Gemini-North  Aug 09, PFLM
C
      IMPLICIT NONE
      CHARACTER*(*) SITE, TELESCOPE
      DOUBLE PRECISION GDLAT,GCLONG,ELEV
      LOGICAL SAMECI
C
C Observatory positions are from the USNO astronomical almanac 1981-84
C
      INTEGER MXTEL, NFIX
      PARAMETER (NFIX=19)
      PARAMETER (MXTEL=20)
      CHARACTER*32 SNAME(MXTEL)
      CHARACTER*32 TNAME(MXTEL)
      INTEGER LON(3,MXTEL)
      INTEGER LAT(3,MXTEL)
      INTEGER METRES(MXTEL)
      INTEGER LOND, LONM, LONS, LATS
      INTEGER LATD, LATM, I, J, ISITE, NSITE
C
      DATA (SNAME(I),I=1,NFIX)/
     &         'Palomar',
     &         'Wilson',
     &         'Campanas',
     &         'Lemmon',
     &         'La Palma',
     &         'La Palma',
     &         'La Palma',
     &         'Mauna Kea',
     &         'Kitt Peak',
     &         'Siding Springs',
     &         'CTIO',
     &         'McDonald',
     &         'MMT',
     &         'Cerro Paranal',
     &         'Siding Springs',
     &         'Sutherland',
     &         'Cerro Pachon',
     &         'Mauna Kea',   
     &         'APO'   
     &             /

      DATA (TNAME(I),I=1,NFIX)/
     &         'Palomar 200in',
     &         'Wilson',
     &         'Campanas',
     &         'Lemmon',
     &         'WHT',
     &         'INT',
     &         'JKT',
     &         'UKIRT',
     &         'Kitt Peak',
     &         'AAT',
     &         'CTIO',
     &         'McDonald',
     &         'MMT',
     &         'VLT',
     &         'ANU 2.3m',
     &         'SAAO 1.9m',
     &         'Gemini South',
     &         'Gemini North',
     &         'SDSS 2.5m'
     &             /

      DATA ((LON(I,J),I=1,3),J=1,NFIX)/ 
     &         116, 51, 50,      ! WILSON
     &         118, 03, 35,      ! PALOMAR
     &          70, 42, 09,      ! CAMPANAS
     &         110, 47, 17,      ! LEMMON
     &          17, 52, 40,      ! LA PALMA
     &          17, 52, 40,      ! LA PALMA
     &          17, 52, 40,      ! LA PALMA
     &         155, 28, 18,      ! MAUNA KEA
     &         111, 35, 58,      ! KITT PEAK
     &        -149, 03, 58,      ! AAT
     &          70, 48, 54,      ! CTIO
     &         104, 01, 20,      ! MCDONALD
     &         110, 53, 06,      ! MMT
     &          70, 24, 11,      ! VLT
     &        -149, 03, 40,      ! ANU
     &         -20, 48, 42,      ! SAAO
     &          70, 44, 12,      ! Gemini South
     &         155, 28, 08,      ! Gemini North
     &         105, 49, 13       ! SDSS 2.5m
     &                     /

      DATA ((LAT(I,J),I=1,3),J=1,NFIX)/  
     &          33, 21, 22,      ! WILSON
     &          34, 12, 59,      ! PALOMAR
     &         -29, 00, 11,      ! CAMPANAS
     &          32, 26, 34,      ! LEMMON
     &          28, 45, 43,      ! LA PALMA
     &          28, 45, 43,      ! LA PALMA
     &          28, 45, 43,      ! LA PALMA
     &          19, 49, 35,      ! MAUNA KEA
     &          31, 57, 50,      ! KITT PEAK
     &         -31, 16, 37,      ! AAT
     &         -30, 09, 58,      ! CTIO
     &         +30, 40, 18,      ! MCDONALD
     &         +31, 41, 18,      ! MMT
     &         -24, 37, 31,      ! VLT
     &         -31, 07, 38,      ! ANU
     &         -32, 22, 42,      ! SAAO 
     &         -30, 14, 27,      ! Gemini South
     &         +19, 49, 26,      ! Gemini North
     &         +32, 46, 49       ! SDSS 2.5m
     &                     /

      DATA (METRES(I),I=1,NFIX)/ 
     &            1706,      ! WILSON
     &            1742,      ! PALOMAR
     &            2280,      ! CAMPANAS
     &            2790,      ! LEMMON
     &            2336,      ! LA PALMA
     &            2336,      ! LA PALMA
     &            2336,      ! LA PALMA
     &            4200,      ! MAUNA KEA
     &            2120,      ! KITT PEAK
     &            1164,      ! AAT
     &            2235,      ! CTIO
     &            2069,      ! MCDONALD
     &            2608,      ! MMT
     &            2635,      ! VLT
     &            1149,      ! ANU
     &            1771,      ! SAAO
     &            2722,      ! Gemini South
     &            4213,      ! Gemini North
     &            2788       ! SDSS 2.5m
     &                      /

      DATA NSITE/NFIX/
      SAVE NSITE
C
      IF(SAMECI(TELESCOPE,'LIST')) THEN
C
C  Ask user to pick an observing site
C
1       WRITE(*,*) 'Please identify the telescope'
        WRITE(*,'(10X,A)') (TNAME(I), I=1,NSITE)
        WRITE(*,'(7X,A)') 'or ''elsewhere'''
        WRITE(*,'(A,$)') 'telescope> '
        READ(*,'(A)') TELESCOPE
C
C  Check site name against those of observatories
C
        DO ISITE=1,NSITE
          IF(SAMECI(TELESCOPE, TNAME(ISITE))) GOTO 100
        END DO
C
        IF(.NOT. SAMECI(TELESCOPE, 'ELSEWHERE' )) GOTO 1
C
C  Enter position data for another site
C
        WRITE(*,*) 'What is the name of the telescope ?'
        READ (*,'(A)') TNAME(NSITE+1)
        WRITE(*,*) 'What is the name of the observing site ?'
        READ (*,'(A)') SNAME(NSITE+1)
C
        WRITE(*,*) 'What is its geocentric longitude (D,M,S) (W=+,E=-)?'
        READ(*,*,ERR=50) LOND, LONM, LONS
        IF(LOND.GT.180 .OR. LOND.LE.-180) THEN
50        WRITE(*,*) 'Invalid input, try again.'
          GOTO 1
        END IF
        IF(LONM.GE.60.OR.LONM.LT.0) GOTO 50
        IF(LONS.GE.60.OR.LONS.LT.0) GOTO 50
C
        WRITE(*,*) 'What is its geodetic latitude (D,M,S) ?'
        READ(*,*,ERR=50) LATD, LATM, LATS
        IF(LATD.GT.90.OR.LATD.LT.-90) GOTO 50
        IF(LATM.GE.60.OR.LATM.LT.0) GOTO 50
        IF(LATS.GE.60.OR.LATS.LT.0) GOTO 50
C
        WRITE(*,*) 'What is its elevation above sea level (meters) ?'
        READ(*,*,ERR=50) METRES(NSITE+1)
        NSITE = NSITE + 1
        LAT(1,NSITE) = LATD
        LAT(2,NSITE) = LATM
        LAT(3,NSITE) = LATS
        LON(1,NSITE) = LOND
        LON(2,NSITE) = LONM
        LON(3,NSITE) = LONS
        ISITE = NSITE
      ELSE
C
C Check that site name is valid
C
        DO ISITE=1,NSITE
          IF(SAMECI(TELESCOPE, TNAME(ISITE))) GOTO 100
        END DO
        GOTO 1
      END IF
C
C  Load results
C
100   CONTINUE
      SITE      = SNAME(ISITE)
      TELESCOPE = TNAME(ISITE)
      ELEV      = METRES(ISITE)
      LATD      = LAT(1, ISITE)
      LATM      = LAT(2, ISITE)
      LATS      = LAT(3, ISITE)
      LOND      = LON(1, ISITE)
      LONM      = LON(2, ISITE)
      LONS      = LON(3, ISITE)
      GCLONG = ABS(LOND) + ABS(LONM)/60.D0 + ABS(LONS)/3600.D0
      GDLAT  = ABS(LATD) + ABS(LATM)/60.D0 + ABS(LATS)/3600.D0
      IF(LOND.LT.0 .OR. LONM.LT.0 .OR. LONS.LT.0) GCLONG=-GCLONG
      IF(LATD.LT.0 .OR. LATM.LT.0 .OR. LATS.LT.0) GDLAT=-GDLAT
C
C  Report results on terminal
C
      WRITE(*,'(2A)') '  Telescope:', TELESCOPE
      WRITE(*,'(2A)') '       Site:', SITE
      WRITE(*,'(A,I4,I3,I3,F15.5)')
     &  '  Longitude:', LOND, LONM, LONS, GCLONG
      WRITE(*,'(A,I4,I3,I3,F15.5)')
     &  '   Latitude:', LATD, LATM, LATS, GDLAT
      WRITE(*,'(A,10X,F15.5)')
     &  '  Elevation:',                   ELEV
C
      RETURN
      END
