CSADD
C SADD N1 N2 N3 HJD0 PERIOD METHOD AC AS -- Adds or multiplies a set of 
C                spectra by a sinusoid of fixed period at every wavelength.
C                Useful for computing window function with SDEC
C
C NB. This routine has to access the arrays in the wrong direction and may
C     therefore page fault alot.
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to process
C  N2    -- Slot number of last spectrum to process
C  N3    -- Slot of first output spectrum
C  HJD0  -- HJD0 of sinusoid 
C  PERIOD - Period of sinusoid
C  METHOD - 'A' -- Add to data according to D = D + sinusoid
C           'M' -- Multiply data.           D = D*(1.+sinusoid)
C           'R' -- Replace data.            D = sinusoid
C  AC   -- Amplitude of cosine component
C  AS   -- Amplitude of sine component.
C          Sinuosoid computed as AC*COS(2*PI*PHI)+AS*SIN(2*PI*PHI)
C          where PHI = (HJD-HJD0)/PERIOD
CSADD
      SUBROUTINE SINADD(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WHICH, MXWORK, SLOTS, MXSLOTS, 
     &     IFAIL)
C     
C     Fits sinuisoidal waves to time series spectra.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  R     WORK1  Work array
C     >  I     WHICH      "
C     >  I     MXWORK     Size of work array
C     I     SLOTS(MXSLOTS) -- Work array for list of slots
C     I     MXSLOTS
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK)
      INTEGER WHICH(MXWORK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT, SLT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J, NV, NSAME, LENSTR
      REAL   CFRAT, RATIO
      DOUBLE PRECISION TWOPI, HJD0, PERIOD, SUB, HJD, PHASE
      CHARACTER*5 METHOD
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3
      INTEGER IFAIL, MAXSPEC, NCOM
      REAL FLX, AC, AS
      LOGICAL SELECT, DEFAULT
C     
C     Functions
C     
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA HJD0, PERIOD/2440000., 0.01/
      DATA AC, AS/1., 1./
      DATA METHOD/'A'/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
C     First slot
C     
      CALL INTR_IN('First spectrum to process', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
C     Second slot
C     
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Lasst spectrum to process', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to process'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
C     Check through for valid spectra. Store values for ease
C     of reference later
C     
      NSAME = 0
      NV    = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).GT.0 .AND. NPIX(SLOT).LE.MXWORK .AND.
     &        SELECT(SLOT,NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &        HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &        MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &        VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &        VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &        MXSDOUB, MXSINTR, MXSREAL)) THEN
            IF(NSAME.EQ.0) THEN
               NSAME = NPIX(SLOT)
               NV = 1
               WHICH(NV) = SLOT
            ELSE IF(NPIX(SLOT).NE.NSAME) THEN
               WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT),' pixels'
               WRITE(*,*) 'rather than ',NSAME,' as the first valid'
               WRITE(*,*) 'spectrum. Choose again.'
               GOTO 999
            ELSE
               NV = NV + 1
               WHICH(NV) = SLOT
            END IF
         END IF
      END DO
C     
C     First slot for output
C     
      CALL INTR_IN('First slot for results', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NV+1, IFAIL)
C     
C     HJD0
C     
      CALL DOUB_IN('HJD of zero phase', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, HJD0, 0.D0, 1.D10, IFAIL)
C     
C     Period
C     
      CALL DOUB_IN('Period of sinusoid (days)', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, PERIOD, 1.D-7, 1.D5, IFAIL)
C     
      CALL CHAR_IN('Add, Multiply or Replace?', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, METHOD, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL UPPER_CASE(METHOD)
      IF(METHOD.NE.'A' .AND. METHOD.NE.'M' .AND. METHOD.NE.'R') THEN
         WRITE(*,*) 'Invalid answer. Possibilities are:'
         WRITE(*,*) ' A -- Add sinusoid to data.      D = D + sinusoid'
         WRITE(*,*) ' M -- Multiply data by sinusoid. D = D*(1+sinuoid)'
         WRITE(*,*) ' R -- Replace data by sinusoid.  D = sinusoid'
         METHOD = 'A'
         GOTO 999
      END IF
C     
      CALL REAL_IN('Enter amplitude of cosine', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, AC, -1.E30, 1.E30, IFAIL)
      CALL REAL_IN('Enter amplitude of sine', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, AS, -1.E30, 1.E30, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
C**************************************************************************
C     
C     Compute component
C     
      TWOPI = 8.D0*ATAN(1.D0)
      DO I = 1, NV
         SLOT = WHICH(I)
         CALL HGETD('HJD', HJD, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &        NDOUB, MXDOUB, IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to find HJD in slot ',SLOT
            GOTO 999
         END IF
         PHASE = (HJD-HJD0)/PERIOD
         IF(I.EQ.1) SUB  = DBLE(INT(PHASE))
         PHASE = TWOPI*(PHASE-SUB)
         WORK1(I) = REAL(AC*COS(PHASE)+AS*SIN(PHASE))
      END DO
C     
C     Loop through spectra
C     
      DO I = 1, NV
         SLOT = SLOT3+I-1
         SLT  = WHICH(I)
         CALL SET_HEAD(SLOT, SLT, MXSPEC, NPIX, ARC, NARC, 
     &        MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &        HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &        MXDOUB, MXINTR, MXREAL, IFAIL)
         DO J = 1, NSAME
            ERRORS(J,SLOT) = ERRORS(J,SLT)
            RATIO = CFRAT(COUNTS(J,SLT),FLUX(J,SLT))
            FLX = FLUX(J,WHICH(I))
            IF(METHOD.EQ.'A') THEN
               FLX = FLX + WORK1(I)
            ELSE IF(METHOD.EQ.'M') THEN
               FLX = FLX*(1.+WORK1(I))
            ELSE IF(METHOD.EQ.'R') THEN
               FLX = WORK1(I)
            END IF
            COUNTS(J,SLOT) = RATIO*FLX
            IF(COUNTS(J,SLOT).EQ.0.) THEN
               FLUX(J,SLOT) = RATIO
            ELSE
               FLUX(J,SLOT) = FLX
            END IF
         END DO
         CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &        IFAIL)
         WRITE(*,*) STRING(:LENSTR(STRING))
      END DO
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END
