*XYR
* XYR X1 X2 Y1 Y2  -- Sets fixed ranges for plots
*
* Parameters:
*
*       X1, X2 -- Range in X
*       Y1, Y2 -- Range in Y
*
* If ranges are set to null ranges (e.g. 0,0) then the appropriate routines 
* will determine suitable ranges automatically. Otherwise the ranges set
* by this routine take priority. Be careful when switching between
* different types of plot because the ranges set by this routine may then be
* inappropriate.
*XYR
      SUBROUTINE SET_XYR(SPLIT, NSPLIT, MXSPLIT, X1, X2, Y1, Y2)
*
* Set X, Y plot ranges for either spectra or light curve plots.
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
      REAL X1, X2, Y1, Y2
      LOGICAL DEFAULT
C
      DEFAULT = .FALSE.
      NCOM    = 0
      IFAIL   = 0
      CALL REAL_IN('Lower X limit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, X1, -1.E34, 1.E34, IFAIL)
      CALL REAL_IN('Upper X limit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, X2, -1.E34, 1.E34, IFAIL)
      CALL REAL_IN('Lower Y limit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, Y1, -1.E34, 1.E34, IFAIL)
      CALL REAL_IN('Upper Y limit', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, Y2, -1.E34, 1.E34, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IFAIL = 0
      RETURN
999   WRITE(*,*) 'Error translating command'
      RETURN
      END
