*SELECT 
* SELECT Type Name [Range] [Map] -- Sets selection criteria which apply to 
*                                   some routines
*
* SELECT allows you to define criteria that must be passed by a spectrum 
* before it is considered by some routines. For instance, when using LOAD, 
* you can select only spectra from a given night, or within a particular 
* phase range, or with a specific object name. Similarly with WRITE. This 
* makes handling very large numbers of spectra much easier (e.g. when there 
* are too many to actually fit comfortably in the slots available in MOLLY).
* SELECT can either be used interactively by just typing SELECT (useful if
* one is entering many criteria) or in command line mode with the following
* parameters:
*
*     Type -- To set a new selection item you must first define its data
*             type: C,D,I,R for Character, Double Precision, Integer, Real
*             Alternatively the strings CLEAR, SHOW, FREEZE and THAW will
*             clear the selection criteria, show them, suspend and restart
*             them, returning directly to the main MOLLY command level.
*
*     If you are setting a new item then you also need:
*
*     Name -- Name of header item to select on (character string, enclose
*             in quotes if it has any spaces in it). This should match
*             exactly.
*
*     Range-- Allowable range (two values) for D,I,R, particular string for C
*
*     Map  -- D,R 'Y' or 'N' to treat as a phase i.e. map into range 0 to 1
*
* If entered on command line, the selection is added to whatever has gone
* before, the current criteria are displayed and you are returned to the main
* command level. All the same options are available interactively inside
* SELECT.
*
* ALL the criteria you set must be passed for a spectrum to be selected.
*
* Character items are matched fairly generously, for example, the string
* "SSC" would match "SSCYG", "SS Cyg" "ss cyg" and " s S c y g". Wildcard
* * is also allowed. It matches any number of letters. So "*cyg" will
* match "ss cyg" or "v1500 cyg". However when you use wildcards, trailing
* letters must match up too so "*cyg" will not match "p cygni". This could
* be matched with "*cyg*". 
* e.g. the following command would set selection criteria to find any object 
* with both a 1 and a 2 in its name:
*
* sel c object *1*; sel c object *2*
*
*SELECT
      SUBROUTINE SET_SEL(SPLIT, NSPLIT, MXSPLIT, NMSCHAR, VSCHAR, 
     &NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, 
     &NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL,
     &IFAIL)
*
* Master for setting selection criteria as used by various
* routines. For real and double precision parameters a negative
* range indicates that the qunatity is a phase-like variable.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)     -- Command parameters
* >  I     NSPLIT             -- Number of params
* >  I     MXSPLIT            -- Maximum number of params
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
* <  I     IFAIL              -- Error return
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSCHAR, MXSDOUB, MXSINTR, MXSREAL
      INTEGER NSCHAR, NSDOUB, NSINTR, NSREAL
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      INTEGER  IFAIL, NCOM 
      CHARACTER*20 COMMAND, STRING*80
      CHARACTER*10 DTYP, MAP
      CHARACTER*32 ITEM, CVAL
      DOUBLE PRECISION DSWAP, DLO, DHI
      REAL RSWAP, RLO, RHI
      INTEGER ILO, IHI, LENSTR
      LOGICAL SAMECI, ESAMECI, DEFAULT, ICE
      DATA DTYP, MAP /'C', 'Y'/
      DATA ITEM/'Object'/
      DATA CVAL/'Name'/
      DATA RLO, RHI/-1.E30,1.E30/
      DATA DLO, DHI/-1.D30,1.D30/
      DATA ILO, IHI/-1000000,1000000/
      DATA ICE/.FALSE./
*
* Allow for some command line option
*
      ICE = NSCHAR+NSDOUB+NSINTR+NSREAL.LT.0
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
*
      IF(NSPLIT.GE.1) THEN
        CALL CHAR_IN('Item type (C,D,I,R)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, DTYP, IFAIL)
        IF(ESAMECI(DTYP,'CLEAR')) THEN
          NSCHAR = 0
          NSDOUB = 0
          NSINTR = 0
          NSREAL = 0
          WRITE(*,*) 'Selection criteria cleared'
          RETURN
        ELSE IF(ESAMECI(DTYP,'SHOW')) THEN
          CALL SHOW_SEL(NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &    NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &    NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
          RETURN
        ELSE IF(ESAMECI(DTYP,'FREEZE')) THEN
          IF(ICE) THEN
            WRITE(*,*) 'Selection already FROZEN'
          ELSE
            NSCHAR = -ABS(NSCHAR)
            NSDOUB = -ABS(NSDOUB)
            NSINTR = -ABS(NSINTR)
            NSREAL = -ABS(NSREAL)
            WRITE(*,*) 'Selection criteria FROZEN'
          END IF
          RETURN
        ELSE IF(ESAMECI(DTYP,'THAW')) THEN
          IF(ICE) THEN
            NSCHAR = ABS(NSCHAR)
            NSDOUB = ABS(NSDOUB)
            NSINTR = ABS(NSINTR)
            NSREAL = ABS(NSREAL)
            WRITE(*,*) 'Selection criteria THAWED'
          ELSE
            WRITE(*,*) 'Selection already THAWED'
          END IF
          RETURN
        END IF
        IF(ICE) THEN
          WRITE(*,*) 'Cannot add items to FROZEN state'
          GOTO 999
        END IF
        IF(.NOT.ESAMECI(DTYP,'C') .AND. .NOT.ESAMECI(DTYP,'D')
     &  .AND. .NOT.ESAMECI(DTYP,'I') .AND. 
     &  .NOT.ESAMECI(DTYP,'R')) THEN
          WRITE(*,*) 'Invalid type. Types are'
          WRITE(*,*) ' C -- character'
          WRITE(*,*) ' D -- Double precision'
          WRITE(*,*) ' I -- Integer'
          WRITE(*,*) ' R -- Real'
          GOTO 999
        END IF
        CALL CHAR_IN('Item name', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, ITEM, IFAIL)
        IF(ESAMECI(DTYP,'C')) THEN
          NSCHAR = NSCHAR + 1
          NMSCHAR(NSCHAR) = ITEM
          CALL CHAR_IN('Selection value', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, CVAL, IFAIL)
          VSCHAR(NSCHAR) = CVAL
        ELSE IF(ESAMECI(DTYP,'D')) THEN
          NSDOUB = NSDOUB + 1
          NMSDOUB(NSDOUB) = ITEM
          CALL DOUB_IN('Lower selection limit', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, DLO, -1.D35, 1.D35, IFAIL)
          CALL DOUB_IN('Upper selection limit', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, DHI, DLO, 1.D35, IFAIL)
          VSDOUB(1,NSDOUB) = DLO
          VSDOUB(2,NSDOUB) = DHI
          CALL CHAR_IN('Map to 0 - 1?', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, MAP, IFAIL)
          IF(ESAMECI(MAP,'Y')) THEN
            DSWAP = VSDOUB(1,NSDOUB)
            VSDOUB(1,NSDOUB) = VSDOUB(2,NSDOUB)            
            VSDOUB(2,NSDOUB) = DSWAP
          ELSE IF(.NOT.ESAMECI(MAP,'N')) THEN
            WRITE(*,*) 'Must answer y or n for mapping'
            GOTO 999
          END IF
        ELSE IF(ESAMECI(DTYP,'I')) THEN
          NSINTR = NSINTR + 1
          NMSINTR(NSINTR) = ITEM
          CALL INTR_IN('Lower selection limit', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, ILO, -999999999, 999999999, IFAIL)
          CALL INTR_IN('Upper selection limit', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, IHI, ILO, 999999999, IFAIL)
          VSINTR(1,NSINTR) = ILO
          VSINTR(2,NSINTR) = IHI
        ELSE IF(ESAMECI(DTYP,'R')) THEN
          NSREAL = NSREAL + 1
          NMSREAL(NSREAL) = ITEM
          CALL REAL_IN('Lower selection limit', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, RLO, -1.E35, 1.E35, IFAIL)
          CALL REAL_IN('Upper selection limit', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, RHI, RLO, 1.E35, IFAIL)
          VSREAL(1,NSREAL) = RLO
          VSREAL(2,NSREAL) = RHI
          CALL CHAR_IN('Map to 0 - 1?', SPLIT, NSPLIT, 
     &    MXSPLIT, NCOM, DEFAULT, MAP, IFAIL)
          IF(ESAMECI(MAP,'Y')) THEN
            RSWAP = VSREAL(1,NSREAL)
            VSREAL(1,NSREAL) = VSREAL(2,NSREAL)            
            VSREAL(2,NSREAL) = RSWAP
          ELSE IF(.NOT.ESAMECI(MAP,'N')) THEN
            WRITE(*,*) 'Must answer y or n for mapping'
            GOTO 999
          END IF
        END IF                  
        CALL SHOW_SEL(NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &  NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &  NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
        RETURN
      END IF
      WRITE(*,*) 'Various routines can select spectra according to'
      WRITE(*,*) 'the values of header items present. The ones'
      WRITE(*,*) 'which apply are set by this routine.'
      CALL SHOW_SEL(NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
100   WRITE(*,*) ' '
      ICE = NSCHAR+NSDOUB+NSINTR+NSREAL.LT.0
      IF(.NOT.ICE) WRITE(*,*) 'set   -- Set selection item.'
      WRITE(*,*) 'clear -- Clear selection items.'
      WRITE(*,*) 'show  -- Show selection items.'
      IF(.NOT.ICE) 
     &WRITE(*,*) 'freeze - Suspend application of selection.'
      IF(ICE) WRITE(*,*) 'thaw  -- Restart application of selection.'
      WRITE(*,*) 'quit  -- Quit selection'
200   WRITE(*,*) ' '
      WRITE(*,'(A,$)') 'select> '
      READ(*,'(A)') COMMAND
*
      IF(.NOT.ICE .AND. SAMECI(COMMAND,'SET')) THEN
        WRITE(*,'(A,A,A,$)') 'Enter data type (C,D,I,R) [',DTYP,'] '
        READ(*,'(A)') COMMAND
        IF(COMMAND.NE.' ') DTYP = COMMAND
        IF(.NOT.ESAMECI(DTYP,'C') .AND. .NOT.ESAMECI(DTYP,'D') 
     &  .AND. .NOT.ESAMECI(DTYP,'I') .AND. 
     &  .NOT.ESAMECI(DTYP,'R')) THEN
          WRITE(*,*) 'Invalid type. Types are'
          WRITE(*,*) ' C -- character'
          WRITE(*,*) ' D -- Double precision'
          WRITE(*,*) ' I -- Integer'
          WRITE(*,*) ' R -- Real'
          GOTO 200
        END IF
        WRITE(*,'(3A,$)') 'Enter variable name [',
     &  ITEM(:LENSTR(ITEM)),'] '
        READ(*,'(A)') STRING
        IF(STRING.NE.' ') ITEM = STRING
        IF(ESAMECI(DTYP,'C')) THEN
          NSCHAR = NSCHAR + 1
          NMSCHAR(NSCHAR) = ITEM
          WRITE(*,'(3A,$)') 'Enter selection value [',
     &    CVAL(:LENSTR(CVAL)),'] '
          READ(*,'(A)') STRING
          IF(STRING.NE.' ') CVAL = STRING
          VSCHAR(NSCHAR) = CVAL
        ELSE IF(ESAMECI(DTYP,'D')) THEN
          NSDOUB = NSDOUB + 1
          NMSDOUB(NSDOUB) = ITEM
300       WRITE(*,'(A,G20.13,A,G20.13,A,$)') 
     &    'Enter selection range [',DLO,',',DHI,'] '
          READ(*,'(A)') STRING
          IF(STRING.NE.' ') READ(STRING,*,ERR=300) DLO, DHI
          VSDOUB(1,NSDOUB) = DLO
          VSDOUB(2,NSDOUB) = DHI
          IF(VSDOUB(1,NSDOUB).GE.VSDOUB(2,NSDOUB)) THEN
            WRITE(*,*) 'Range must be > 0'
            NSDOUB = NSDOUB - 1
            GOTO 200
          END IF
400       WRITE(*,'(A,A,A,$)') 'Map to 0 - 1? [',MAP,'] '
          READ(*,'(A)') COMMAND
          IF(COMMAND.NE.' ') MAP = COMMAND
          IF(ESAMECI(MAP,'Y')) THEN
            DSWAP = VSDOUB(1,NSDOUB)
            VSDOUB(1,NSDOUB) = VSDOUB(2,NSDOUB)            
            VSDOUB(2,NSDOUB) = DSWAP
          ELSE IF(.NOT.ESAMECI(MAP,'N')) THEN
            WRITE(*,*) 'Answer y or n'
            WRITE(*,*) '0 - 1 mapping is useful for selection'
            WRITE(*,*) 'of a particular phase.'
            GOTO 400
          END IF
        ELSE IF(ESAMECI(DTYP,'I')) THEN
          NSINTR = NSINTR + 1
          NMSINTR(NSINTR) = ITEM
500       WRITE(*,'(A,I9,A,I9,A,$)') 'Enter selection range [',
     &    ILO,',',IHI,'] '
          READ(*,'(A)') STRING
          IF(STRING.NE.' ') READ(STRING,*,ERR=500) ILO, IHI
          VSINTR(1,NSINTR) = ILO
          VSINTR(2,NSINTR) = IHI
          IF(VSINTR(1,NSINTR).GT.VSINTR(2,NSINTR)) THEN
            WRITE(*,*) 'Range must be > 0'
            NSINTR = NSINTR - 1
            GOTO 200
          END IF
        ELSE IF(ESAMECI(DTYP,'R')) THEN
          NSREAL = NSREAL + 1
          NMSREAL(NSREAL) = ITEM
600       WRITE(*,'(A,G14.7,A,G14.7,A,$)') 
     &    'Enter selection range [',RLO,',',RHI,'] '
          READ(*,'(A)') STRING
          IF(STRING.NE.' ') READ(STRING,*,ERR=600) RLO, RHI
          VSREAL(1,NSREAL) = RLO
          VSREAL(2,NSREAL) = RHI
          IF(VSREAL(1,NSREAL).GT.VSREAL(2,NSREAL)) THEN
            WRITE(*,*) 'Range must be > 0'
            NSREAL = NSREAL - 1
            GOTO 200
          END IF
700       WRITE(*,'(A,A,A,$)') 'Map to 0 - 1? [',MAP,'] '
          READ(*,'(A)') COMMAND
          IF(COMMAND.NE.' ') MAP = COMMAND
          IF(ESAMECI(MAP,'Y')) THEN
            RSWAP = VSREAL(1,NSREAL)
            VSREAL(1,NSREAL) = VSREAL(2,NSREAL)            
            VSREAL(2,NSREAL) = RSWAP
          ELSE IF(.NOT.ESAMECI(MAP,'N')) THEN
            WRITE(*,*) 'Answer y or n'
            WRITE(*,*) '0 - 1 mapping is useful for selection'
            WRITE(*,*) 'of a particular phase.'
            GOTO 700
          END IF
        END IF                  
      ELSE IF(SAMECI(COMMAND,'CLEAR')) THEN
*
* Clear selections
*
        NSCHAR = 0
        NSDOUB = 0
        NSINTR = 0
        NSREAL = 0
*
      ELSE IF(SAMECI(COMMAND,'SHOW')) THEN
*
* Show current selections
*
        CALL SHOW_SEL(NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &  NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &  NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
*
      ELSE IF(.NOT.ICE .AND. SAMECI(COMMAND,'FREEZE')) THEN
        NSCHAR = -ABS(NSCHAR)
        NSDOUB = -ABS(NSDOUB)
        NSINTR = -ABS(NSINTR)
        NSREAL = -ABS(NSREAL)
        WRITE(*,*) 'Selection criteria are still set but they'
        WRITE(*,*) 'will not be applied until THAWed'
      ELSE IF(SAMECI(COMMAND,'THAW')) THEN
        NSCHAR = ABS(NSCHAR)
        NSDOUB = ABS(NSDOUB)
        NSINTR = ABS(NSINTR)
        NSREAL = ABS(NSREAL)
        WRITE(*,*) 'Selection criteria have been recovered'
      ELSE IF(SAMECI(COMMAND,'QUIT')) THEN
        RETURN
      ELSE
        GOTO 100
      END IF
      GOTO 200
999   IFAIL = 1
      RETURN
      END

      SUBROUTINE SHOW_SEL(NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
*
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSCHAR, MXSDOUB, MXSINTR, MXSREAL
      INTEGER NSCHAR, NSDOUB, NSINTR, NSREAL
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Local variables
*
      INTEGER I
*
      IF(NSCHAR.EQ.0 .AND. NSDOUB.EQ.0 .AND. NSINTR.EQ.0
     &  .AND. NSREAL.EQ.0) THEN
        WRITE(*,*) 'No selection criteria set.'
      ELSE
        WRITE(*,*) ' '
        IF(NSCHAR+NSDOUB+NSINTR+NSREAL.LT.0) THEN
          WRITE(*,*) 'Selection currently OFF'
        ELSE
          WRITE(*,*) 'Selection currently ON'
        END IF
        WRITE(*,*) ' '
        WRITE(*,*) 'Type      Name         Value or range'
        WRITE(*,*) ' '
        DO I = 1, ABS(NSCHAR)
          WRITE(*,*) 'C  [',NMSCHAR(I),'], value: ',VSCHAR(I)
        END DO
        DO I = 1, ABS(NSDOUB)
          IF(VSDOUB(1,I) .LT. VSDOUB(2,I)) THEN
            WRITE(*,'(1X,A,A,A,G19.12,A,G19.12)') 
     &      'D  [',NMSDOUB(I),'], range: ',VSDOUB(1,I),
     &      ' to ',VSDOUB(2,I)
          ELSE
            WRITE(*,'(1X,A,A,A,G19.12,A,G19.12,A)')
     &      'D  [',NMSDOUB(I),'], range: ',VSDOUB(2,I),
     &      ' to ',VSDOUB(1,I),' map'
          END IF
        END DO
        DO I = 1, ABS(NSINTR)
          WRITE(*,'(1X,A,A,A,I9,A,I9)') 'I  [',NMSINTR(I),
     &    '], range: ',VSINTR(1,I),' to ',VSINTR(2,I)
        END DO
        DO I = 1, ABS(NSREAL)
          IF(VSREAL(1,I) .LT. VSREAL(2,I)) THEN
            WRITE(*,'(1X,A,A,A,G14.7,A,G14.7)') 
     &      'R  [',NMSREAL(I),'], range: ',VSREAL(1,I),
     &      ' to ',VSREAL(2,I)
          ELSE
            WRITE(*,'(1X,A,A,A,G14.7,A,G14.7,A)')
     &      'R  [',NMSREAL(I),', range: ',VSREAL(2,I),
     &      ' to ',VSREAL(1,I),' map'
          END IF
        END DO
      END IF
      RETURN
      END
