*DEVICE
* DEVICE Device -- Set plot device
*
* Parameter:
*
*         Device -- Name of a PGPLOT device. In general these names are dependent
*                   upon the version of PGPLOT in use. Enter '?' and then you
*                   will be given a list when it comes to time to plot.
*                   Examples are '/xs' for an x-server window, '/ps' for a
*                   landscape postscipt (called pgplot.ps) or 'plot.ps/ps'
*                   for a particular name.
*                 
*                   There are also two special options:
*
*                     'prompt'  -- means that you will be prompted for the 
*                                  device at every plot.
*
*                     'last'    -- retrieves the plot device set before the 
*                                  current one (useful for switching from hard 
*                                  and soft devices).
*
* DEVICE does not try to open the device in question, and thus you will
* only find out whether it is possible to do so when you plot. This
* prevents the creation of small plot files and the clearing of the
* screen until a plot is made. 
*
* In the latest version of PGPLOT it is possible to have more than one
* plot device open at once. Some routines use this to create independent
* plots where it would not be appropriate to overplot on the current device.
*
* Related commands: CLOSE, PCLOSE
*
*DEVICE                   
      SUBROUTINE SET_DEV(SPLIT, NSPLIT, MXSPLIT, DEVICE, IFAIL)
*     
* Sets plot device name
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT), DEVICE
      CHARACTER*100 PREDEV(2)
      INTEGER  NCOM, LENSTR
      LOGICAL DEFAULT, ESAMECI
      SAVE PREDEV
      DATA PREDEV/' ',' '/
*
      DEFAULT   = .FALSE.
      NCOM      = 0
      IFAIL     = 0
      PREDEV(2) = PREDEV(1)
      PREDEV(1) = DEVICE
      CALL CHAR_IN('Plot device', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, DEVICE, IFAIL)
      IF(ESAMECI(DEVICE,'PROMPT')) THEN
         WRITE(*,*) 'You will be prompted for the device name'
         WRITE(*,*) 'whenever you make a plot.'
      ELSE IF(ESAMECI(DEVICE,'LAST') .AND. PREDEV(2).EQ.' ') THEN
         WRITE(*,*) 'You have not yet changed the device.'
         WRITE(*,*) 'No change will be made.'
         DEVICE = PREDEV(1)
      ELSE IF(ESAMECI(DEVICE,'LAST')) THEN
         WRITE(*,*) 'Plot device set to ',
     &        PREDEV(2)(:LENSTR(PREDEV(2)))
         DEVICE = PREDEV(2)
      END IF
      RETURN
      END
      
