*CLOBBER 
* CLOBBER STATUS -- Sets CLOBBER flag which determines whether files
*                   are overwritten on output or not.
*
* Parameters:  
*
* STATUS -- If not supplied by user, the status of CLOBBER is just switched
*           Otherwise put STATUS = 'ON' or 'OFF' to force the required state.
*
*CLOBBER
      SUBROUTINE SET_CLOBBER(SPLIT, NSPLIT, MXSPLIT, CLOBBER, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL SAMECI, CLOBBER, STATUS
*
      IFAIL = 0
      IF(NSPLIT.GE.1) THEN
        STATUS = SAMECI(SPLIT(1),'ON')
        IF(.NOT.STATUS .AND. .NOT.SAMECI(SPLIT(1),'OFF')) THEN
          WRITE(*,*) 'Forced status must either be ON or OFF'
          GOTO 999
        END IF
      END IF
      IF(NSPLIT.GE.1) THEN
        CLOBBER = STATUS
      ELSE
        CLOBBER = .NOT.CLOBBER
      END IF
      IF(CLOBBER) THEN
        WRITE(*,*) 'Files will be written even if a file of'//
     &  ' the same name exists.'
      ELSE
        WRITE(*,*) 'Files will not be written if a file of'//
     &  ' the same name exists.'
      END IF                          
      RETURN
999   IFAIL = 1
      RETURN
      END
