      LOGICAL FUNCTION SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, 
     &     NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &     NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC,
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &     NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, 
     &     MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)
*     
*     Checks to see whether header items match up with defined items
*     Will be false if no matching item can be found or if an item
*     is found but is outside the prescribed limits. A negative range
*     for either real or double precision qunatities is interpreted
*     as meaning that it is a phase-like quantity that has to be
*     mapped to 0 - 1
*
* >  I*4   SLOT                  -- Slot number to test
* >  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* >  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* >  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* >  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* >  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* >  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* >  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* >  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* >  I     NCHAR(MXSPEC)         -- Number of character header items.
* >  I     NDOUB(MXSPEC)         -- Number of double precision header items.
* >  I     NINTR(MXSPEC)         -- Number of integer items.
* >  I     NREAL(MXSPEC)         -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  I     MXSPEC    -- Maximum number of spectra
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*
*
* SELECT = .TRUE. if spectrum matches constraints.
* Numbers of header items
*
      IMPLICIT NONE
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC
      INTEGER MXSCHAR, MXSDOUB, MXSINTR, MXSREAL, SLOT
*
* Numbers of items
*
      INTEGER NCHAR(MXSPEC), NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC), NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*) HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER HDINTR(MXINTR,MXSPEC)
      REAL HDREAL(MXREAL,MXSPEC)
*
      INTEGER NSCHAR, NSDOUB, NSINTR, NSREAL
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
      INTEGER I, IFAIL
      DOUBLE PRECISION DX1, DX2, DX
      LOGICAL WSAMECI
      REAL X1, X2, X
      CHARACTER*32 CVAL
      DOUBLE PRECISION DVAL
      REAL RVAL
      INTEGER IVAL
*
* Check for frozen action
*
      IF(NSCHAR+NSDOUB+NSINTR+NSREAL.LE.0) THEN
        SELECT = .TRUE.
        RETURN
      END IF
      SELECT = .FALSE.
*
* Character parameters. The character item must be found, and
* if found its letters must match, except for case. A select
* value Obj will match object and OBJECT, but not obgect, etc. It
* will also match o b ject as blanks are ignored. 
*
      DO I = 1, NSCHAR
         CALL HGETC(NMSCHAR(I), CVAL, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &        NCHAR, MXCHAR, IFAIL)
         IF(IFAIL.EQ.0) THEN
            IF(.NOT.WSAMECI(VSCHAR(I),CVAL)) RETURN
         ELSE
            RETURN
         END IF
      END DO
*
* Double precision parameters
*
      DO I = 1, NSDOUB
         CALL HGETD(NMSDOUB(I), DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &        NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.EQ.0) THEN
           IF(VSDOUB(1,I).LT.VSDOUB(2,I)) THEN
              IF(VSDOUB(1,I).GT.DVAL   .OR.
     &             VSDOUB(2,I).LT.DVAL) RETURN
           ELSE
*     
*     Phase type parameter
*
              DX1 = VSDOUB(2,I) - DBLE(NINT(VSDOUB(2,I)))
              DX2 = VSDOUB(1,I) - DBLE(NINT(VSDOUB(2,I)))
              IF(DX1.LT.0.D0) THEN
                 DX1 = DX1 + 1.D0
                 DX2 = DX2 + 1.D0
              END IF
              DX  = DVAL - DBLE(NINT(DVAL))
              IF(DX.LT.0.D0) DX = DX + 1.D0
              IF((DX.LT.DX1 .OR. DX.GT.DX2) .AND.
     &             DX+1.D0.GT.DX2) RETURN
           END IF
        ELSE
           RETURN
        END IF
      END DO
*
* Integer parameters
*
      DO I = 1, NSINTR     
         CALL HGETI(NMSINTR(I), IVAL, SLOT, MXSPEC, NMINTR, HDINTR, 
     &        NINTR, MXINTR, IFAIL)
        IF(IFAIL.EQ.0) THEN
           IF(VSINTR(1,I).GT.IVAL .OR.
     &          VSINTR(2,I).LT.IVAL) RETURN
        ELSE
           RETURN
        END IF
      END DO
*
* Real parameters
*
      DO I = 1, NSREAL    
         CALL HGETR(NMSREAL(I), RVAL, SLOT, MXSPEC, NMREAL, HDREAL, 
     &        NREAL, MXREAL, IFAIL)
         IF(IFAIL.EQ.0) THEN
            IF(VSREAL(1,I).LT.VSREAL(2,I)) THEN
               IF(VSREAL(1,I).GT.RVAL   .OR.
     &              VSREAL(2,I).LT.RVAL) RETURN
            ELSE
*
*     Phase type parameter
*     
               X1 = VSREAL(2,I) - REAL(NINT(VSREAL(2,I)))
               X2 = VSREAL(1,I) - REAL(NINT(VSREAL(2,I)))
               IF(X1.LT.0.) THEN
                  X1 = X1 + 1.
                  X2 = X2 + 1.
               END IF
               X  = RVAL - REAL(NINT(RVAL))
               IF(X.LT.0.) X = X + 1.
               IF((X.LT.X1 .OR. X.GT.X2) .AND.
     &              X+1. .GT. X2) RETURN
            END IF
         ELSE
            RETURN
         END IF
      END DO
      SELECT = .TRUE.
      RETURN
      END
