      SUBROUTINE LOCATE(XX,N,X,J)
*
* Searches an ordered array XX(N) for a value of J such
* that X is betweeb X(J) and X(J+1). Returns J=0 or N
* if out of range
*
      IMPLICIT NONE
      INTEGER N,J,JL,JU,JM
      REAL XX(N), X
*
      JL = 0
      JU = N + 1
      DO WHILE(JU-JL.GT.1)
        JM = (JU+JL)/2
        IF((XX(N).GT.XX(1)) .EQV. (X.GT.XX(JM))) THEN
          JL = JM
        ELSE
          JU = JM
        END IF
      END DO
      J = JL
      RETURN
      END

      SUBROUTINE HUNT(XX,N,X,JLO)
*
* Does same as locate but better if X does not move
* much from call to call
*
      IMPLICIT NONE
      INTEGER N, JLO, JHI, INC, JM
      REAL XX(N), X
      LOGICAL ASCND
*
      ASCND = XX(N).GT.XX(1)
      IF(JLO.LE.0 .OR. JLO.GT.1) THEN
        JLO = 0
        JHI = N + 1
        GOTO 3
      END IF
      INC = 1
      IF(X.GE.XX(JLO) .EQV. ASCND) THEN
1       JHI = JLO + INC
        IF(JHI.GT.N) THEN
          JHI = N + 1
        ELSE IF(X.GE.XX(JHI) .EQV. ASCND) THEN
          JLO=JHI
          INC=INC+INC
          GOTO 1
        END IF
      ELSE
        JHI=JLO
2       JLO=JHI-INC
        IF(JLO.LT.1) THEN
          JLO=0
        ELSE IF(X.LT.XX(JLO) .EQV. ASCND) THEN
          JHI = JLO
          INC = INC + INC
          GOTO 2
        END IF
      END IF
*
3     IF(JHI-JLO.EQ.1) RETURN
      JM=(JHI+JLO)/2
      IF(X.GT.XX(JM) .EQV. ASCND) THEN
        JLO = JM
      ELSE
        JHI = JM
      END IF
      GOTO 3
      END

      SUBROUTINE HUNTD(XX,N,X,JLO)
*
* Double prec veriob of hunt
*
      IMPLICIT NONE
      INTEGER N, JLO, JHI, INC, JM
      DOUBLE PRECISION XX(N), X
      LOGICAL ASCND
*
      ASCND = XX(N).GT.XX(1)
      IF(JLO.LE.0 .OR. JLO.GT.1) THEN
        JLO = 0
        JHI = N + 1
        GOTO 3
      END IF
      INC = 1
      IF(X.GE.XX(JLO) .EQV. ASCND) THEN
1       JHI = JLO + INC
        IF(JHI.GT.N) THEN
          JHI = N + 1
        ELSE IF(X.GE.XX(JHI) .EQV. ASCND) THEN
          JLO=JHI
          INC=INC+INC
          GOTO 1
        END IF
      ELSE
        JHI=JLO
2       JLO=JHI-INC
        IF(JLO.LT.1) THEN
          JLO=0
        ELSE IF(X.LT.XX(JLO) .EQV. ASCND) THEN
          JHI = JLO
          INC = INC + INC
          GOTO 2
        END IF
      END IF
*
3     IF(JHI-JLO.EQ.1) RETURN
      JM=(JHI+JLO)/2
      IF(X.GT.XX(JM) .EQV. ASCND) THEN
        JLO = JM
      ELSE
        JHI = JM
      END IF
      GOTO 3
      END
      
