CCLEAR
C CLEAR N1 N2 SURE -- Clears data from slots N1 to N2. If entered on
C                     command line requires SURE='sure' for it to go ahead,
C                     otherwise you will be asked whether you want to 
C                     proceed. Obviously some care must be taken with this
C                     command.
CCLEAR
      SUBROUTINE SCLEAR(SPLIT, NSPLIT, MXSPLIT, MXBUFF, MXSPEC, 
     &     MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, NMDOUB, NMINTR, 
     &     NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &     NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, MUTE, SLOTS, 
     &     MXSLOTS, IFAIL)
C     
C     Clears slots.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  L     MUTE      -- True to suppress terminal dialogue
C     >  I     SLOTS(MXSLOTS)       -- List of slots
C     >  I     MXSLOTS             -- Maximum number in list
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I
      CHARACTER*100 STRING, SURE*10
      INTEGER SLOT1, SLOT2,  IFAIL,  NCOM
      INTEGER   MAXSPEC, LENSTR
      LOGICAL  DEFAULT, MUTE, ESAMECI
C     
C     Functions
C     
C     
      DATA SLOT1, SLOT2/1,1/
      SAVE SLOT1, SLOT2, LIST, NLIST, SURE
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      CALL INTR_IN('First slot to clear', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to clear', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to clear'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
C     
      SURE = 'n'
      CALL CHAR_IN('Are you sure you want to clear slots?',
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, SURE, IFAIL)
      IF((NSPLIT.EQ.3 .AND. ESAMECI(SURE,'SURE')) .OR.
     &     ESAMECI(SURE,'Y')) THEN
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            IF(NPIX(SLOT).EQ.0) THEN
               IF(.NOT.MUTE) WRITE(*,*) 'Slot ',SLOT,' already empty.'
            ELSE
               IF(.NOT.MUTE) THEN
                  CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &                 NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &                 NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &                 MXINTR, MXREAL, STRING, IFAIL)
                  WRITE(*,*) STRING(:LENSTR(STRING))
               END IF
               NPIX(SLOT)  = 0
               NARC(SLOT)  = 0
               NDOUB(SLOT) = 0
               NINTR(SLOT) = 0
               NREAL(SLOT) = 0
            END IF
         END DO
      END IF
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END
