      PROGRAM RUBFIX
*
* Program to read molly files resulting from mis-translated ruby
* files. It will read, correct and dump out revised version.
*
      INTEGER  MXCHAR, MXDOUB, MXINTR, MXREAL, MXARC, MXPIX
      PARAMETER (MXCHAR=500)
      PARAMETER (MXDOUB=500)
      PARAMETER (MXINTR=500)
      PARAMETER (MXREAL=500)
      PARAMETER (MXARC =100)
      PARAMETER (MXPIX =10000)
      CHARACTER*16 NMCHAR(MXCHAR)
      CHARACTER*16 NMDOUB(MXDOUB)
      CHARACTER*16 NMINTR(MXINTR)
      CHARACTER*16 NMREAL(MXREAL)
      CHARACTER*32 HDCHAR(MXCHAR)
      DOUBLE PRECISION HDDOUB(MXDOUB)
      INTEGER HDINTR(MXINTR)
      REAL HDREAL(MXREAL)
      DOUBLE PRECISION ARC(MXARC)
      REAL COUNTS(MXPIX)
      REAL ERRORS(MXPIX)
      REAL FLUX(MXPIX)
      INTEGER FCODE, NARC, NPIX, NCHAR, NDOUB, NINTR, NREAL
      CHARACTER*16 UNITS
*
      CHARACTER*64 INPUT, OUTPUT
      INTEGER INUNIT, OUTUNIT
      INTEGER IARGC, NARG
      EXTERNAL IARGC
      DATA INUNIT, OUTUNIT/31,32/
*
      NARG = IARGC()
      IF(NARG.GT.2) THEN
        WRITE(*,*) 'Require only input and output files.'
      ELSE IF(NARG.EQ.2) THEN
        CALL GETARG(1,INPUT)
        CALL GETARG(2,OUTPUT)
      ELSE IF(NARG.EQ.1) THEN
        CALL GETARG(1,INPUT)
        WRITE(*,*) 'Enter corrected molly file to dump'
        READ(*,'(A)') OUTPUT
      ELSE
        WRITE(*,*) 'Enter molly file (from ruby) to read'
        READ(*,'(A)') INPUT
        WRITE(*,*) 'Enter corrected molly file to dump'
        READ(*,'(A)') OUTPUT
      END IF
      IF(INPUT.EQ.OUTPUT) STOP 'Input and output cannot be same'
*
      OPEN(UNIT=INUNIT,FILE=INPUT,FORM='UNFORMATTED',STATUS='OLD')
      OPEN(UNIT=OUTUNIT,FILE=OUTPUT,FORM='UNFORMATTED',
     &STATUS='NEW')
*
* Read spectra
*
      IFAIL = 0
      NSPEC = 0
      NZERO = 0
      DO WHILE(IFAIL.EQ.0)
        NSPEC = NSPEC + 1
*
* Read headers
*
        CALL RTHEAD(INUNIT, FCODE, UNITS, NPIX, NARC, 
     &  NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &  MXINTR, MXREAL, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &  HDCHAR, HDDOUB, HDINTR, HDREAL, IFAIL)
        IF(IFAIL.EQ.0) THEN
*
* Write headers
*
          CALL WTHEAD(OUTUNIT, FCODE, UNITS, NPIX, NARC, 
     &    NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &    MXINTR, MXREAL, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &    HDCHAR, HDDOUB, HDINTR, HDREAL, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to write spectrum ',NSPEC
            GOTO 999
          END IF
*
* Read data
*
          CALL RTDATA(INUNIT, COUNTS, ERRORS, FLUX, ARC, 
     &    FCODE, NPIX, NARC, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to read data.'
            GOTO 999
          END IF
*
* Correct error
*
          DO I = 1, NPIX
            IF(COUNTS(I).EQ.0.) THEN
              NZERO = NZERO + 1
              FLUX(I) = 1./FLUX(I)
            END IF
          END DO
*
* Write data
*
          CALL WTDATA(OUTUNIT, COUNTS, ERRORS, FLUX, ARC, FCODE, 
     &    NPIX, NARC, IFAIL)
          IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to write data on spectrum ',NSPEC
            GOTO 999       
          END IF
          WRITE(*,*) 'Translated spectrum ',NSPEC
        END IF
      END DO
      CLOSE(UNIT=INUNIT)
      CLOSE(UNIT=OUTUNIT)
      WRITE(*,*) 'Successfully corrected ',NSPEC-1,' spectra.'
      WRITE(*,*) NZERO,' bad points were found.'
      STOP  
999   CLOSE(UNIT=INUNIT)
      CLOSE(UNIT=OUTUNIT)
      WRITE(*,*) 'Sorry, something has gone wrong.' 
      STOP
      END
