      SUBROUTINE REPLACE(DAT, SIG, MASK, NORM, NDATA, NF, NL, IFAIL)
*
* Given an array DAT(NDATA) and a mask MASK(NDATA), this routine will replace
* all masked regions by a linear interpolation of nearest good data
* values. If NORM is TRUE then MASK = TRUE regions are replaced,
* otherwise its the other way around. Masked regions at end replaced
* by nearest data point.
*
* SIG(NDATA) are the uncertainties. If <0 these are interpolated over too.
*
* Returns NF, NL first and last good pixels.
*
* IFAIL = 0, OK; if not, there are no good pixels.
*
      INTEGER NDATA
      LOGICAL MASK(NDATA), NORM
      REAL DAT(NDATA), SIG(NDATA)
      INTEGER N1, N2, NF, NL, J, IFAIL
*
      N1 = 0
      N2 = 0
      NF = 1
      NL = NDATA
      DO J = 1, NDATA
        IF(MASK(J).EQV.NORM .OR. SIG(J).LE.0.) THEN
          IF(N1.EQ.0) N1 = J
          N2 = J
        ELSE
          IF(N1.EQ.1) THEN
            NF = J
            DO N = N1, N2
              DAT(N) = DAT(NF)
            END DO
            N1 = 0
            N2 = 0
          ELSE IF(N1.GT.1) THEN
            F1 = DAT(N1-1)
            F2 = DAT(N2+1)
            DO N = N1, N2
              DAT(N) = (F1*REAL(N2+1-N)+F2*REAL(N-N1+1))/
     &                  REAL(N2-N1+2)
            END DO             
            N1 = 0
            N2 = 0
          END IF
        END IF
      END DO
      IF(N2.GT.0) THEN
        NL = N1 - 1
        DO N = N1, N2
          DAT(N) = DAT(NL)
        END DO
      END IF
      IFAIL = 0
      IF(N1.EQ.1 .AND. N2.EQ.NDATA) IFAIL = 1
      RETURN
      END
