CCOPY
C COPY N1 N2 N3 NCOPY -- Copies a series of spectra, NCOPY times.
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to copy
C  N2    -- Slot number of last spectrum to copy
C  N3    -- First slot for copies
C  NCOPY -- Number of copies.
C
C Associated routines: noise, boot
CCOPY
CNOISE
C NOISE N1 N2 N3 NCOPY METHOD [READ PHOT] SEED -- Copies a series of spectra, 
C                              NCOPY times, adds noise.
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to copy
C  N2    -- Slot number of last spectrum to copy
C  N3    -- First slot for copies
C  NCOPY -- Number of copies.
C  METHOD-- 'E' -- Adds noise according to error bars on spectrum. The
C                  error bars on the output spectra are identical.
C
C           'M' -- Adds noise by assuming a certain number of photons/mJy.
C                  Takes no account of error bars on spectrum.
C
C  If METHOD.EQ.'M' you need to specify:
C
C  PHOT  -- Number of photons/mJy
C  READ  -- Read out noise in photons to act as a floor.
C
C In any case:
C
C  SEED  -- Seed integer for random number generator
C           Enter 0 to carry on from old value.
C
C Associated routines: copy, boot
CNOISE
CBOOT
C BOOT N1 N2 N3 NCOPY SEED SET -- Copies a series of spectra, NCOPY times, 
C                             changes error bars to simulate bootstrap
C                             selection of data points. Spectra can then
C                             be used in a fit to generate error bars.
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to copy
C  N2    -- Slot number of last spectrum to copy
C  N3    -- First slot for copies
C  NCOPY -- Number of copies.
C  SEED  -- Seed integer for random number generator
C           Enter 0 to carry on from old value.
C  SET   -- Apply a mask
C
C The bootstrap only operates on unmasked data and data with positive 
C error bars. If there are N valid points then N points are sampled
C with replacement to work out how many times each new point will be
C included in bootstrap analysis. If a point is not selected at all
C then its error bar is made negative, otherwise the error bar is
C divided by the square root of the number of times a point was picked.
C With Chi**2 type weights, then the point is effectively used that number
C of times in a fit.
C
C Associated routines: noise, copy
CBOOT
      SUBROUTINE REPET(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &     HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &     MXINTR, MXREAL, IWORK, WORK1, WORK2, WORK3, MASK, 
     &     MXWORK, SLOTS, MXSLOTS, METHOD, MUTE, IFAIL)
C     
C     Copies spectra and optionally adds noise according to error bars
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     incremented and returned by routine.
C     C     METHOD    -- 'S' standard
C     'N' Noise added
C     'B' Boot strap
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
      INTEGER MXWORK
      LOGICAL MASK(MXWORK)
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK)
      INTEGER IWORK(MXWORK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
      CHARACTER*(*) METHOD
C     
C     Mask arrays
C     
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C     
C     Local variables
C     
      INTEGER I, J, K
      REAL GET_FLX, GET_ERF,   GAUSS1, RAN1
      DOUBLE PRECISION VEARTH
      REAL  READ, PHOT
      CHARACTER*100 STRING
      CHARACTER*1  SET*3, OPER
      INTEGER SLOT1, SLOT2, SLOT3,  IFAIL
      INTEGER  MAXSPEC,  NGOOD, LENSTR
      INTEGER  NCOPY, MXCOPY, OUT
      INTEGER ISEED, SEED, NCOM, JADD
      LOGICAL  SAMECI, MUTE, DEFAULT
      REAL E, F, RATIO
C     
C     Functions
C     
      REAL CFRAT
C     
      DATA SLOT1, SLOT2, SLOT3, SEED/1, 1, 2, 12345/
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
      DATA READ, PHOT, NCOPY/0., 1000., 1/
      DATA SET, OPER/'Yes', 'E'/
C     
C***********************************************************************
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
C     
      CALL INTR_IN('First slot to copy', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to copy', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0 0 to pick slots individually'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Pick slots to copy'       
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      NGOOD = 0
      DO I = 1, NSLOTS
         IF(NPIX(SLOTS(I)).GT.0) NGOOD = NGOOD + 1
      END DO
      IF(NGOOD.LE.0) THEN
         WRITE(*,*) 'No valid slots chosen'
         GOTO 999
      END IF
C     
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NGOOD+1, IFAIL)
      MXCOPY = (MAXSPEC-SLOT3+1)/NGOOD
      CALL INTR_IN('Number of copies', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NCOPY, 1, MXCOPY, IFAIL)
C     
      IF(METHOD.EQ.'N') THEN
         CALL CHAR_IN('Noise method (E or M)', SPLIT, NSPLIT,
     &        MXSPLIT, NCOM, DEFAULT, OPER, IFAIL)
         CALL UPPER_CASE(OPER)
         IF(OPER.EQ.'M') THEN
            CALL REAL_IN('Number of photons/mJy', SPLIT, NSPLIT, 
     &           MXSPLIT, NCOM, DEFAULT, PHOT, 1.E-10, 1.E10, IFAIL)
            CALL REAL_IN('Readout noise/pixel (photons)', SPLIT, 
     &           NSPLIT, MXSPLIT, NCOM, DEFAULT, READ, 0., 1.E20, IFAIL)
         ELSE IF(OPER.NE.'E') THEN
            WRITE(*,*) 'Invalid answer. Must be:'
            WRITE(*,*) 'E -- Noise fixed according'//
     &           ' to error bars on spectra'
            WRITE(*,*) 'M -- Noise fixed by photons/mJy'
            OPER = 'E'
            GOTO 999
         END IF
         CALL INTR_IN(
     &        'Seed integer for noise (0 to avoid resetting)', SPLIT, 
     &        NSPLIT, MXSPLIT, NCOM, DEFAULT, SEED, 0, 99999999, IFAIL)
      ELSE IF(METHOD.EQ.'B') THEN
         CALL INTR_IN(
     &        'Seed integer for bootstrap (0 to avoid resetting)', 
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, SEED, 0, 99999999, 
     &        IFAIL)
         CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &        DEFAULT, SET, IFAIL)
         IF(SAMECI(SET,'YES')) THEN
            WRITE(*,*) 'Mask regions not wanted in bootstrap.'
            CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &           NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &           NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &           WORK2, WORK3, MXWORK, MASK)
         END IF
      ELSE IF(METHOD.NE.'S') THEN
         WRITE(*,*) 'Invalid method = ',METHOD
         GOTO 999
      END IF
      IF(IFAIL.NE.0) GOTO 999
C     
C     Copy spectra
C     
      OUT = SLOT3 - 1
      IF(SEED.NE.0) ISEED = - ABS(SEED)
      DO K = 1, NCOPY
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            IF(NPIX(SLOT).GT.0) THEN
               OUT = OUT + 1
C     
C     Bootstrap only on data with positive error bars and unmasked
C     
               IF(METHOD.EQ.'B') THEN
C     
C     Get mask
C     
                  CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &                 HDDOUB, NDOUB, MXDOUB, IFAIL)
                  IFAIL = 0
C     
                  CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),
     &                 NARC(SLOT),MXARC,PMASK,NPMASK,WMASK,NWMASK,
     &                 VMASK,NVMASK,MXMASK,.FALSE.,VEARTH,IFAIL)
                  NGOOD = 0
                  DO J = 1, NPIX(SLOT)
                     IF(MASK(J) .AND. ERRORS(J,SLOT).GT.0.) THEN
                        NGOOD = NGOOD + 1
                        IWORK(NGOOD) = J
                     END IF
                     WORK1(J) = 0.
                  END DO
                  DO J = 1, NGOOD
 100                 JADD = NINT(REAL(NGOOD)*RAN1(ISEED)+0.5)
                     IF(JADD.LT.1 .OR. JADD.GT.NGOOD) GOTO 100
                     WORK1(IWORK(JADD)) = WORK1(IWORK(JADD)) + 1.
                  END DO
               END IF
               DO J = 1, NPIX(SLOT)
                  IF(METHOD.EQ.'N') THEN
                     IF(OPER.EQ.'E') THEN
                        RATIO = CFRAT(COUNTS(J,SLOT),FLUX(J,SLOT))
                        E = GET_ERF(COUNTS(J,SLOT),ERRORS(J,SLOT),
     &                       FLUX(J,SLOT))
                        F  = GET_FLX(COUNTS(J,SLOT),FLUX(J,SLOT))
                        F = GAUSS1(F,E,ISEED)
                        COUNTS(J,OUT) = RATIO*F
                        ERRORS(J,OUT) = ERRORS(J,SLOT)
                     ELSE
                        RATIO = PHOT
                        F  = GET_FLX(COUNTS(J,SLOT),FLUX(J,SLOT))
                        E  = SQRT(ABS(F)/PHOT+(READ/PHOT)**2)
                        F = GAUSS1(F,E,ISEED)
                        COUNTS(J,OUT) = RATIO*F
                        ERRORS(J,OUT) = RATIO*E
                     END IF
                     IF(COUNTS(J,OUT).EQ.0.) THEN
                        FLUX(J,OUT) = RATIO
                     ELSE
                        FLUX(J,OUT) = F
                     END IF
                  ELSE IF(METHOD.EQ.'B') THEN
                     ERRORS(J,OUT) = ERRORS(J,SLOT)
                     COUNTS(J,OUT) = COUNTS(J,SLOT)
                     FLUX(J,OUT)   = FLUX(J,SLOT)
                     IF(WORK1(J).LE.0.5) THEN
                        ERRORS(J,OUT) = - ABS(ERRORS(J,OUT))
                     ELSE
                        ERRORS(J,OUT) = ERRORS(J,OUT)/SQRT(WORK1(J))
                     END IF
                  ELSE IF(METHOD.EQ.'S') THEN
                     COUNTS(J,OUT) = COUNTS(J,SLOT)
                     FLUX(J,OUT)   = FLUX(J,SLOT)
                     ERRORS(J,OUT) = ERRORS(J,SLOT)
                  END IF
               END DO
C     
               CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &              MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &              HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &              MXCHAR, MXDOUB, MXINTR, MXREAL, IFAIL)
C     
               IF(.NOT.MUTE) THEN
                  CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &                 NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &                 NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &                 MXINTR, MXREAL, STRING, IFAIL)
                  WRITE(*,*) STRING(:LENSTR(STRING))
               END IF
            ELSE
               WRITE(*,*) 'Slot ',SLOT,' empty.'
            END IF
         END DO
      END DO
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END
