      SUBROUTINE QROMB(FUNC,A,B,SS,ACC,IFAIL)
*
* Numerical Recipes Romberg integration routine
* with added check against A>B
* ACC extra convergende test. If estimated error less than ACC
* QROMB returns. This is to account for cases where integral
* is very close to zero because of negative/positive integrand
* and the fractional test in QROMB becomes unhelpful
*
      INTEGER J,JMAX,JMAXP,K,KM,IFAIL
      DOUBLE PRECISION A,B,FUNC,SS,EPS,ACC
      EXTERNAL FUNC
      PARAMETER (EPS=1.D-6, JMAX=20, JMAXP=JMAX+1, K=5, KM=K-1)
      DOUBLE PRECISION DSS,H(JMAXP),S(JMAXP)
*
      IFAIL = 0
      IF(A.GE.B) THEN
        SS = 0.D0
        GOTO 999
      END IF
      H(1)=1.D0
      DO J = 1, JMAX
        CALL TRAPZD(FUNC,A,B,S(J),J)
        IF (J.GE.K) THEN
          CALL POLINT(H(J-KM),S(J-KM),K,0.D0,SS,DSS,IFAIL)
          IF(IFAIL.NE.0) THEN
            IFAIL = 2
            GOTO 999
          END IF
          IF (ABS(DSS).LE.EPS*ABS(SS) .OR. ABS(DSS).LE.ACC) GOTO 999
        END IF
        S(J+1)=S(J)
        H(J+1)=0.25*H(J)
      END DO
      IFAIL = 1
999   RETURN
      END
