*PUTLAB 
* PUTLAB X Y LABEL CH LW JUST ANGLE FONT COLOUR -- Places a label on a plot 
*                                           (as long as the device is open)
*
* Parameters:  
*
*   X, Y   -- Position of label
*   LABEL  -- Character string. In quotes if it has blanks
*   CH     -- Character height. real.
*   LW     -- Line width, integer
*   JUST   -- Justification 0=left, 0.5=centred, 1=right
*   ANGLE  -- Angle to horizontal, degrees
*   FONT   -- Character font 1-4
*   COLOUR -- Integer colour 2=red etc.
*
*PUTLAB
      SUBROUTINE PUTLAB(SPLIT, NSPLIT, MXSPLIT, IFAIL)
C
      IMPLICIT NONE
      INCLUDE 'device.inc'
      INTEGER NSPLIT, MXSPLIT, IFAIL, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL DEFAULT
      CHARACTER*132 LABEL
      REAL X, Y, CH, JUST, ANGLE
      INTEGER FONT, LW, PCOL
      SAVE X, Y, CH, JUST, ANGLE, FONT, LW, PCOL, LABEL
      DATA X, Y, CH, JUST, ANGLE/0., 0., 1., 0.5, 0./
      DATA FONT, LW, PCOL/1,1,1/
      DATA LABEL/' '/
*
      IFAIL = 0
      NCOM = 0
      DEFAULT = .FALSE.
      IF(NDID.LE.0) THEN
         WRITE(*,*) 'No plot device is open'
         GOTO 999
      END IF
      CALL REAL_IN('X position of label', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, X, -1.E30, 1.E30, IFAIL)
      CALL REAL_IN('Y position of label', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, Y, -1.E30, 1.E30, IFAIL)
      CALL CHAR_IN('Label', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, LABEL, IFAIL)
      CALL REAL_IN('Character height', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, CH, 0., 1000., IFAIL)
      CALL INTR_IN('Line width', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, LW, 1, 100, IFAIL)
      CALL REAL_IN('Justification (0=L,0.5=C,1=R)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, JUST, 0., 1., IFAIL)
      CALL REAL_IN('Angle to horizontal', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, ANGLE, -360., 360., IFAIL)
      CALL INTR_IN('Font (1-4)', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, FONT, 1, 4, IFAIL)
      CALL INTR_IN('Colour', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, PCOL, 1, 255, IFAIL)
      IF(IFAIL.NE.0) GOTO 999      
*     
      CALL PGSAVE
      CALL PGSLS(1)
      CALL PGSLW(LW)
      CALL PGSCI(PCOL)
      CALL PGSCH(CH)
      CALL PGSCF(FONT)
      CALL PGPTXT(X, Y, ANGLE, JUST, LABEL) 
      CALL PGUNSA
      IFAIL = 0
      RETURN
 999  IFAIL = 1
      RETURN
      END   
