CPATCH
C PATCH N -- Interactive patching of spectra, equivalent width and flux
C            measurements
C
C Parameters:
C         N -- Slot to treat. Can be changed inside PATCH
C
C Primarily interactive. Scope: use cursor to modify spectrum and measure
C parameters of spectral features. e.g. it can be useful when trying to
C fit over telluric features where there is no good continuum on one side.
C In such a case, PATCH can be used to put an artificial continuum in order
C to constrain the fit.
CPATCH
      SUBROUTINE PATCH(SPLIT, NSPLIT, MXSPLIT, PLOT1, PLOT2, PLOT3, 
     &     MXPLOT, COUNTS, ERRORS, FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, 
     &     ARC, NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &     HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &     MXDOUB, MXINTR, MXREAL, IFAIL)
C     
C     Interactive routine for patching spectra and measuring line fluxes.
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     >  R     PLOT1(MXPLOT)    -- Work arrays for plotting
C     >  R     PLOT2(MXPLOT)
C     >  R     PLOT3(MXPLOT)
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     incremented and returned by routine.
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Plot parameters
C     
      INTEGER MXPLOT 
      REAL PLOT1(MXPLOT), PLOT2(MXPLOT), PLOT3(MXPLOT)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Local variables
C     
      INTEGER  L, M, N
      INTEGER N1, N2, M1, M2, NPLOT, NCOM
      REAL GET_FLX, GET_ERF, Z, CFAC, W
      DOUBLE PRECISION VEARTH, A, SUM1, SUM2, SUM3, SUM4
      DOUBLE PRECISION SUM5, SUM6, SUM7, SUM8, SUM9, Z1, Z2
      REAL W1, W2, FAC, X, Y, DELTA, W0
      REAL  XF, YF, XS, YS, F, E, D, DNU
      CHARACTER*100 STRING
      CHARACTER*1 CH, REPLY*3, DISK*3, REP*3
      INTEGER SLOT, IFAIL, MAXSPEC, PGCURSE, LENSTR
      LOGICAL  SAMECI, ESET, PLOK, DEFAULT, WRT, PLOT
      REAL VLIGHT, CGS, VFAC, CFRAT
      CHARACTER*16 XAXIS, YAXIS
      DOUBLE PRECISION ANGST, DISPA, PIXL
C     
      SAVE SLOT, W0, DISK
      DATA SLOT, W0/1,5000./
      DATA DISK/'N'/
C     
      WRT    = .FALSE.
      PLOT   = .FALSE.
      VLIGHT = CGS('C')/1.E5
      CFAC = VLIGHT*1.E-13
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
 2000 CALL INTR_IN('Slot to patch', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &     NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &     MXINTR, MXREAL, STRING, IFAIL)
      WRITE(*,*) STRING(:LENSTR(STRING))
      XAXIS = 'ANGSTROMS'
      YAXIS = 'MILLIJANSKYS'
      IF(.NOT. PLOK(NPIX(SLOT),MXPLOT,NARC(SLOT),
     &     XAXIS,YAXIS)) THEN
         WRITE(*,*) 'Plot not possible in requested format'
         GOTO 999
      END IF
      CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &     HDDOUB, NDOUB, MXDOUB, IFAIL)
      IFAIL = 0
      VFAC = REAL(1.-VEARTH/VLIGHT)
C     
C     Load plot arrays
C     
      CALL PLOAD(PLOT1, PLOT2, PLOT3, NPLOT, MXPLOT, SLOT, 
     &     COUNTS, ERRORS, FLUX, MXBUFF, MAXPX, MXSPEC, NPIX, 
     &     ARC, NARC, MXARC, VEARTH, XAXIS, YAXIS, W0, 0., 
     &     0., ESET, DELTA, 0., IFAIL)
      IF(NPLOT.LE.0 .OR. IFAIL.NE.0) THEN
         WRITE(*,*) 'Failure in PLOAD'
         GOTO 999
      END IF
C     
C     Simple plot, leaves plt open at end.
C     
      IF(PLOT) CALL DEV_CLOSE(0,IFAIL)
      PLOT = .FALSE.
      L = LENSTR(STRING)
      CALL QPLOT(PLOT1, PLOT2, PLOT3, NPLOT, ESET,
     &     'Wavelength (\\A)', 'f\\d\\gn\\u (mJy)', STRING(:L), 
     &     IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      PLOT = .TRUE.
C     
C     Allow various manipulations.
C     
 100  WRITE(*,*) 'Commands:'
      WRITE(*,*) ' '
      WRITE(*,*) 'p  -- Patch spectrum with straight lines'
      WRITE(*,*) 'e  -- Equivalent widths, fluxes.'
      WRITE(*,*) 'c  -- Change spectrum'
      WRITE(*,*) 'q  -- Quit'
      WRITE(*,*) ' '
 200  WRITE(*,'(A,$)') 'patch> '
      READ(*,'(A)') REPLY
      CALL UPPER_CASE(REPLY)
      IF(REPLY.EQ.'P' .OR. REPLY.EQ.'E') THEN
         IF(REPLY.EQ.'P') THEN
            WRITE(*,*) 'Enter pairs of points with the cursor and the'
            WRITE(*,*) 'spectrum will be replaced by linearly'
            WRITE(*,*) 'interpolated values between them.'
         ELSE IF(REPLY.EQ.'E') THEN
            WRITE(*,*) 'Enter pairs of points with the cursor and the'
            WRITE(*,*) 'equivalent width and flux between them will be'
            WRITE(*,*) 'calculated.'
         END IF
 300     WRITE(*,*) 'First point (Q to quit, S to show)'
         IFAIL = PGCURSE(X,Y,CH)
         IF(IFAIL.NE.1) THEN
            WRITE(*,*) 'Cursor failure'
            GOTO 200
         END IF
         CALL UPPER_CASE(CH)
         IF(CH.EQ.'Q') THEN
            GOTO 200
         ELSE IF(CH.EQ.'S') THEN
            WRITE(*,*) 'X = ',X,', Y = ',Y
            GOTO 300
         END IF
         XF = X
         YF = Y
 301     WRITE(*,*) 'Second point (Q to quit, S to show)'
         IFAIL = PGCURSE(X,Y,CH)
         IF(IFAIL.NE.1) THEN
            WRITE(*,*) 'Cursor failure'
            GOTO 200
         END IF
         CALL UPPER_CASE(CH)
         IF(CH.EQ.'Q') THEN
            GOTO 200
         ELSE IF(CH.EQ.'S') THEN
            WRITE(*,*) 'X = ',X,', Y = ',Y
            GOTO 301
         END IF
         XS = X
         YS = Y
C     
C     First determine which pixels are covered
C     
         IF(SAMECI(XAXIS,'PIXELS')) THEN
            N1 = NINT(XF)
            N2 = NINT(XS)
            W1 = REAL(ANGST(XF, NPIX(SLOT), NARC(SLOT),
     &           ARC(1,SLOT),MXARC))
            W2 = REAL(ANGST(XF, NPIX(SLOT), NARC(SLOT),
     &           ARC(1,SLOT),MXARC))
         ELSE
            IF(SAMECI(XAXIS,'ANGSTROMS')) THEN
               Z1 = XF/VFAC
               Z2 = XS/VFAC
            ELSE IF(SAMECI(XAXIS,'MICRONS')) THEN
               Z1 = 1.E4*XF/VFAC
               Z2 = 1.E4*XS/VFAC
            ELSE IF(SAMECI(XAXIS,'NANNOMETRES')) THEN
               Z1 = 1.E1*XF/VFAC
               Z2 = 1.E1*XS/VFAC
            ELSE IF(SAMECI(XAXIS,'KM/S')) THEN
               Z1 = W0*(1.+(XF+VEARTH)/VLIGHT)
               Z2 = W0*(1.+(XS+VEARTH)/VLIGHT)
            END IF
            W1 = REAL(Z1)
            W2 = REAL(Z2)
            N1 = NINT(PIXL(Z1, NPIX(SLOT), NARC(SLOT),
     &           ARC(1,SLOT),MXARC))
            N2 = NINT(PIXL(Z2, NPIX(SLOT), NARC(SLOT),  
     &           ARC(1,SLOT), MXARC))
         END IF
C     
         IF(N1.EQ.N2) THEN
            Z1 = (YF+YS)/2.
            Z2 = Z1
         END IF
         M1 = MAX(1, MIN(NPIX(SLOT), N1))
         M2 = MAX(1, MIN(NPIX(SLOT), N2))
         IF(N1.NE.N2) THEN
            Z1 = YF + (YS-YF)*REAL(M1-N1)/REAL(N2-N1)
            Z2 = YF + (YS-YF)*REAL(M2-N1)/REAL(N2-N1)
         END IF
         IF(M1.GT.M2) THEN
            N  = M1
            M1 = M2
            M2 = N
            Z  = REAL(Z1)
            Z1 = REAL(Z2)
            Z2 = Z
         END IF
         IF(W1.GT.W2) THEN
            W  = W1
            W1 = W2
            W2 = W
         END IF
C     
C     Translate Y values into mJy fluxes
C     
         IF(SAMECI(YAXIS,'COUNTS')) THEN
            Z1 = Z1/CFRAT( COUNTS(M1,SLOT), FLUX(M1,SLOT) )
            Z2 = Z2/CFRAT( COUNTS(M2,SLOT), FLUX(M2,SLOT) )
         ELSE IF(SAMECI(YAXIS,'FLAMBDA')) THEN
            A = ANGST(REAL(M1), NPIX(SLOT), NARC(SLOT), 
     &           ARC(1,SLOT), MXARC)
            Z1 = A**2*Z1/CFAC
            A = ANGST(REAL(M2), NPIX(SLOT), NARC(SLOT), 
     &           ARC(1,SLOT), MXARC)
            Z2 = A**2*Z2/CFAC
         END IF
C     
         IF(REPLY.EQ.'P') THEN
C     
C     Linearly interpolate
C     
            DO M = M1, M2
               FAC = CFRAT(COUNTS(M,SLOT),FLUX(M,SLOT))
               Z   = REAL(Z1 + (Z2-Z1)*REAL(M-M1)/REAL(MAX(1,M2-M1)))
               COUNTS(M,SLOT) = FAC*Z
               IF(COUNTS(M,SLOT).EQ.0.) THEN
                  FLUX(M,SLOT) = FAC            
               ELSE
                  FLUX(M,SLOT) = Z
               END IF
            END DO
C     
         ELSE IF(REPLY.EQ.'E') THEN
            SUM1 = 0.D0
            SUM2 = 0.D0
            SUM3 = 0.D0
            SUM4 = 0.D0
            SUM5 = 0.D0
            SUM6 = 0.D0
            SUM7 = 0.D0
            SUM8 = 0.D0
            SUM9 = 0.D0
            DO M = M1, M2
               Z = REAL(Z1 + (Z2-Z1)*REAL(M-M1)/REAL(MAX(1,M2-M1)))
               A = REAL(ANGST(REAL(M), NPIX(SLOT), NARC(SLOT), 
     &              ARC(1,SLOT), MXARC))
               D = REAL(DISPA(REAL(M), NPIX(SLOT), NARC(SLOT), 
     &              ARC(1,SLOT), MXARC))
               DNU  = REAL(VLIGHT*ABS(D)/(A-D/2.)/(A+D/2.))
               F = GET_FLX(COUNTS(M,SLOT), FLUX(M,SLOT))
               E = GET_ERF(COUNTS(M,SLOT), ERRORS(M,SLOT), 
     &              FLUX(M,SLOT))
               SUM1 = SUM1 + DNU*F
               SUM2 = SUM2 + (DNU*E)**2
               SUM3 = SUM3 + DNU*Z
               SUM4 = SUM4 + ABS(D)*F/A
               SUM5 = SUM5 + (D*E/A)**2
               SUM6 = SUM6 + ABS(D)*Z/A
               SUM7 = SUM7 + ABS(D)/A
               SUM8 = SUM8 + 2.*ABS(D)*(F-Z)/(Z1+Z2)
               SUM9 = SUM9 + (2.*ABS(D)*E/(Z1+Z2))**2
            END DO
            WRITE(*,*) 'Mean flux density = ',SNGL(SUM4/SUM7),
     &           ' +/- ',SNGL(SQRT(SUM5)/SUM7)
            WRITE(*,*) 'Mean continuum flux density = ',
     &           SNGL(SUM6/SUM7)
            WRITE(*,*) 'Line flux density = ',
     &           SNGL((SUM4-SUM6)/SUM7),' +/- ',SNGL(SQRT(SUM5)/SUM7)
            WRITE(*,*) 'Flux = ',1.E-13*SNGL(SUM1),' +/- ',
     &           1.E-13*SNGL(SQRT(SUM2))
            WRITE(*,*) 'Continuum flux = ',1.E-13*SNGL(SUM3)
            WRITE(*,*) 'Line flux = ',1.E-13*SNGL(SUM1-SUM3),
     &           ' +/- ',1.E-13*SNGL(SQRT(SUM2))
            WRITE(*,*) 'Equivalent width = ',SNGL(SUM8),
     &           ' +/- ',SNGL(SQRT(SUM9))
            WRITE(*,*) ' '
 101        WRITE(*,'(A,A,A)') 'Write to disk ? [',DISK(:1),'] '
            READ(*,'(A)') REP
            CALL UPPER_CASE(REP)
            IF(REP.EQ.' ') REP = DISK
            IF(REP.EQ.'Y') THEN
               WRT = .TRUE.
               CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &              NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &              NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &              MXINTR, MXREAL, STRING, IFAIL)
               WRITE(31,*,ERR=998) ' '
               WRITE(31,*,ERR=998) ' '
               WRITE(31,*,ERR=998) STRING(:LENSTR(STRING))
               WRITE(31,*,ERR=998) ' '
               WRITE(31,*,ERR=998) 'Range ',W1,' to ',W2
               WRITE(31,*,ERR=998) 'Mean flux density = ',
     &              SNGL(SUM4/SUM7),' +/- ',SNGL(SQRT(SUM5)/SUM7)
               WRITE(31,*,ERR=998) 'Mean continuum flux'//
     &              ' density = ',SNGL(SUM6/SUM7)
               WRITE(31,*,ERR=998) 'Line flux density = ',
     &              SNGL((SUM4-SUM6)/SUM7),' +/- ',SNGL(SQRT(SUM5)/SUM7)
               WRITE(31,*,ERR=998) 'Flux = ',1.E-13*SNGL(SUM1),
     &              ' +/- ',1.E-13*SNGL(SQRT(SUM2))
               WRITE(31,*,ERR=998) 'Continuum flux = ',
     &              1.E-13*SNGL(SUM3)
               WRITE(31,*,ERR=998) 'Line flux = ',
     &              1.E-13*SNGL(SUM1-SUM3),' +/- ',
     &              1.E-13*SNGL(SQRT(SUM2))
               WRITE(31,*,ERR=998) 'Equivalent width = ',
     &              SNGL(SUM8),' +/- ',SNGL(SQRT(SUM9))
            ELSE IF(REP.NE.'N') THEN
               WRITE(*,*) 'Must be Y or N'
               GOTO 101
            END IF
            DISK = REP
            WRITE(*,*) ' '
         END IF
         CALL PGSCI(2)
         CALL PGMOVE(XF,YF)
         CALL PGDRAW(XS,YS)
         CALL PGSCI(1)
         GOTO 300
 998     WRITE(*,*) 'Error writing to unit 31'
         GOTO 300
      ELSE IF(REPLY.EQ.'Q') THEN
         IF(WRT) THEN
            CLOSE(UNIT=31)
            WRITE(*,*) 'Results written to unit 31'
         END IF
         CALL DEV_CLOSE(0,IFAIL)
         PLOT = .FALSE.
         IFAIL = 0
         RETURN
      ELSE IF(REPLY.EQ.'C') THEN
         NSPLIT = 0
         DEFAULT = .FALSE.
         GOTO 2000
      ELSE
         WRITE(*,*) 'Invalid command'
         GOTO 100
      END IF
 999  IFAIL = 1
      RETURN
      END
