*ORBIT
* ORBIT N1 N2 N3 N4 FIX KXLO KXHI NKX KYLO KYHI NKY GALO GAHI NGA 
*       FRLO FRHI NFR VSLO VSHI NVS TAPER EPS OPTION FLO FHI FILE SET  
*
*       Solves for orbital parameters of binary motion using Bayesian 
*       analysis of cross-correlation or 'skew mapping'. The orbit is fit with 
*       V = Gamma - Kx cos(2*pi*phi) + Ky sin(2*pi*phi)
*       and the routine can optimise GAMMA, Kx, Ky, the orbital frequency
*       FREQ (cycles/day) and the rotational broadening VSINI.
*
* Parameters:
*
*          N1  -- First object spectrum
*          N2  -- Last object spectrum
*          N3  -- First template spectrum
*          N4  -- Last template spectrum
*          FIX -- String controlling operations of maximisation stepping
*                 etc. 
*                 0 = allow parameter to be maximised.
*                 1 = parameter will be fixed at one value.
*                 2 = parameter will be stepped but maxmised.
*
*           The parameters have the order Kx, Ky, Gamma, orbital
*           frequency and Vsini (=GXYFV) e.g. 00012 allows KX, KY, GAMMA, 
*           to vary but holds VSINI fixed at a single value while stepping in 
*           FREQ. This would go through a series of frequencies, optimising 
*           KX, KY and Gamma each time.
*
* The parameters to be stepped or optimised need a grid of values to be
* specified. If they are to be optimised, a maximum is hunted by first 
* locating the highest point on a regularly spaced grid. 
*
* Fixed    Free
*
* KX    or KXLO, KXHI, NKX -- Kx (km/s)
* KY    or KYLO, KYHI, NKY -- Ky (km/s) 
* GAMMA or GALO, GAHI, NGA -- systemic velocity (km/s).
* FREQ  or FRLO, FRHI, NFR -- Orbital frequency (cycles/day)
* VSINI or VSLO, VSHI, NVS -- V sin i (km/s)
*
*            TAPER-- Amount to taper at ends to reduce end effects
*            EPS  -- limb darkening for broadening
*
*            OPTION- Two possible Bayesian models according to whether we allow
*                    the veiling factors or f-values (which indicate the 
*                    fraction of flux from the Xcor target) to be independent
*                    for each spectrum or to have 1 value only. 
**                    1 -- independent f-values for eachs. Suited to
*                         eclipsing binaries and other cases where f may vary.
*                    2 -- for single f-value (equivalent to Smith's skew
*                      mapping and probably best for very difficult cases
*
*            FLO, FHI Lower and upper limits to fraction of light contributed
*                     by secondary star. Comes into the integral over the
*                     f-values used in the Bayesian computation. 
*            FILE  - File to store values on stepped grid. This is
*                    a FIGARO file. You will only be prompted for it if
*                    you step at least one parameter. <CR> not to bother.
*            SET   - Yes to set mask pixels in target spectra. The template
*                    spectra are assumed to be OK.
*
* Details:
*
* The spectra and templates should be normalised and continuum subtracted. 
* The parameter Vsini should only be changed if absolutely necessary as
* this entails a large computational cost. 
*
* The routine initially looks for a maximum with a grid search over user
* defined ranges. The values here should be chosen carefully. For example
* if you tried 100 points in each of 5 parameters you would end trying to
* compute the probability over 10**10 points, which would take forever.
* You may want to start without searching over Vsini and perhaps Gamma to
* reduce the burden. The probability function has many peaks which is why
* this expensive strategy is needed. One can expect peaks to be separated
* by of order the velocity resolution in Gamma, Kx, and Ky so this should
* give some idea of suitable values. However, it would probably be best to
* experiment with different grid sizes until the results do not change.
* The variation in Vsini is likely to less complex and just a few points 
* will probably do if you really have to vary it. 
*
* The search in period is made in frequency because constant step sizes are
* more suited to frequency as the following considerations show. If you have
* observations spread over a baseline T then you should step in frequency such 
* that the relative phases of start and end do not alter by more than FRAC of 
* a cycle (FRAC=0.1 is a plausible choice). You then require a frequency 
* stepsize of FRAC/T cycles/day, and therefore NFR = (FRHI-FRLO)*T/FRAC is 
* about the right order of mag. This can still give large values e.g. a 3 day 
* run with 1 spectrum/half hour would give T=2 days, FRLO=0.25 (no point 
* looking lower than 0.5 cycles over the whole run), FRHI=24 (Nyquist 
* frequency), and so NFR = 500. Obviously FRAC and FRHI are quite important
* here and you may wish to experiment. Any information on the period from
* other sources could be a great help.
*
* The zero point of the orbital phase is loaded from the D header parameter
* HJDO or from the first HJD if the former is not found.
*ORBIT                                                                
*ORBER
* ORBER not working
*ORBER
      SUBROUTINE ORBFIT(SPLIT, NSPLIT, MXSPLIT, METHOD, IFAIL)
*
* Cross-correlate spectra. Unusual in that most arguments are passed by common
* because this uses an AMOEBA routine which needs common blocks.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  I     IFAIL            -- Error return.
*
      IMPLICIT NONE
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NPMX
      PARAMETER (NPMX=5)
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*(*) METHOD
*
* Include main molly arrays
*
      INCLUDE 'molly.coms'
*
* FIGARO stuff
*
      INCLUDE 'DYNAMIC_MEMORY'
      INTEGER AXPTR, DPTR, DIMS(NPMX), NDIMS, NDAT
      INTEGER ADDRESS, SLT, K1, K2, K3, K4, K5
      INTEGER DYN_ELEMENT
      CHARACTER*10 CARR(2)
*
* Local variables
*
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4, IFAIL, NOPT
      INTEGER NFIX, NSTP, NEED
      INTEGER MAXSPEC, NCOM, I, J, K, END
      INTEGER NST(NPMX), NL(NPMX), JL(NPMX), JF(NPMX)
      INTEGER I1, I2, I3, I4, I5, SLOT, IW(2), LW
      REAL VX, VY, SS, ACC
      LOGICAL SAMECI, DEFAULT, WARN
      DOUBLE PRECISION PLO(NPMX), PHI(NPMX), FC, GC(NPMX)
      DOUBLE PRECISION PAR(NPMX)
      DOUBLE PRECISION PMAX(NPMX), PRMAX(NPMX,NPMX), PERIOD
      DOUBLE PRECISION PROB, WD(7*NPMX+NPMX*(NPMX-1)/2)
      DOUBLE PRECISION LLIM(NPMX), ULIM(NPMX)
      REAL VLIGHT, CGS
      CHARACTER*5 FIX, NAMES(5)
      CHARACTER*3 SET
      CHARACTER*64 FILE
*
* Functions
*
      EXTERNAL BAYES
*
      INTEGER SXC1, SXC2, MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST1, LIST1(2,MXLIST)
      INTEGER NLIST2, LIST2(2,MXLIST)
*
* Common blocks etc for BAYES
*
      INTEGER MXMASK, MXMASK1, NPMASK, NWMASK, NVMASK, PMASK
      PARAMETER (MXMASK=50)
      REAL WMASK, VMASK
      COMMON/BAYES1/MXMASK1, NPMASK, NWMASK, NVMASK
      COMMON/BAYES2/PMASK(2,MXMASK)
      COMMON/BAYES3/WMASK(2,MXMASK)
      COMMON/BAYES4/VMASK(3,MXMASK)
*
      INTEGER STATUS, NSPEC, NTEMP, NCMAX
      INTEGER START, OPTION
      REAL EPS, TAPER, FLO, FHI, VMAX
      DOUBLE PRECISION SPAR
      LOGICAL FREE, RESET
      COMMON/BAYES5/RESET, FREE(5)
      COMMON/BAYES6/SPAR(5)
      COMMON/BAYES7/STATUS,NCMAX,START,OPTION
      COMMON/BAYES8/EPS,TAPER,FLO,FHI,VMAX
      COMMON/BAYES9/NSPEC,NTEMP
*
*
      DATA SPAR/0.D0, 0.D0, 0.D0, 1.D-1, 0./
      DATA NAMES/'Kx   ','Ky   ','Gamma','Freq ','Vsini'/
      DATA SLOT1, SLOT2, SLOT3, SLOT4/1,1,2,2/
      DATA TAPER, EPS, FLO, FHI, OPTION/0.03, 0.5, 0., 1., 1/
      DATA SET/'y'/
      DATA FIX/'22111'/
      DATA PLO/-1000., -1000., -250., 0.1,   0./
      DATA PHI/+1000., +1000., +250., 30., 200./
      DATA NST/   50,    50,      10, 500,  10/
      DATA ACC/1.E-4/
*
      LW = 7*NPMX+NPMX*(NPMX-1)/2
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM    = 0
      IFAIL   = 0
      MXMASK1 = MXMASK
*
      CALL INTR_IN('First target spectrum', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last target spectrum', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        WRITE(*,*) 'Enter list of spectra to X-correlate'
        CALL GETLIS(LIST1, NLIST1, MXLIST, MAXSPEC, ISLOT, 
     &  NSPEC, MXSLOT)
        IF(NSPEC.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST1, NLIST1, MXLIST, ISLOT, 
     &  NSPEC, MXSLOT)
      END IF
*
      CALL INTR_IN('First template spectrum', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      SLOT4 = MAX(SLOT3, SLOT4)
      CALL INTR_IN('Last template spectrum', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT3.EQ.0 .AND. SLOT4.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT3.EQ.0 .AND. SLOT4.EQ.0) THEN
        WRITE(*,*) 'Enter list of template spectra'
        CALL GETLIS(LIST2, NLIST2, MXLIST, MAXSPEC, 
     &  ISLOT(MXSLOT+1), NTEMP, MXSLOT)
        IF(NTEMP.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT3, SLOT4, LIST2, NLIST2, MXLIST, 
     &  ISLOT(MXSLOT+1), NTEMP, MXSLOT)
      END IF
      IF(NTEMP.NE.1 .AND. NTEMP.NE.NSPEC) THEN
        WRITE(*,*) 'Must have either a single template spectrum'
        WRITE(*,*) 'or same number as objects'
        GOTO 999
      END IF
*
* Check through spectra
*
      VLIGHT = CGS('C')/1.E5
      DO I = 1, NSPEC
        SXC1 = ISLOT(I)
        SXC2 = ISLOT(MXSLOT+MIN(I,NTEMP))
        IF( NPIX(SXC1).LE.0) THEN 
          WRITE(*,*) 'Object slot ',SXC1,' empty.'
          GOTO 999
        ELSE IF( NPIX(SXC2).LE.0) THEN 
          WRITE(*,*) 'Template slot ',SXC2,' empty.'
          GOTO 999
        ELSE IF(NPIX(SXC1).NE.NPIX(SXC2)) THEN
          WRITE(*,*) 'Object ',SXC1,', template ',SXC2,
     &    ' have different'
          WRITE(*,*) 'numbers of pixels.'
          GOTO 999
        ELSE
          IF(NARC(SXC1).NE.-2 .OR. NARC(SXC2).NE.-2) THEN
            WRITE(*,*) 'Object and/or template not on a logarithmic'
            WRITE(*,*) 'scale.'
            GOTO 999
          END IF
          WARN = .FALSE.
          DO J = 1, ABS(NARC(SXC1))
            WARN = WARN .OR. 
     &      ABS(ARC(MXARC*(SXC1-1)+J)-ARC(MXARC*(SXC2-1)+J))
     &      .GT.1.D-5*ARC(MXARC*(SXC1-1)+J)
          END DO
          IF(WARN) THEN
            WRITE(*,*) 'Object and template are on different wavelength'
            WRITE(*,*) 'scales.'
            GOTO 999
          END IF
        END IF
      END DO
*
      CALL CHAR_IN('5 digit binary, 0=free,1=fix,2=step. XYGFV',
     &SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FIX, IFAIL)
      NOPT  = 0
      NSTP  = 0
      NFIX  = 0
      DO I = 1, 5
        IF(FIX(I:I).EQ.'0') THEN
          NOPT = NOPT + 1
          FREE(I) = .TRUE.
        ELSE IF(FIX(I:I).EQ.'1') THEN         
          NFIX = NFIX + 1
          FREE(I)  = .FALSE.
        ELSE IF(FIX(I:I).EQ.'2') THEN         
          NSTP = NSTP + 1
          FREE(I)  = .FALSE.
        ELSE
          WRITE(*,*) 'Must enter only 0s, 1s or 2s'
          FIX = '22111'
          GOTO 999
        END IF
      END DO
      WRITE(*,*) NOPT,' parameters will be optimised.'
      WRITE(*,*) NFIX,' parameters held fixed.'
      WRITE(*,*) NSTP,' parameters stepped.'
*
* Now load parameter value or search ranges.
*
* 1 = Kx
* 2 = Ky
* 3 = Gamma
* 4 = Frequency
* 5 = Vsini
*
      IF(FIX(1:1).EQ.'1') THEN
        CALL DOUB_IN('Kx (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, SPAR(1), -1.D4, 1.D4, IFAIL)
        VX = ABS(SPAR(1))
      ELSE
        CALL DOUB_IN('Kx lower limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PLO(1), -1.D4, 1.D4, IFAIL)
        PHI(1) = MAX(PLO(1), PHI(1))
        CALL DOUB_IN('Kx upper limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PHI(1), PLO(1), 1.D4, IFAIL)
        CALL INTR_IN('Kx num steps', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, NST(1), 1, 10000, IFAIL)
        VX = MAX(ABS(PLO(1)),ABS(PHI(1)))
      END IF
      IF(FIX(2:2).EQ.'1') THEN
        CALL DOUB_IN('Ky (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, SPAR(2), -1.D4, 1.D4, IFAIL)
        VY = ABS(SPAR(2))
      ELSE
        CALL DOUB_IN('Ky lower limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PLO(2), -1.D4, 1.D4, IFAIL)
        PHI(2) = MAX(PLO(2), PHI(2))
        CALL DOUB_IN('Ky upper limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PHI(2), PLO(2), 1.D4, IFAIL)
        CALL INTR_IN('Ky num steps', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, NST(2), 1, 10000, IFAIL)
        VY = MAX(ABS(PLO(2)),ABS(PHI(2)))
      END IF
      IF(FIX(3:3).EQ.'1') THEN
        CALL DOUB_IN('Gamma (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, SPAR(3), -1.D4, 1.D4, IFAIL)
        VMAX = ABS(SPAR(3))
      ELSE
        CALL DOUB_IN('Gamma lower limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PLO(3), -1.D4, 1.D4, IFAIL)
        PHI(3) = MAX(PLO(3), PHI(3))
        CALL DOUB_IN('Gamma upper limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PHI(3), PLO(3), 1.D4, IFAIL)
        CALL INTR_IN('Gamma num steps', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, NST(3), 1, 10000, IFAIL)
        VMAX = MAX(ABS(PLO(3)), ABS(PHI(3)))
      END IF
      VMAX = 1.1*(VMAX + SQRT(VX**2+VY**2))
*
* We can now compute an upper limit on the space 
* needed to store the cross-correlation functions and
* the spline interpolation second derivatives.
* NCMAX and START are passed through to BAYES by common
*
      NCMAX = 0
      DO I = 1, NSPEC
        SLOT  = ISLOT(I)
        NCMAX = MAX( NCMAX, 2*(INT(VMAX/VLIGHT/
     &  ABS(SNGL(ARC(MXARC*(SXC1-1)+2)))*
     &  REAL(NPIX(SLOT))+1.)+1))
      END DO
      NEED = (2*NSPEC*NCMAX)/MAXPX+1
*
* Now search for sufficient space in spare spectrum space
*
      START = 1
      END   = 0
      I     = 0
      DO WHILE(I.LT.MAXSPEC .AND. END-START+1.LT.NEED)
        I = I + 1
        IF(NPIX(I).EQ.0 .AND. END.EQ.0) THEN
          START = I
          END   = I
        ELSE IF(NPIX(I).EQ.0) THEN
          END   = I
        ELSE
          START = 1
          END   = 0
        END IF
      END DO
      IF(END-START+1 .LT. NEED) THEN
        WRITE(*,*) 'Need ',NEED,' empty spectrum slots in order'
        WRITE(*,*) 'to store X-correlations, but these cannot be'
        WRITE(*,*) 'found. Better clear some space.'
        GOTO 999
      END IF
      START = MAXPX*(START-1)
*
      IF(FIX(4:4).EQ.'1') THEN
        CALL HGETD('PeriodO', PERIOD, ISLOT(1), MXSPEC, NMDOUB, 
     &  HDDOUB, NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.EQ.0) SPAR(4) = 1./PERIOD
        IFAIL = 0
        CALL DOUB_IN('Frequency (cyc/day)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, SPAR(4), 0.D0, 1.D3, IFAIL)
      ELSE
        CALL DOUB_IN('Freq lower limit (cyc/day)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PLO(4), 0.D0, 1.D3, IFAIL)
        PHI(4) = MAX(PLO(4), PHI(4))
        CALL DOUB_IN('Freq upper limit (cyc/day)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PHI(4), PLO(4), 1.D3, IFAIL)
        CALL INTR_IN('Freq num steps', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, NST(4), 1, 10000, IFAIL)
      END IF
      IF(FIX(5:5).EQ.'1') THEN
        CALL DOUB_IN('Vsini (km/s)', SPLIT, NSPLIT, MXSPLIT, 
     &  NCOM, DEFAULT, SPAR(5), 0.D0, 5.D3, IFAIL)
      ELSE
        CALL DOUB_IN('Vsini lower limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PLO(5), 0.D0, 5.D3, IFAIL)
        PHI(5) = MAX(PLO(5), PHI(5))
        CALL DOUB_IN('Vsini upper limit (km/s)', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, PHI(5), PLO(5), 5.D3, IFAIL)
        CALL INTR_IN('Vsini num steps', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, NST(5), 1, 10000, IFAIL)
      END IF
*
      CALL REAL_IN('Taper fraction', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, TAPER, 0., 0.5, IFAIL)
      CALL REAL_IN('Limb darkening coefficient', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, EPS, 0., 1., IFAIL)
      CALL INTR_IN('Bayes option (1 or 2)', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, OPTION, 1, 2, IFAIL)
      CALL REAL_IN('Lower limit on f', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, FLO, -1.E10, 1.E10, IFAIL)
      FHI = MAX(FLO, FHI)
      CALL REAL_IN('Upper limit on f', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, FHI, FLO, 1.E10, IFAIL)
      FILE = ' '
      IF(NSTP.GT.0) THEN
        CALL CHAR_IN('File to store (<CR> terminal only)', 
     &  SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      END IF
*
* Mask
*
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &DEFAULT, SET, IFAIL)
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'Mask regions not wanted in X-corr.'
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, 
     &        MAXPX, NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, 
     &        NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &        HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &        MXDOUB, MXINTR, MXREAL, RWORK, RWORK(MXWORK+1), 
     &        RWORK(2*MXWORK+1), MXWORK, LWORK)
      END IF
*
* Force routine to start from sratch rather than try to retrieve
* previously stored info. RESET is automatically set to .FALSE.
* inside BAYES.
*
      RESET = .TRUE.        
*
* We search over the grid. The parameters to be optimised are
* in the inner-most loops and each time the full suite has been
* run through, they will be optimised. The outer loops then run
* over the remaining parameters. VSINI is always made as outermost
* as possible since changing VSINI causes lots of extra work.
*
* First set the innermost optimising loops. Note that since Vsini
* is parameter 5 it must end up as the outermost of these loops
* if included at all.
*
      K = 0
      DO I = 1, 5     
        IF(FIX(I:I).EQ.'0') THEN
          K = K + 1
          NL(K) = NST(I)
          JL(K) = I
          JF(I) = K
          LLIM(K) = PLO(I)
          ULIM(K) = PHI(I)
        END IF
      END DO
*
* Next set the stepping loops
*
      DO I = 1, 5
        IF(FIX(I:I).EQ.'2') THEN
          K = K + 1
          NL(K) = NST(I)
          JL(K) = I
        END IF
      END DO
*
* Finally set the fixed "loops" which of course only go through
* one value
*
      DO I = 1, 5
        IF(FIX(I:I).EQ.'1') THEN
          K = K + 1
          NL(K) = 1
          JL(K) = I
        END IF
      END DO
*
* Grid search. At start of each loop we update parameters, either
* in PAR which gets passed by argument to BAYES or in SPAR which
* gets passed by COMMON. The array FREE set earlier determines
* where BAYES gets its parameters from.
*
* Optimisation should occur at the calls to 'PARROT'
*
*
* Open FIGARO file for writing
*
      IF(FILE.NE.' ') THEN   
        CALL DSA_OPEN(IFAIL)
        CALL DSA_NAMED_OUTPUT('FIG', FILE, ' ', 0, 0, IFAIL)
        NDIMS = NSTP
        K = 0
        NDAT = 1
        DO I = 1, 5
          IF(FIX(I:I).EQ.'2') THEN
            K = K + 1
            DIMS(K) = NST(I)
            NDAT = NDAT*NST(I)
          END IF
        END DO
        CALL DSA_SIMPLE_OUTPUT('FIG', 'DATA', 'FLOAT', NDIMS, 
     &  DIMS, IFAIL)
        K = 0
        DO I = 1, 5
          IF(FIX(I:I).EQ.'2') THEN
            K = K + 1
            CALL DSA_COERCE_AXIS_DATA('FIG',K,'FLOAT',1,NST(I),IFAIL)
            IF(I.EQ.1 .OR. I.EQ.2 .OR. I.EQ.3 .OR. I.EQ.5) THEN
              CARR(1) = 'km/s'
            ELSE
              CARR(1) = 'cycles/day'
            END IF
            IF(I.EQ.1) THEN
              CARR(2) = 'K\\dX\\u'
            ELSE IF(I.EQ.2) THEN
              CARR(2) = 'K\\dY\\u'
            ELSE IF(I.EQ.3) THEN
              CARR(2) = '\\gg'
            ELSE IF(I.EQ.4) THEN
              CARR(2) = 'Frequency'
            ELSE IF(I.EQ.5) THEN
              CARR(2) = 'V sin i'
            END IF
            CALL DSA_SET_AXIS_INFO('FIG',K,2,CARR,0,0.D0,IFAIL)
            CALL DSA_MAP_AXIS_DATA('FIG',K,'WRITE','FLOAT',
     &      ADDRESS,SLT,IFAIL)
            AXPTR = DYN_ELEMENT(ADDRESS)
            CALL SET_AX(DYNAMIC_MEM(AXPTR), NST(I), REAL(PLO(I)), 
     &      REAL(PHI(I)))
          END IF
        END DO
        CALL DSA_MAP_DATA('FIG','WRITE','FLOAT',ADDRESS,SLT,IFAIL)
        DPTR = DYN_ELEMENT(ADDRESS)
      END IF
*
      PMAX(5) = - 1.D30
      K1 = 0
      K2 = 0
      K3 = 0
      K4 = 0
      K5 = 0
      DO I5 = 1, NL(5)
        CALL GTPAR(FIX,PAR,SPAR,PLO,PHI,I5,JL(5),JF(5),NL(5))
        PMAX(4) = - 1.D30
        K5 = K5 + 1
        DO I4 = 1, NL(4)
          CALL GTPAR(FIX,PAR,SPAR,PLO,PHI,I4,JL(4),JF(4),NL(4))
          PMAX(3) = - 1.D30
          K4 = K4 + 1
          DO I3 = 1, NL(3)
            CALL GTPAR(FIX,PAR,SPAR,PLO,PHI,I3,JL(3),JF(3),NL(3))
            PMAX(2) = - 1.D30
            K3 = K3 + 1
            DO I2 = 1, NL(2)
              CALL GTPAR(FIX,PAR,SPAR,PLO,PHI,I2,JL(2),JF(2),NL(2))
              PMAX(1) = - 1.D30
              K2 = K2 + 1
              DO I1 = 1, NL(1)
                CALL GTPAR(FIX,PAR,SPAR,PLO,PHI,I1,JL(1),JF(1),NL(1))
                K1 = K1 + 1
                CALL BAYES(1, NOPT, PAR, FC, GC, IW, 2, WD, LW)
                PROB = - FC
                IF(STATUS.NE.0) THEN
                  WRITE(*,*) 'Error in BAYES ',STATUS
                  GOTO 999
                END IF
*
* Keep track of the max prob and parameter values 
* that point for all loop levels
*
                DO I = 1, 5
                  IF(PROB.GT.PMAX(I)) THEN
                    PMAX(I) = PROB
                    DO J = 1, NOPT
                      PRMAX(J,I) = PAR(J)
                    END DO
                  END IF
                END DO
                IF(NOPT.EQ.0 .AND. FILE.NE.' ') THEN
                  CALL STAWY(DYNAMIC_MEM(DPTR), NDAT, K1, 
     &            REAL(PROB))
                END IF
              END DO
              IF(NOPT.EQ.1) THEN
                WRITE(*,*) ' '
                CALL PARROT(NAMES,FIX,PMAX(1),SPAR,PRMAX(1,1))
                CALL BYINT1(PAR, LLIM, ULIM, SS, PMAX(1), ACC)
                IF(SS.GT.0) 
     &          WRITE(*,*) 'LOG10(Integral) = ',LOG10(SS)+PMAX(1)
                IF(FILE.NE.' ') CALL STAWY(DYNAMIC_MEM(DPTR), 
     &          NDAT, K2, REAL(PMAX(1)))
              END IF
            END DO
            IF(NOPT.EQ.2) THEN
              WRITE(*,*) ' '
              CALL PARROT(NAMES,FIX,PMAX(2),SPAR,PRMAX(1,2))
              CALL BYINT2(PAR, LLIM, ULIM, SS, PMAX(2), ACC)
              IF(SS.GT.0) 
     &        WRITE(*,*) 'LOG10(Integral) = ',LOG10(SS)+PMAX(2)
              IF(FILE.NE.' ') CALL STAWY(DYNAMIC_MEM(DPTR), 
     &        NDAT, K3, REAL(PMAX(2)))
            END IF
          END DO
          IF(NOPT.EQ.3) THEN
            WRITE(*,*) ' '
            CALL PARROT(NAMES,FIX,PMAX(3),SPAR,PRMAX(1,3))
            CALL BYINT3(PAR, LLIM, ULIM, SS, PMAX(3), ACC)
            IF(SS.GT.0) 
     &      WRITE(*,*) 'LOG10(Integral) = ',LOG10(SS)+PMAX(3)
            IF(FILE.NE.' ') CALL STAWY(DYNAMIC_MEM(DPTR), 
     &      NDAT, K4, REAL(PMAX(3)))
          END IF
        END DO
        IF(NOPT.EQ.4) THEN
          WRITE(*,*) ' '
          CALL PARROT(NAMES,FIX,PMAX(4),SPAR,PRMAX(1,4))
          IF(FILE.EQ.' ') CALL STAWY(DYNAMIC_MEM(DPTR), 
     &    NDAT, K5, REAL(PMAX(4)))
        END IF
      END DO
      IF(NOPT.EQ.5) THEN
        WRITE(*,*) ' '
        CALL PARROT(NAMES,FIX,PMAX(5),SPAR,PRMAX(1,5))
      END IF 
      IFAIL = 0
      IF(FILE.NE.' ') CALL DSA_CLOSE(IFAIL)
999   RETURN
      END

      SUBROUTINE BAYES(IFLAG, NPAR, PAR, FC, IW, LIW, W, LW)
*
* BAYES computes the natural log of the Bayesian probability as specified
* by Marsh (1994) given the parameter array PAR(5) where 
*
* PAR(1) = Kx     (km/s). Semi-amp of - Cos component of RV
* PAR(2) = Ky     (km/s). Semi-amp of   Sin component of RV
* PAR(3) = gamma  (km/s). Systemic velocity.
* PAR(4) = Period (days). Orbital period.
* PAR(5) = Vsini  (km/s). Rotational broadening to be applied to templates.
*
* Not all of these may be used however.
*
* IFLAG = 1 just computes FC, IFLAG = 2 computes GC as well.
*
* The majority of communication to this routine is through common blocks.
*
* The spectra and templates should have the same wavelength scales, and
* they should be logarithmic
*
      IMPLICIT NONE
      INTEGER NPAR, IFLAG, LW, LIW, IW(LIW)
      DOUBLE PRECISION PAR(5), FC, W(LW)
*
* Local variables
*               
      INTEGER SPEC, TEMP, J, M1, M2, N, NL
      INTEGER IS, I, L, NMID, NR
      INTEGER NBLURR, NF,NLIM, IST, K, IT, CYCLE
      REAL VSOLD, GAMMA, KX, KY, VSINI, X, VS, COF
      REAL GET_FLX, GET_ERF, VEL, VAVE, VLIGHT, CGS
      REAL PI, TWOPI, XI, YI, IY2, F, XCOR
      REAL WGT
      DOUBLE PRECISION FREQ, ANGST, W1, W2, VEARTH, FAC
      DOUBLE PRECISION HJD, HJDO, PHASE, SUM, DX1, DX2
      DOUBLE PRECISION SUM1, SUM2, SUM3, SUM4, LGAUSS
      DOUBLE PRECISION FOLD, CP, SP
      LOGICAL FIRST, CHANGE, PALTER
*
* Commons containing data, work arrays and header parameters
*
      INCLUDE 'molly.coms'
*
* Common blocks special to 'BAYES'
*
* OPTION -- Bayes parameter.
*           1 = Independent f-values
*           2 = Single f-value (Smith skew map)
*
* START  -- Pixel in data arrays where storage can start
* NCMAX  -- Maximum length of Xcorr array. For each spectrum
*           various xcor arrays are stored and for each one
*           an array of the same length of second derivs for splines
* FLO, FHI - Prior range of f-value
* GAMMA,KX,KY,VSINI,PERIOD -- Parameters passed separately if fixed
* EPS    -- Limb darkening param
* FREE   -- Array to say which params are fixed and which are free
* TAPER  -- Amount to taper at ends of array
* VMAX   -- Maximum shift in velocity to xcorr over.
* NSPEC  -- Number of spectra
* NTEMP  -- Number of templates (either = 1 or NSPEC)
*
      INTEGER MXMASK, NPMASK, NWMASK, NVMASK, PMASK
      INTEGER IFAIL, NSPEC, NTEMP, NCMAX, START, OPTION
      REAL WMASK, VMASK, EPS, TAPER
      REAL FLO, FHI, VMAX, XX
      DOUBLE PRECISION SPAR
      LOGICAL RESET, FREE
      COMMON/BAYES1/MXMASK, NPMASK, NWMASK, NVMASK
      COMMON/BAYES2/PMASK(1)
      COMMON/BAYES3/WMASK(1)
      COMMON/BAYES4/VMASK(1)
      COMMON/BAYES5/RESET, FREE(5)
      COMMON/BAYES6/SPAR(5)
      COMMON/BAYES7/IFAIL,NCMAX,START,OPTION
      COMMON/BAYES8/EPS,TAPER,FLO,FHI,VMAX
      COMMON/BAYES9/NSPEC,NTEMP
      INCLUDE 'maxsinc.inc'
      DATA VSOLD, FOLD/-100., -1.D2/
      DATA FIRST/.TRUE./
*
* Initialise speed of light in km/s and PI
*
      IF(FIRST) THEN
        VLIGHT = CGS('C')/1.E5
        TWOPI  = 8.*ATAN(1.)
        PI     = TWOPI/2.
        FIRST  = .FALSE.
      END IF
      M1     = MAXPX
      M2     = 2*MAXPX
*
* Set parameter values
*
      I = 0
      IF(FREE(1)) THEN
        I = I + 1
        KX = PAR(I)
      ELSE
        KX = SPAR(1)
      END IF
      IF(FREE(2)) THEN
        I = I + 1
        KY = PAR(I)
      ELSE
        KY = SPAR(2)
      END IF
      IF(FREE(3)) THEN
        I = I + 1
        GAMMA = PAR(I)
      ELSE
        GAMMA = SPAR(3)
      END IF
      IF(FREE(4)) THEN
        I = I + 1
        FREQ = PAR(I)
      ELSE
        FREQ = SPAR(4)
      END IF
      IF(FREE(5)) THEN
        I = I + 1
        VSINI = PAR(I)
      ELSE
        VSINI = SPAR(5)
      END IF
*
* Of all parameters, changes in Vsini are the most devastating in
* terms of speed since the broadening and the X-correlations need
* to be recomputed. This is not the case for any other parameter.
* Set flag to indicate whether Vsini has changed enough to require
* recomputation. RESET can be set externally to force update of xcorrs.
* PALTER to show whether phases etc need to be recomputed.
*
      CHANGE = RESET .OR. ABS(VSINI-VSOLD).GT.1.E-5*VSINI
      PALTER = RESET .OR. ABS(FREQ-FOLD).GT.1.D-7
      RESET  = .FALSE.
      VSOLD = VSINI
*
* List of spectra slots contained in ILIST arrays
*
      SUM  = 0.D0
      SUM1 = 0.D0
      SUM2 = 0.D0
      DO I = 1, NSPEC
*
* Get indices needed to locate spectra in 1D arrays
*
        SPEC = ISLOT(I)
        IF(NTEMP.EQ.1) THEN
          TEMP = ISLOT(MXSLOT+1)
        ELSE
          TEMP = ISLOT(MXSLOT+I)
        END IF
        IS   = MAXPX*(SPEC-1)
        IT   = MAXPX*(TEMP-1)
*
        IF(PALTER) THEN
*
* Compute orbital phase and radial velocity. Use HJDO if set
* as zero point of orbital phase, else use the HJD of the first
* spectrum.
*
          CALL HGETD('HJD', HJD, SPEC, MXSPEC, NMDOUB, 
     &    HDDOUB, NDOUB, MXDOUB, IFAIL)
          IF(IFAIL.NE.0) GOTO 999
          IF(I.EQ.1) THEN
            CALL HGETD('ZeroO', HJDO, SPEC, MXSPEC, NMDOUB, 
     &      HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) HJDO = HJD
            IFAIL = 0
          END IF
          PHASE = FREQ*(HJD-HJDO)
          PHASE = TWOPI*(PHASE - DBLE(NINT(PHASE)))
          CP    = COS(PHASE)
          SP    = SIN(PHASE)
          K = M2 + 2*I - 1
          DWORK(K  ) = CP
          DWORK(K+1) = SP
        ELSE
*
* If period has not changed, we will normally start here
*
          K = M2 + 2*I - 1
          CP = DWORK(K  ) 
          SP = DWORK(K+1) 
        END IF
        VEL   = GAMMA - KX*CP + KY*SP
*
* Lots of computations required if VSINI has changed.
*
        IF(CHANGE) THEN
*
* Wavelength range and velocity/pixel, compute NR such that the
* range of pixels shifts to be used will be -NR to NR
*
          W1 = ANGST(1.,NPIX(SPEC),NARC(SPEC),
     &    ARC(MXARC*(SPEC-1)+1),MXARC)
          W2 = ANGST(REAL(NPIX(SPEC)),NPIX(SPEC),NARC(SPEC),
     &    ARC(MXARC*(SPEC-1)+1),MXARC)
          VAVE = VLIGHT*(EXP(LOG(W2/W1)/REAL(NPIX(SPEC)-1))-1.)
          NR   = INT(ABS(VMAX/VAVE))+1
          RSLOT(I) = VAVE
*
* Broaden template if necessary
*
          IF(VSINI.GT.1.E-4*ABS(VAVE) .AND. (I.EQ.1 .OR. 
     &    (NTEMP.NE.1 .AND. TEMP.NE.ISLOT(MXSLOT+
     &    MAX(I-1,NTEMP)))) ) THEN
*
* Compute blurring width 
*
            NBLURR = 2*INT(ABS(VSINI/VAVE)+REAL(MAXSINC)+0.5)+1
            IF(NBLURR.GT.MXWORK) THEN
             WRITE(*,*) 'Too large a blurr for workspace in BAYES'
             GOTO 999
            END IF
*
* Compute blurr array
*
            SUM3 = 0.D0
            DO J = 1, NBLURR
              X  = REAL(J-NBLURR/2-1)
              VS = ABS(VSINI/VAVE)
              CALL BRCOFF(X,VS,EPS,2,COF,IFAIL)
              DWORK(J) = COF
              SUM3 = SUM3 + DWORK(J)
            END DO         
*
* Normalise
*  
            DO J = 1, NBLURR
              DWORK(J) = DWORK(J)/SUM3
            END DO
*
* Load template
*
            DO J = 1, NPIX(TEMP)
              K = IT+J
              RWORK(J) = GET_FLX(COUNTS(K),FLUX(K))
              DWORK(J+M1) = 0.D0
            END DO
*
* Now blurr, extending the template at ends as though 
* its value was constant
*
            NMID = NBLURR/2
            DO J = 1-NBLURR, NPIX(TEMP)+NBLURR
              F = RWORK(MAX(1,MIN(J,NPIX(TEMP))))
              DO K = MAXPX+MAX(1,J-NMID), 
     &               MAXPX+MIN(NPIX(SPEC),J+NMID)
                L = K - J + NMID + 1 - MAXPX
                DWORK(K) = DWORK(K) + DWORK(L)*F
              END DO
            END DO
*
* Store in RWORK(*,3)
*
            DO J = 1, NPIX(TEMP)
              RWORK(M2+J) = DWORK(M1+J)
            END DO
          ELSE IF(VSINI.LE.1.E-4*ABS(VAVE)) THEN
*
* No broadning, do nothing except retrieve template
*
            DO J = 1, NPIX(TEMP)
              K = IT+J
              RWORK(M2+J) = GET_FLX(COUNTS(K),FLUX(K))
            END DO
*
          ELSE 
*
* Recover from previous computation 
*
            DO J = 1, NPIX(TEMP)
             RWORK(M2+J) = DWORK(M1+J)
            END DO
          END IF
*
* Now compute cross-correlation sums.
* X = sum W S T(V) and Y = sum W T**2(V) 
* over the maximum range passed by common
*
*
* Get spectrum
*
          DO J = 1, NPIX(SPEC)
            K = IS + J
            RWORK(   J) = GET_FLX(COUNTS(K), FLUX(K))
            RWORK(M1+J) = GET_ERF(COUNTS(K), ERRORS(K), FLUX(K))
          END DO
*
* Load arc
*
          CALL HGETD('Vearth', VEARTH, SPEC, MXSPEC, NMDOUB, 
     &    HDDOUB, NDOUB, MXDOUB, IFAIL)
          IFAIL = 0
*
* Get mask (assumed to be the same for every object and template)
*
          CALL APPMASK(LWORK,NPIX(SPEC),ARC(MXARC*(SPEC-1)+1),
     &    NARC(SPEC),MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,
     &    NVMASK,MXMASK,.TRUE.,VEARTH,IFAIL)
*
* Apply mask by making error array negative
*
          NF = 0
          NL = 0
          DO J = 1, NPIX(SPEC)
            IF(LWORK(J) .OR. ERRORS(IS+J).LE.0.) THEN
              K = M1+J
              RWORK(K) = -ABS(RWORK(K))
            ELSE 
              IF(NF.EQ.0) NF = J
              NL = J
            END IF
          END DO
*
* Taper front end
*
          NLIM = NF + INT(TAPER*REAL(NPIX(SPEC)))
          NLIM = MIN(NLIM, NL)
          DO J = NF, NLIM
            FAC = (1.-COS(PI*REAL(J-NF)/REAL(NPIX(SPEC))/TAPER))/2.
            RWORK(J) = FAC*RWORK(J)
            K = M2+J
            RWORK(K) = FAC*RWORK(K)
          END DO
*
* Taper back end
*
          NLIM = NL - INT(TAPER*REAL(NPIX(SPEC)))
          NLIM = MAX(NLIM, NF)
          DO J = NLIM, NL
            FAC = (1.-COS(PI*REAL(J-NL)/REAL(NPIX(SPEC))/TAPER))/2.
            RWORK(J) = FAC*RWORK(J)
            K = M2+J
            RWORK(K) = FAC*RWORK(K)
          END DO
*
* Now have corrected spectra. Compute cross-correlation for
* velocity shifts covering range -NR to +NR shifts
*
          CYCLE = 0
100       CONTINUE
          CYCLE = CYCLE + 1
          DO N = -NR, NR
            SUM3 = 0.D0
            SUM4 = 0.D0
            DO J = MAX(NF,NF+N), MIN(NL, NL+N)
              K = M1 + J
              IF(RWORK(K).GT.1.E-10) THEN
                L = M2 + J - N
                WGT  = 1./RWORK(K)**2
                SUM3 = SUM3 + WGT*RWORK(L)**2
                SUM4 = SUM4 + WGT*RWORK(J)*RWORK(L)
              END IF
            END DO
            FAC = SQRT(SUM3)
            DX1 = -SUM4/FAC+FLO*FAC
            DX2 = -SUM4/FAC+FHI*FAC
            FAC = LGAUSS(DX1,DX2)-LOG(FAC)
*
* Compute pointer to storage arrays. The factor
* of 2 is to allow for the spline interpolation array
* to be computed following this loop.
*
* SUM3 = Y in the notation of Marsh (1994)
* SUM4 = X, FAC = ln phi - 0.5*ln Y
*
            IST = START+2*NCMAX*(I-1)+NR+N+1
            IF(OPTION.EQ.1) THEN
              FLUX(IST)   = SUM4**2/SUM3/2.+FAC
            ELSE IF(OPTION.EQ.2) THEN
              FLUX(IST)   = SUM4
              COUNTS(IST) = SUM3
            END IF
          END DO
*
* Spline interpolation second derivative computation.
* Second derivs stored immediately after Xcor arrays
*
          IST = START+2*NCMAX*(I-1)+1
          N = 2*NR+1
          IF(OPTION.EQ.1) THEN
            CALL SPLSET(FLUX(IST),N,RWORK(3*MAXPX+1),
     &      FLUX(IST+NCMAX))
          ELSE IF(OPTION.EQ.2) THEN
            CALL SPLSET(FLUX(IST),N,RWORK(3*MAXPX+1),
     &      FLUX(IST+NCMAX))
            CALL SPLSET(COUNTS(IST),N,RWORK(3*MAXPX+1),
     &      COUNTS(IST+NCMAX))
          END IF
        ELSE
*
* Retrieve VAVE from previous pass
*
          VAVE = RSLOT(I) 
          NR   = INT(ABS(VMAX/VAVE))+1
        END IF
*
* Cross-correlation sums have been computed and stored
* at this stage. Normally we will be skipping over the
* previous part and jump to here. We need to interpolate
* the arrays for the particular velocity and spectrum in
* question. XX is the number of pixels from 0 (NB VAVE
* can be negative). 
*
        XX = VEL/VAVE 
        IF(ABS(XX).GT.REAL(NR))
     &  WRITE(*,*) 'Velocity out of range of stored Xcorrs'
        IST = START+2*NCMAX*(I-1)+1
*
* Cubic spline interpolation from numerical recipes. 
*
        IY2 = IST+NCMAX
        XX  = REAL(NR+1)+XX
        N   = 2*NR+1
        IF(OPTION.EQ.1) THEN
          CALL SPLY(FLUX(IST),FLUX(IY2),N,XX,XCOR)
        ELSE IF(OPTION.EQ.2) THEN
          CALL SPLY(FLUX(IST),FLUX(IY2),N,XX,XI)
          CALL SPLY(COUNTS(IST),COUNTS(IY2),N,XX,YI)
        END IF          
*
* Sum up interpolated values
*
        IF(OPTION.EQ.1) THEN
          SUM  = SUM + XCOR
        ELSE
          SUM1 = SUM1 + XI
          SUM2 = SUM2 + YI
        END IF

C        IF(CYCLE.EQ.1 .AND. REJECT .AND. FIRST) THEN
*
* Checks through a spectrum for large deviations. Only useful if
* at best fit, and needs option=1 to get estimates for f-values.
* Must be FIRST so that broadened templates are still available
*
C        END IF
      END DO
*
      IF(OPTION.EQ.2) THEN
        FAC =  SQRT(SUM2)
        DX1 = -SUM1/FAC+FLO*FAC
        DX2 = -SUM1/FAC+FHI*FAC
        FAC =  LGAUSS(DX1,DX2)-LOG(FAC)
        SUM =  SUM1**2/SUM2/2.+FAC
      END IF
*
* Return negative so that when we minimise BAYES 
* we maximise the log probability
*
      FC = - SUM
      IFAIL = 0
      RETURN
999   FC = 0.D0
      RETURN
      END

      SUBROUTINE GTPAR(FIX,PAR,SPAR,PLO,PHI,I,J,K,N)
*
* Alters either PAR or SPAR according to value of FIX
* to update parameter values to be sent to BAYES
*
* I = number of step
* J = number of parameter
* K = position in parameter array to be sent to Bayes (free only)
*
      IMPLICIT NONE
      CHARACTER*5 FIX
      INTEGER I,J,K,N
      DOUBLE PRECISION PAR(5), SPAR(5)
      DOUBLE PRECISION PLO(5), PHI(5)
*
      IF(FIX(J:J).EQ.'0') THEN
        IF(N.EQ.1) THEN
          PAR(K) = (PLO(J) + PHI(J))/2.
        ELSE
          PAR(K) = PLO(J) + (PHI(J)-PLO(J))*DBLE(I-1)/DBLE(N-1)
        END IF
      ELSE IF(FIX(J:J).EQ.'2') THEN
        IF(N.EQ.1) THEN
          SPAR(J) = (PLO(J) + PHI(J))/2.
        ELSE
          SPAR(J) = PLO(J) + (PHI(J)-PLO(J))*DBLE(I-1)/DBLE(N-1)
        END IF
      END IF
      RETURN
      END

      SUBROUTINE PARROT(NAME,FIX,PMAX,SPAR,PRMAX)
*
* Output info to terminal
*
      IMPLICIT NONE
      CHARACTER*(*) NAME(5)
      CHARACTER*5 FIX
      INTEGER I, K
      DOUBLE PRECISION PMAX, SPAR(5), PRMAX(5)
*
      WRITE(*,*) 'Max prob = ',PMAX
      K = 0
      DO I = 1, 5
        IF(FIX(I:I).EQ.'0') THEN
          K = K + 1
          WRITE(*,*) 'F: ',NAME(I),PRMAX(K)
        ELSE
          WRITE(*,*) 'S: ',NAME(I),SPAR(I)
        END IF
      END DO
      RETURN
      END

      SUBROUTINE STAWY(DAT, NDAT, I, STORE)
*
      INTEGER NDAT, I
      REAL DAT(NDAT), STORE
*
      DAT(I) = STORE
      RETURN
      END

      SUBROUTINE BYINT3(PAR, XLO, XHI, SS, DMAX, ACC)
*
* Romberg integration of EXP(-BAYES) from X1 to X2 over
* third variable dimension.
*
      IMPLICIT NONE
      INTEGER J, JMAX, JMAXP, K, KM
      INTEGER IFAIL
      PARAMETER (JMAX=20, JMAXP=JMAX+1, K=5, KM=K-1)
      DOUBLE PRECISION PAR(5), DMAX, XLO(3), XHI(3)
      REAL ACC
      DOUBLE PRECISION S(JMAXP), H(JMAXP), SS, DSS
*       
      H(1) = 1.D0
      DO J = 1, JMAX
        CALL TRAPBY3(PAR, DMAX, XLO, XHI, S(J), J, ACC)
        IF(J.GE.K) THEN
          CALL POLINT(H(J-KM),S(J-KM),K,0.D0, SS, DSS, IFAIL)
          IF(IFAIL.NE.0) WRITE(*,*) 'POLINT failed.'
          IF(ABS(DSS).LT.ACC*ABS(SS)) RETURN
        END IF
        S(J+1) = S(J)
        H(J+1) = 0.25*H(J)
      END DO
      WRITE(*,*) 'Too many integration steps'
      RETURN
      END

      SUBROUTINE TRAPBY3(PAR, DMAX, XLO, XHI, F, N, ACC)
*
* Basic trapezoidal int over third variable dimension
*
      INTEGER N, IT
      REAL B, B1, B2, ACC
      DOUBLE PRECISION XLO(3), XHI(3), F
      DOUBLE PRECISION X, DMAX, TNM, DEL
      DOUBLE PRECISION SUM, PAR(5)
*
      IF(N.EQ.1) THEN
        PAR(3) = XLO(3)
        CALL BYINT2(PAR, XLO, XHI, B1, DMAX, ACC)
        PAR(3) = XHI(3)
        CALL BYINT2(PAR, XLO, XHI, B2, DMAX, ACC)
        F = 0.5*(XHI(3)-XLO(3))*(B1+B2)
        IT = 1
      ELSE
        TNM = REAL(IT)
        DEL = (XHI(3)-XLO(3))/TNM
        X   = XLO(3)+DEL/2.D0
        SUM = 0.D0
        DO J = 1, IT
          PAR(3) = X
          CALL BYINT2(PAR, XLO, XHI, B, DMAX, ACC)
          SUM = SUM + B
          X = X + DEL
        END DO
        F = 0.5*(F+(XHI(3)-XLO(3))*SUM/TNM)
        IT = 2*IT
      END IF
      RETURN
      END

      SUBROUTINE BYINT2(PAR, XLO, XHI, SS, DMAX, ACC)
*
* Romberg integration of EXP(-BAYES) from X1 to X2 over
* second variable dimension.
*
      IMPLICIT NONE
      INTEGER J, JMAX, JMAXP, K, KM
      INTEGER IFAIL
      PARAMETER (JMAX=20, JMAXP=JMAX+1, K=5, KM=K-1)
      DOUBLE PRECISION PAR(5), DMAX, XLO(2), XHI(2)
      REAL ACC
      DOUBLE PRECISION S(JMAXP), H(JMAXP), SS, DSS
*       
      H(1) = 1.D0
      DO J = 1, JMAX
        CALL TRAPBY2(PAR, DMAX, XLO, XHI, S(J), J, ACC)
        WRITE(*,*) 'BYINT2: ',J,H(J),S(J)
        IF(J.GE.K) THEN
          CALL POLINT(H(J-KM),S(J-KM),K,0.D0, SS, DSS, IFAIL)
          IF(IFAIL.NE.0) WRITE(*,*) 'POLINT failed.'
          IF(ABS(DSS).LT.ACC*ABS(SS)) RETURN
        END IF
        S(J+1) = S(J)
        H(J+1) = 0.25*H(J)
      END DO
      WRITE(*,*) 'Too many integration steps'
      RETURN
      END

      SUBROUTINE TRAPBY2(PAR, DMAX, XLO, XHI, F, N, ACC)
*
* Basic trapezoidal int over second variable dimension
*
      INTEGER N, IT
      REAL B, B1, B2, ACC
      DOUBLE PRECISION XLO(2), XHI(2), F
      DOUBLE PRECISION X, DMAX, TNM, DEL
      DOUBLE PRECISION SUM, PAR(5)
*
      IF(N.EQ.1) THEN
        PAR(2) = XLO(2)
        CALL BYINT1(PAR, XLO, XHI, B1, DMAX, ACC)
        PAR(2) = XHI(2)
        CALL BYINT1(PAR, XLO, XHI, B2, DMAX, ACC)
        F = 0.5*(XHI(2)-XLO(2))*(B1+B2)
        IT = 1
      ELSE
        TNM = REAL(IT)
        DEL = (XHI(2)-XLO(2))/TNM
        X   = XLO(2)+DEL/2.D0
        SUM = 0.D0
        DO J = 1, IT
          PAR(2) = X
          CALL BYINT1(PAR, XLO, XHI, B, DMAX, ACC)
          SUM = SUM + B
          X = X + DEL
        END DO
        F = 0.5*(F+(XHI(2)-XLO(2))*SUM/TNM)
        IT = 2*IT
      END IF
      RETURN
      END

      SUBROUTINE BYINT1(PAR, XLO, XHI, SS, DMAX, ACC)
*
* Romberg integration of EXP(-BAYES-DMAX) over first variable
* dimension.
*
      IMPLICIT NONE
      INTEGER J, JMAX, JMAXP, K, KM
      INTEGER IFAIL
      PARAMETER (JMAX=20, JMAXP=JMAX+1, K=5, KM=K-1)
      DOUBLE PRECISION PAR(5), DMAX, XLO, XHI
      REAL ACC
      DOUBLE PRECISION S(JMAXP), H(JMAXP), SS, DSS
*       
      H(1) = 1.D0
      DO J = 1, JMAX
        CALL TRAPBY1(PAR, DMAX, XLO, XHI, S(J), J)
        IF(J.GE.K) THEN
          CALL POLINT(H(J-KM),S(J-KM),K,0., SS, DSS, IFAIL)
          IF(IFAIL.NE.0) WRITE(*,*) 'POLINT failed.'
          IF(ABS(DSS).LT.ACC*ABS(SS)) RETURN
        END IF
        S(J+1) = S(J)
        H(J+1) = 0.25*H(J)
      END DO
      WRITE(*,*) 'Too many integration steps'
      RETURN
      END

      SUBROUTINE TRAPBY1(PAR, DMAX, XLO, XHI, F, N)
*
* Basic trapezoidal int over 1st variable dimension
*
      INTEGER NOPT, N, IT, IW
      DOUBLE PRECISION X, DMAX, TNM, DEL, F
      DOUBLE PRECISION XLO, XHI, B, B1, B2, GC(5)
      DOUBLE PRECISION SUM, WD, PAR(5)
*
      IF(N.EQ.1) THEN
        PAR(1) = XLO
        CALL BAYES(1, NOPT, PAR, B1, GC, IW, 1, WD, 1)
        PAR(1) = XHI
        CALL BAYES(1, NOPT, PAR, B2, GC, IW, 1, WD, 1)
        F = 0.5*(XHI-XLO)*(EXP(-B1-DMAX)+EXP(-B2-DMAX))
        IT = 1
      ELSE
        TNM = REAL(IT)
        DEL = (XHI-XLO)/TNM
        X = XLO+DEL/2.D0
        SUM = 0.D0
        DO J = 1, IT
          PAR(1) = X
          CALL BAYES(1, NOPT, PAR, B, GC, IW, 1, WD, 1)
          SUM = SUM + EXP(-B-DMAX)
          X = X + DEL
        END DO
        F = 0.5*(F+(XHI-XLO)*SUM/TNM)
        IT = 2*IT
      END IF
      RETURN
      END

