      SUBROUTINE RTHEAD(LUNIT, FCODE, UNITS, NPIX, NARC, NCHAR, 
     &NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, IFAIL)
*
* Written by TRM 28/7/91
*
* Reads a spectrum header in TRM format. 
* It assumes that the first header found is the one you want. 
*
* See WTHEAD for definition of TRM format 
*
      IMPLICIT NONE
      INTEGER I, J, K, L,  IFAIL
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL
      INTEGER LUNIT, FCODE, NPIX, NARC
      INTEGER NCHAR, NDOUB, NINTR, NREAL
      CHARACTER*16     UNITS
      CHARACTER*(*)    NMCHAR(MXCHAR)
      CHARACTER*(*)    NMDOUB(MXDOUB)
      CHARACTER*(*)    NMINTR(MXINTR)
      CHARACTER*(*)    NMREAL(MXREAL)
      CHARACTER*(*)    HDCHAR(MXCHAR)
      DOUBLE PRECISION HDDOUB(MXDOUB)
      INTEGER          HDINTR(MXINTR)
      REAL             HDREAL(MXREAL)
*
* Read first line of essential information
*
      READ(LUNIT, IOSTAT=IFAIL, ERR=999) 
     &FCODE, UNITS, NPIX, NARC, NCHAR, NDOUB, NINTR, NREAL
      IF(NCHAR.GT.MXCHAR .OR. NDOUB.GT.MXDOUB .OR.
     &   NINTR.GT.MXINTR .OR. NREAL.GT.MXREAL) THEN
        WRITE(*,*) ' RTHEAD: Too many header parameters'
        WRITE(*,*) 'CDIR',NCHAR,NDOUB,NINTR,NREAL
        IFAIL = 1000
        RETURN
      END IF
      
*
* Read names of header parameters
*
      READ(LUNIT, IOSTAT=IFAIL, ERR=999) 
     &(NMCHAR(I),I=1,NCHAR),(NMDOUB(J),J=1,NDOUB),
     &(NMINTR(K),K=1,NINTR),(NMREAL(L),L=1,NREAL)
*
* Read values of header parameters
*
      READ(LUNIT, IOSTAT=IFAIL, ERR=999) 
     &(HDCHAR(I),I=1,NCHAR),(HDDOUB(J),J=1,NDOUB),
     &(HDINTR(K),K=1,NINTR),(HDREAL(L),L=1,NREAL)
999   CONTINUE
      IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'End of MOLLY file on trying to read headers'
      ELSE IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Error reading MOLLY headers'
      END IF
      RETURN
      END

      SUBROUTINE RTDATA(LUNIT, COUNTS, ERRORS, FLUX, ARC, FCODE, 
     &NPIX, NARC, IFAIL)
*
* Written by TRM 28/7/91
*
* Reads a spectrum in TRM format. 
* It assumes that the file is positioned on the data.
*
* Inputs
*
* I*4 FCODE -- Format code obtained from header.
* I*4 NPIX  -- Number of pixels obtained from header.
* I*4 NARC  -- Number of arc coefficients 
*
* See WTHEAD for definition of TRM format.
*
*
      IMPLICIT NONE
      INTEGER I
      INTEGER IFAIL, LUNIT, FCODE, NPIX, NARC
      REAL COUNTS(NPIX), ERRORS(NPIX), FLUX(NPIX)
      DOUBLE PRECISION ARC(*)
*     
* Read data 
*
      IFAIL = 0
      READ(LUNIT, IOSTAT=IFAIL, ERR=999) (ARC(I),I=1,ABS(NARC))
      IF(FCODE.EQ.1) THEN
c        READ(LUNIT, IOSTAT=IFAIL, ERR=999) COUNTS
        READ(LUNIT, IOSTAT=IFAIL, ERR=999) (COUNTS(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.2) THEN
c        READ(LUNIT, IOSTAT=IFAIL, ERR=999) COUNTS, ERRORS 
        READ(LUNIT, IOSTAT=IFAIL, ERR=999) (COUNTS(I),I=1,NPIX), 
     &        (ERRORS(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.3) THEN 
c         READ(LUNIT, IOSTAT=IFAIL, ERR=999) COUNTS, ERRORS, FLUX
         READ(LUNIT, IOSTAT=IFAIL, ERR=999) (COUNTS(I),I=1,NPIX), 
     &        (ERRORS(I),I=1,NPIX), (FLUX(I),I=1,NPIX)

      ELSE IF(FCODE.EQ.4) THEN
c        READ(LUNIT, IOSTAT=IFAIL, ERR=999) FLUX
        READ(LUNIT, IOSTAT=IFAIL, ERR=999) (FLUX(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.5) THEN
c        READ(LUNIT, IOSTAT=IFAIL, ERR=999) FLUX, ERRORS
        READ(LUNIT, IOSTAT=IFAIL, ERR=999) (FLUX(I),I=1,NPIX), 
     &        (ERRORS(I),I=1,NPIX)
      ELSE 
        WRITE(*,*) 'Invalid FCODE in RTDATA'
        IFAIL = 1000
        RETURN
      END IF

999   CONTINUE
      IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'End of MOLLY file on trying to read data'
      ELSE IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Error reading MOLLY data'
      END IF
      RETURN
      END

      SUBROUTINE WTHEAD(LUNIT, FCODE, UNITS, NPIX, NARC, NCHAR, 
     &NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, IFAIL)
*
* Written by TRM 28/7/91
*
* Writes a spectrum header in TRM format. 
*
**************************************************************************
*                                                                        *
* TRM format is defined as follows.                                      *
*                                                                        *
* The spectra are stored in an unformatted, sequential access file with  *
* 5 records per spectrum. The records are as follows:                    *
*                                                                        *
* Record number                                                          *
*                                                                        *
* (1) FCODE, UNITS, NPIX, NARC, NCHAR, NDOUB, NINTR, NREAL               *
*                                                                        *
*     I*4 FCODE    -- format code to indicate type of data.              *
*                                                                        *
*                     1 -- Counts only                                   *
*                     2 -- Counts, errors, no fluxes                     *
*                     3 -- Counts, errors, fluxes                        *
*                     4 -- Fluxes only                                   *
*                     5 -- Fluxes and errors                             *
*                                                                        *
*     C*16 UNITS   -- Units of flux (if present). Recognised so far:     *
*                     'MILLIJANSKYS'  -- Millijansky flux                *
*                                                                        *
*     I*4 NPIX     -- Number of spectrum points                          *
*     I*4 NARC     -- Number of arc coefficients                         *
*     I*4 NCHAR, NDOUB -- number of character, double, integer           *
*     I*4 NINTR, NREAL    and real header parameters.                    *
*     I*4 MXCHAR, MXDOUB -- dimensions declared in calling routine.      *
*     I*4 MXINTR, MXREAL                                                 *
*                                                                        *
* (2) NMCHAR(NCHAR),NMDOUB(NDOUB),NMINTR(NINTR),NMREAL(NREAL)            *
*                     Names of various header parameters.                *
*                                                                        *
* (3) HDCHAR(NCHAR),HDDOUB(NDOUB),HDINTR(NINTR),HDREAL(NREAL)            *
*                     Values of various header parameters.               *
*                                                                        *
* (4) ARC(ABS(NARC)) -- Arc coefficients. (NARC can be negative for      *
*                       logarithmic scale data).                         *
*                                                                        *
* (5) If FCODE = 1  then COUNTS(NPIX)                                    *
*        FCODE = 2       COUNTS(NPIX),ERRORS(NPIX)                       *
*        FCODE = 3       COUNTS(NPIX),ERRORS(NPIX),FLUX(NPIX)            *
*        FCODE = 4       FLUX(NPIX)                                      *
*        FCODE = 5       FLUX(NPIX),ERRORS(NPIX)                         *
*                                                                        *
*                                                                        *
**************************************************************************
*
      IMPLICIT NONE
      INTEGER I, J, K, L,  IFAIL
      INTEGER LUNIT, FCODE, NPIX, NARC
      INTEGER NCHAR, NDOUB, NINTR, NREAL
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL
      CHARACTER*16     UNITS
      CHARACTER*(*)    NMCHAR(MXCHAR)
      CHARACTER*(*)    NMDOUB(MXDOUB)
      CHARACTER*(*)    NMINTR(MXINTR)
      CHARACTER*(*)    NMREAL(MXREAL)
      CHARACTER*(*)    HDCHAR(MXCHAR)
      DOUBLE PRECISION HDDOUB(MXDOUB)
      INTEGER          HDINTR(MXINTR)
      REAL             HDREAL(MXREAL)
*
* Write first line of essential information
*
      WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) 
     &FCODE, UNITS, NPIX, NARC, NCHAR, NDOUB, NINTR, NREAL
*
* Write names of header parameters
*
      WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) 
     &(NMCHAR(I),I=1,NCHAR),(NMDOUB(J),J=1,NDOUB),
     &(NMINTR(K),K=1,NINTR),(NMREAL(L),L=1,NREAL)
*
* Write values of header parameters
*
      WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) 
     &(HDCHAR(I),I=1,NCHAR),(HDDOUB(J),J=1,NDOUB),
     &(HDINTR(K),K=1,NINTR),(HDREAL(L),L=1,NREAL)
999   CONTINUE
      IF(IFAIL.GT.0) WRITE(*,*) 'Error writing MOLLY headers'
      RETURN
      END

      SUBROUTINE WTDATA(LUNIT, COUNTS, ERRORS, FLUX, ARC, FCODE, 
     &NPIX, NARC, IFAIL)
*
* Written by TRM 28/7/91
*
* Writes a spectrum in TRM format. 
*
* Inputs
*
* R*4 COUNTS(NPIX)   -- Counts values 
* R*4 ERRORS(NPIX)   -- 1-sigma uncertainties
* R*4 FLUX(NPIX)     -- flux
* I*4 FCODE -- Format code obtained from header.
* I*4 NPIX  -- Number of pixels obtained from header.
* I*4 NARC  -- Number of arc coefficients 
*
* See WTHEAD for definition of TRM format.
*
*
      IMPLICIT NONE
      INTEGER I
      INTEGER IFAIL, LUNIT, FCODE, NPIX, NARC
      REAL COUNTS(NPIX), ERRORS(NPIX), FLUX(NPIX)
      DOUBLE PRECISION ARC(*)
*
* Write data 
*
      IFAIL = 0
      WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) (ARC(I),I=1,ABS(NARC))
      IF(FCODE.EQ.1) THEN
c        WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) COUNTS
        WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) (COUNTS(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.2) THEN
c     WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) COUNTS, ERRORS
         WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) (COUNTS(I),I=1,NPIX),
     &        (ERRORS(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.3) THEN
c     WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) COUNTS, ERRORS, FLUX
         WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) (COUNTS(I),I=1,NPIX),
     &        (ERRORS(I),I=1,NPIX),(FLUX(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.4) THEN
c     WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) FLUX
        WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) (FLUX(I),I=1,NPIX)
      ELSE IF(FCODE.EQ.5) THEN
C        WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) FLUX, ERRORS
        WRITE(LUNIT, IOSTAT=IFAIL, ERR=999) (FLUX(I),I=1,NPIX),
     &        (ERRORS(I),I=1,NPIX)
      ELSE 
        WRITE(*,*) 'Invalid FCODE in WTDATA'
        IFAIL = 1000
        RETURN
      END IF
999   CONTINUE
      IF(IFAIL.GT.0) WRITE(*,*) 'Error writing MOLLY data'
      RETURN
      END
